/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;
import org.hibernate.internal.util.NullnessUtil;

public class WebSphereLibertyJtaPlatform
extends AbstractJtaPlatform {
    public static final @UnknownKeyFor @NonNull @Initialized String TMF_CLASS_NAME = "com.ibm.tx.jta.TransactionManagerFactory";
    public static final @UnknownKeyFor @NonNull @Initialized String UT_NAME = "java:comp/UserTransaction";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TransactionManager locateTransactionManager() {
        try {
            Class TransactionManagerFactory = NullnessUtil.castNonNull(this.serviceRegistry().getService(ClassLoaderService.class)).classForName(TMF_CLASS_NAME);
            return (TransactionManager)TransactionManagerFactory.getMethod("getTransactionManager", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain WebSphere Liberty transaction manager instance", e);
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized UserTransaction locateUserTransaction() {
        return (UserTransaction)this.jndiService().locate(UT_NAME);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean canRegisterSynchronization() {
        try {
            return this.getCurrentStatus() == 0;
        }
        catch (SystemException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getCurrentStatus() throws @UnknownKeyFor @NonNull @Initialized SystemException {
        return NullnessUtil.castNonNull(this.retrieveTransactionManager()).getStatus();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getTransactionIdentifier(@UnknownKeyFor @NonNull @Initialized Transaction transaction) {
        return transaction;
    }

    @Override
    public void registerSynchronization(@UnknownKeyFor @NonNull @Initialized Synchronization synchronization) {
        try {
            NullnessUtil.castNonNull(this.retrieveTransactionManager()).getTransaction().registerSynchronization(synchronization);
        }
        catch (RollbackException | SystemException x) {
            throw new RuntimeException(x);
        }
    }
}

