/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.factory.internal;

import java.util.Properties;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.id.enhanced.LegacyNamingStrategy;
import org.hibernate.id.enhanced.SingleNamingStrategy;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;

public class IdentifierGeneratorUtil {
    public static Generator createLegacyIdentifierGenerator(SimpleValue simpleValue, IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) {
        Generator generator;
        Properties params = new Properties();
        if (defaultSchema != null) {
            params.setProperty("schema", defaultSchema);
        }
        if (defaultCatalog != null) {
            params.setProperty("catalog", defaultCatalog);
        }
        params.setProperty("initial_value", String.valueOf(1));
        ConfigurationService cs = simpleValue.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ConfigurationService.class);
        String idNamingStrategy = cs.getSetting("hibernate.id.db_structure_naming_strategy", StandardConverters.STRING, null);
        if ("legacy".equals(idNamingStrategy) || LegacyNamingStrategy.class.getName().equals(idNamingStrategy) || "single".equals(idNamingStrategy) || SingleNamingStrategy.class.getName().equals(idNamingStrategy)) {
            params.setProperty("increment_size", "1");
        } else {
            params.setProperty("increment_size", String.valueOf(50));
        }
        String tableName = simpleValue.getTable().getQuotedName(dialect);
        params.setProperty("target_table", tableName);
        String columnName = ((Column)simpleValue.getSelectables().get(0)).getQuotedName(dialect);
        params.setProperty("target_column", columnName);
        if (rootClass != null) {
            params.setProperty("entity_name", rootClass.getEntityName());
            params.setProperty("jpa_entity_name", rootClass.getJpaEntityName());
            if (simpleValue.getTable().isSubselect()) {
                params.setProperty("implicit_name_base", rootClass.getJpaEntityName());
            } else {
                params.setProperty("implicit_name_base", simpleValue.getTable().getName());
            }
            StringBuilder tables = new StringBuilder();
            for (Table table : rootClass.getIdentityTables()) {
                tables.append(table.getQuotedName(dialect));
                if (tables.length() <= 0) continue;
                tables.append(", ");
            }
            params.setProperty("identity_tables", tables.toString());
        } else {
            params.setProperty("identity_tables", tableName);
            params.setProperty("implicit_name_base", tableName);
        }
        if (simpleValue.getIdentifierGeneratorParameters() != null) {
            params.putAll(simpleValue.getIdentifierGeneratorParameters());
        }
        params.put("CONTRIBUTOR", simpleValue.getBuildingContext().getCurrentContributorName());
        if (cs.getSettings().get("hibernate.id.optimizer.pooled.preferred") != null) {
            params.put("hibernate.id.optimizer.pooled.preferred", cs.getSettings().get("hibernate.id.optimizer.pooled.preferred"));
        }
        if ((generator = identifierGeneratorFactory.createIdentifierGenerator(simpleValue.getIdentifierGeneratorStrategy(), simpleValue.getType(), params)).generatedOnExecution() && generator instanceof BeforeExecutionGenerator) {
            simpleValue.setNullValue("undefined");
        }
        return generator;
    }
}

