/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.WrapperOptions;

public class QueryLiteral<T>
implements Literal,
DomainResultProducer<T> {
    private final T value;
    private final SqlExpressible expressible;

    public QueryLiteral(T value, SqlExpressible expressible) {
        assert (value == null || expressible.getJdbcMapping().getJdbcJavaType().isInstance(value));
        this.value = value;
        this.expressible = expressible;
    }

    public T getLiteralValue() {
        return this.value;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.expressible.getJdbcMapping();
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitQueryLiteral(this);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expressible;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.expressible.getJdbcMapping().getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.expressible.getJdbcMapping());
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.expressible.getJdbcMapping().getJdbcValueBinder().bind(statement, this.getLiteralValue(), startPosition, (WrapperOptions)executionContext.getSession());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.expressible.getJdbcMapping().getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }
}

