/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable;

import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableLoadingLogger;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractEmbeddableInitializer
extends AbstractFetchParentAccess
implements EmbeddableInitializer,
ValueAccess {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embedded;
    private final FetchParentAccess fetchParentAccess;
    private final boolean isPartOfKey;
    private final boolean createEmptyCompositesEnabled;
    private final SessionFactoryImplementor sessionFactory;
    protected final DomainResultAssembler<?>[] assemblers;
    private final Object[] rowState;
    private State state = State.INITIAL;
    protected Object compositeInstance;
    private RowProcessingState wrappedProcessingState;

    public AbstractEmbeddableInitializer(EmbeddableResultGraphNode resultDescriptor, FetchParentAccess fetchParentAccess, AssemblerCreationState creationState) {
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = resultDescriptor.getReferencedMappingContainer();
        this.fetchParentAccess = fetchParentAccess;
        EmbeddableMappingType embeddableTypeDescriptor = this.embedded.getEmbeddableTypeDescriptor();
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        this.rowState = new Object[size];
        this.isPartOfKey = AbstractEmbeddableInitializer.isPartOfKey(this.embedded, this.navigablePath, fetchParentAccess);
        this.createEmptyCompositesEnabled = !this.isPartOfKey && embeddableTypeDescriptor.isCreateEmptyCompositesEnabled();
        this.sessionFactory = creationState.getSqlAstCreationContext().getSessionFactory();
        this.assemblers = this.createAssemblers(resultDescriptor, creationState, embeddableTypeDescriptor);
    }

    private static boolean isPartOfKey(EmbeddableValuedModelPart modelPart, NavigablePath navigablePath, FetchParentAccess fetchParentAccess) {
        return modelPart.isEntityIdentifierMapping() || "{fk}".equals(navigablePath.getLocalName()) || "{fk-target}".equals(navigablePath.getLocalName()) || navigablePath instanceof EntityIdentifierNavigablePath || fetchParentAccess != null && fetchParentAccess.isEmbeddableInitializer() && ((AbstractEmbeddableInitializer)fetchParentAccess).isPartOfKey;
    }

    protected DomainResultAssembler<?>[] createAssemblers(EmbeddableResultGraphNode resultDescriptor, AssemblerCreationState creationState, EmbeddableMappingType embeddableTypeDescriptor) {
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        DomainResultAssembler[] assemblers = new DomainResultAssembler[size];
        for (int i = 0; i < size; ++i) {
            DomainResultAssembler<?> stateAssembler;
            Fetchable stateArrayContributor = embeddableTypeDescriptor.getFetchable(i);
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor);
            assemblers[i] = stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(this, creationState);
        }
        return assemblers;
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.state == State.NULL ? null : this.compositeInstance;
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        if (this.fetchParentAccess == null || this.embedded instanceof CollectionPart) {
            return null;
        }
        return this.fetchParentAccess.findFirstEntityDescriptorAccess();
    }

    @Override
    public EntityInitializer findFirstEntityInitializer() {
        FetchParentAccess firstEntityDescriptorAccess = this.findFirstEntityDescriptorAccess();
        if (firstEntityDescriptorAccess == null) {
            return null;
        }
        return firstEntityDescriptorAccess.findFirstEntityInitializer();
    }

    @Override
    public void resolveKey(RowProcessingState processingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState processingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState processingState) {
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Initializing composite instance [%s]", (Object)this.navigablePath);
        switch (this.state) {
            case NULL: {
                return;
            }
            case INITIAL: {
                this.state = this.determinInitialState();
                if (this.state != State.INITIAL) {
                    return;
                }
                if (this.wrappedProcessingState == null) {
                    this.wrappedProcessingState = this.wrapProcessingState(processingState);
                }
                this.extractRowState(this.wrappedProcessingState);
                this.prepareCompositeInstance(this.wrappedProcessingState);
                if (this.state == State.NULL) {
                    return;
                }
                this.notifyResolutionListeners(this.compositeInstance);
            }
            case EXTRACTED: {
                if (this.embedded.getParentInjectionAttributePropertyAccess() != null || this.embedded instanceof VirtualModelPart) {
                    this.handleParentInjection(this.wrappedProcessingState);
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.compositeInstance);
                    if (lazyInitializer != null) {
                        Initializer parentInitializer = this.wrappedProcessingState.resolveInitializer(this.navigablePath.getParent());
                        if (parentInitializer != this) {
                            ((FetchParentAccess)parentInitializer).registerResolutionListener(entity -> {
                                this.embedded.getEmbeddableTypeDescriptor().setValues(entity, this.rowState);
                                this.state = State.INJECTED;
                            });
                            break;
                        }
                        Object target = this.embedded.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(this, this.sessionFactory);
                        this.state = State.INJECTED;
                        lazyInitializer.setImplementation(target);
                        break;
                    }
                    this.embedded.getEmbeddableTypeDescriptor().setValues(this.compositeInstance, this.rowState);
                    this.state = State.INJECTED;
                    break;
                }
                this.state = State.INJECTED;
            }
        }
    }

    private void prepareCompositeInstance(RowProcessingState processingState) {
        if (this.fetchParentAccess != null && this.embedded instanceof VirtualModelPart && !this.isPartOfKey) {
            this.fetchParentAccess.resolveInstance(processingState);
            this.compositeInstance = this.fetchParentAccess.getInitializedInstance();
            EntityInitializer entityInitializer = this.fetchParentAccess.asEntityInitializer();
            if (entityInitializer != null && entityInitializer.isEntityInitialized()) {
                return;
            }
        }
        if (this.compositeInstance == null) {
            this.compositeInstance = this.createCompositeInstance(this.navigablePath, this.sessionFactory);
        }
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Created composite instance [%s]", (Object)this.navigablePath);
    }

    private State determinInitialState() {
        EntityInitializer entityInitializer = this.getOwningEntityInitializer();
        if (entityInitializer != null) {
            if (entityInitializer.getParentKey() == null) {
                return State.NULL;
            }
            if (!entityInitializer.getConcreteDescriptor().isTypeOrSuperType(this.embedded.findContainingEntityMapping())) {
                return State.NULL;
            }
            if (entityInitializer.isEntityInitialized() && !(this.embedded instanceof EmbeddedCollectionPart)) {
                return State.INJECTED;
            }
        }
        return State.INITIAL;
    }

    private EntityInitializer getOwningEntityInitializer() {
        FetchParentAccess parentAccess;
        if (this.isPartOfKey) {
            return null;
        }
        for (parentAccess = this.fetchParentAccess; parentAccess != null && parentAccess.isEmbeddableInitializer(); parentAccess = parentAccess.getFetchParentAccess()) {
            assert (!(parentAccess.getInitializedPart() instanceof CompositeIdentifierMapping)) : "isPartOfKey should have been true in this case";
        }
        if (parentAccess == null) {
            return null;
        }
        EntityInitializer entityInitializer = parentAccess.asEntityInitializer();
        return entityInitializer;
    }

    private void extractRowState(RowProcessingState processingState) {
        boolean stateAllNull = true;
        for (int i = 0; i < this.assemblers.length; ++i) {
            DomainResultAssembler<?> assembler = this.assemblers[i];
            Object contributorValue = assembler.assemble(processingState, processingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
            this.rowState[i] = contributorValue == BatchEntityInsideEmbeddableSelectFetchInitializer.BATCH_PROPERTY ? null : contributorValue;
            if (contributorValue != null) {
                stateAllNull = false;
                continue;
            }
            if (!this.isPartOfKey) continue;
            stateAllNull = true;
            break;
        }
        this.state = stateAllNull ? State.NULL : State.EXTRACTED;
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        if (this.determinInitialState() == State.INITIAL) {
            for (DomainResultAssembler<?> assembler : this.assemblers) {
                assembler.resolveState(rowProcessingState);
            }
        }
    }

    private Object createCompositeInstance(NavigablePath navigablePath, SessionFactoryImplementor sessionFactory) {
        if (this.state == State.NULL && !this.createEmptyCompositesEnabled) {
            return null;
        }
        Object instance = this.embedded.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(this, sessionFactory);
        this.state = State.EXTRACTED;
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Created composite instance [%s] : %s", (Object)navigablePath, instance);
        return instance;
    }

    @Override
    public Object[] getValues() {
        return this.state == State.NULL ? null : this.rowState;
    }

    @Override
    public <T> T getValue(int i, Class<T> clazz) {
        return this.state == State.NULL ? null : (T)clazz.cast(this.rowState[i]);
    }

    @Override
    public Object getOwner() {
        return this.fetchParentAccess.getInitializedInstance();
    }

    private void handleParentInjection(RowProcessingState processingState) {
        HibernateProxy proxy;
        PropertyAccess parentInjectionAccess = this.embedded.getParentInjectionAttributePropertyAccess();
        if (parentInjectionAccess == null) {
            return;
        }
        Initializer parentInitializer = this.determineParentInitializer(processingState);
        Object parent = this.determineParentInstance(parentInitializer);
        if (parent == null) {
            EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Unable to determine parent for injection into embeddable [%s]", (Object)this.navigablePath);
            return;
        }
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Injecting parent into embeddable [%s] : `%s` -> `%s`", (Object)this.navigablePath, parent, this.compositeInstance);
        if (this.fetchParentAccess != null && (proxy = ManagedTypeHelper.asHibernateProxyOrNull(parent)) != null) {
            assert (parentInitializer != null);
            assert (parentInitializer instanceof EntityInitializer);
            parentInitializer.asEntityInitializer().registerResolutionListener(o -> parentInjectionAccess.getSetter().set(this.compositeInstance, proxy.getHibernateLazyInitializer().getImplementation()));
        } else {
            parentInjectionAccess.getSetter().set(this.compositeInstance, parent);
        }
    }

    private Initializer determineParentInitializer(RowProcessingState processingState) {
        if (this.fetchParentAccess != null) {
            return this.fetchParentAccess.findFirstEntityDescriptorAccess();
        }
        NavigablePath parentPath = this.navigablePath.getParent();
        assert (parentPath != null);
        return processingState.resolveInitializer(parentPath);
    }

    private Object determineParentInstance(Initializer parentInitializer) {
        if (parentInitializer == null) {
            throw new UnsupportedOperationException("Cannot determine Embeddable: " + this.navigablePath + " parent instance, parent initializer is null");
        }
        if (parentInitializer.isCollectionInitializer()) {
            return ((CollectionInitializer)parentInitializer).getCollectionInstance().getOwner();
        }
        EntityInitializer parentEntityInitializer = parentInitializer.asEntityInitializer();
        if (parentEntityInitializer != null) {
            return parentEntityInitializer.getInitializedInstance();
        }
        throw new UnsupportedOperationException("The Embeddable: " + this.navigablePath + " parent initializer is neither an instance of an EntityInitializer nor of a CollectionInitializer");
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.state = State.INITIAL;
        this.wrappedProcessingState = null;
        this.clearResolutionListeners();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath + ") : `" + this.getInitializedPart().getJavaType().getJavaTypeClass() + "`";
    }

    static enum State {
        INITIAL,
        EXTRACTED,
        NULL,
        INJECTED;

    }
}

