/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.annotation;

import java.util.Map;
import java.util.function.Predicate;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.vault.core.env.LeaseAwareVaultPropertySource;
import org.springframework.vault.core.env.VaultPropertySource;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.util.PropertyTransformers;

class PropertySourceAotProcessor
implements BeanRegistrationAotProcessor {
    PropertySourceAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (registeredBean.getBeanClass() == LeaseAwareVaultPropertySource.class) {
            return BeanRegistrationAotContribution.withCustomCodeFragments(AotContribution::new);
        }
        if (registeredBean.getBeanClass() == VaultPropertySource.class) {
            return BeanRegistrationAotContribution.withCustomCodeFragments(AotContribution::new);
        }
        return null;
    }

    static class AotContribution
    extends BeanRegistrationCodeFragmentsDecorator {
        protected AotContribution(BeanRegistrationCodeFragments delegate) {
            super(delegate);
        }

        public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
            CodeBlock.Builder code = CodeBlock.builder();
            ConstructorArgumentValues values = beanDefinition.getConstructorArgumentValues();
            for (Map.Entry entry : values.getIndexedArgumentValues().entrySet()) {
                CodeBlock renderedValue = AotContribution.render(((ConstructorArgumentValues.ValueHolder)entry.getValue()).getValue());
                code.addStatement("$N.getConstructorArgumentValues().addIndexedArgumentValue($L, $L)", new Object[]{"beanDefinition", entry.getKey(), renderedValue});
            }
            return code.build();
        }

        private static CodeBlock render(@Nullable Object value) {
            RuntimeBeanReference runtimeBeanReference;
            if (value instanceof RuntimeBeanReference && (runtimeBeanReference = (RuntimeBeanReference)value).getBeanType() != null) {
                return CodeBlock.of((String)"new $T($T.class)", (Object[])new Object[]{RuntimeBeanReference.class, runtimeBeanReference.getBeanType()});
            }
            if (value instanceof BeanReference) {
                BeanReference beanReference = (BeanReference)value;
                return CodeBlock.of((String)"new $T($S)", (Object[])new Object[]{RuntimeBeanReference.class, beanReference.getBeanName()});
            }
            if (value instanceof String) {
                return CodeBlock.of((String)"$S", (Object[])new Object[]{value.toString()});
            }
            if (value == null || ClassUtils.isPrimitiveOrWrapper(value.getClass())) {
                return CodeBlock.of((String)"$L", (Object[])new Object[]{value != null ? value.toString() : "null"});
            }
            if (value instanceof PropertyTransformers.NoOpPropertyTransformer) {
                return CodeBlock.of((String)"$T.$N()", (Object[])new Object[]{PropertyTransformers.class, "noop"});
            }
            if (value instanceof PropertyTransformers.KeyPrefixPropertyTransformer) {
                PropertyTransformers.KeyPrefixPropertyTransformer kpt = (PropertyTransformers.KeyPrefixPropertyTransformer)value;
                return CodeBlock.of((String)"$T.$N($S)", (Object[])new Object[]{PropertyTransformers.class, "propertyNamePrefix", kpt.getPropertyNamePrefix()});
            }
            if (value instanceof RequestedSecret) {
                RequestedSecret rs = (RequestedSecret)value;
                return CodeBlock.of((String)"$T.$N($S)", (Object[])new Object[]{RequestedSecret.class, rs.getMode() == RequestedSecret.Mode.ROTATE ? "rotating" : "renewable", rs.getPath()});
            }
            throw new IllegalArgumentException("Unsupported value type: " + value.getClass());
        }
    }
}

