/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.service.ServiceRegistry;

public class SingleNamingStrategy
implements ImplicitDatabaseObjectNamingStrategy {
    public static final String STRATEGY_NAME = "single";

    @Override
    public QualifiedName determineSequenceName(Identifier catalogName, Identifier schemaName, Map<?, ?> configValues, ServiceRegistry serviceRegistry) {
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        return new QualifiedSequenceName(catalogName, schemaName, jdbcEnvironment.getIdentifierHelper().toIdentifier("hibernate_sequence"));
    }

    @Override
    public QualifiedName determineTableName(Identifier catalogName, Identifier schemaName, Map<?, ?> configValues, ServiceRegistry serviceRegistry) {
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        return new QualifiedNameParser.NameParts(catalogName, schemaName, jdbcEnvironment.getIdentifierHelper().toIdentifier("hibernate_sequences"));
    }
}

