/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.api.tenant;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.credential.store.api.CredentialMetadata;
import org.apache.custos.core.exception.UnauthorizedException;
import org.apache.custos.core.federated.authentication.api.CacheManipulationRequest;
import org.apache.custos.core.federated.authentication.api.GetInstitutionsResponse;
import org.apache.custos.core.federated.authentication.api.Status;
import org.apache.custos.core.iam.api.AddProtocolMapperRequest;
import org.apache.custos.core.iam.api.AddRolesRequest;
import org.apache.custos.core.iam.api.AllRoles;
import org.apache.custos.core.iam.api.DeleteRoleRequest;
import org.apache.custos.core.iam.api.EventPersistenceRequest;
import org.apache.custos.core.iam.api.GetRolesRequest;
import org.apache.custos.core.iam.api.OperationStatus;
import org.apache.custos.core.tenant.management.api.CreateTenantResponse;
import org.apache.custos.core.tenant.management.api.Credentials;
import org.apache.custos.core.tenant.management.api.DeleteTenantRequest;
import org.apache.custos.core.tenant.management.api.GetTenantRequest;
import org.apache.custos.core.tenant.management.api.TenantValidationRequest;
import org.apache.custos.core.tenant.management.api.UpdateTenantRequest;
import org.apache.custos.core.tenant.profile.api.GetAllTenantsForUserRequest;
import org.apache.custos.core.tenant.profile.api.GetAllTenantsForUserResponse;
import org.apache.custos.core.tenant.profile.api.GetAllTenantsResponse;
import org.apache.custos.core.tenant.profile.api.GetAttributeUpdateAuditTrailResponse;
import org.apache.custos.core.tenant.profile.api.GetAuditTrailRequest;
import org.apache.custos.core.tenant.profile.api.GetStatusUpdateAuditTrailResponse;
import org.apache.custos.core.tenant.profile.api.GetTenantsRequest;
import org.apache.custos.core.tenant.profile.api.Tenant;
import org.apache.custos.core.tenant.profile.api.UpdateStatusRequest;
import org.apache.custos.core.tenant.profile.api.UpdateStatusResponse;
import org.apache.custos.service.auth.AuthClaim;
import org.apache.custos.service.auth.TokenAuthorizer;
import org.apache.custos.service.management.TenantManagementService;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/v1/tenant-management"})
@Tag(name="Tenant Management")
public class TenantManagementController {
    private final TenantManagementService tenantManagementService;
    private final TokenAuthorizer tokenAuthorizer;

    public TenantManagementController(TenantManagementService tenantManagementService, TokenAuthorizer tokenAuthorizer) {
        this.tenantManagementService = tenantManagementService;
        this.tokenAuthorizer = tokenAuthorizer;
    }

    @PostMapping(value={"/oauth2/tenant"})
    public ResponseEntity<CreateTenantResponse> createTenant(@Valid @RequestBody Tenant request, @RequestHeader HttpHeaders headers) {
        Optional claim;
        String token = this.tokenAuthorizer.getToken(headers);
        if (StringUtils.isBlank((CharSequence)token) && (claim = this.tokenAuthorizer.authorize(headers)).isPresent()) {
            AuthClaim authClaim = (AuthClaim)claim.get();
            request = request.toBuilder().setParentTenantId(authClaim.getTenantId()).build();
        }
        CreateTenantResponse response = this.tenantManagementService.createTenant(request);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/oauth2/tenant"})
    public ResponseEntity<Tenant> getTenant(@Valid @RequestBody GetTenantRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        }
        AuthClaim authClaim = (AuthClaim)claim.get();
        Credentials credentials = this.getCredentials(authClaim);
        request = request.toBuilder().setTenantId(authClaim.getTenantId()).setCredentials(credentials).build();
        Tenant response = this.tenantManagementService.getTenant(request);
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/user/profile"})
    public ResponseEntity<Tenant> updateTenant(@Valid @RequestBody UpdateTenantRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        }
        AuthClaim authClaim = (AuthClaim)claim.get();
        Credentials credentials = this.getCredentials(authClaim);
        request = request.toBuilder().setTenantId(authClaim.getTenantId()).setCredentials(credentials).build();
        Tenant response = this.tenantManagementService.updateTenant(request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/user"})
    public ResponseEntity<?> deleteTenant(@Valid @RequestBody DeleteTenantRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        }
        AuthClaim authClaim = (AuthClaim)claim.get();
        Credentials credentials = this.getCredentials(authClaim);
        request = request.toBuilder().setTenantId(authClaim.getTenantId()).setCredentials(credentials).build();
        this.tenantManagementService.deleteTenant(request);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/tenant/credentials/status"})
    public ResponseEntity<OperationStatus> validateTenant(@Valid @RequestBody TenantValidationRequest request) {
        OperationStatus response = this.tenantManagementService.validateTenant(request);
        return ResponseEntity.ok((Object)response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"/roles"})
    public ResponseEntity<AllRoles> addTenantRoles(@Valid @RequestBody AddRolesRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        AuthClaim authClaim = (AuthClaim)claim.get();
        if (StringUtils.isBlank((CharSequence)request.getClientId())) {
            request = request.toBuilder().setTenantId(authClaim.getTenantId()).setClientId(authClaim.getCustosId()).build();
        } else {
            CredentialMetadata metadata = this.tokenAuthorizer.getCredentialsFromClientId(request.getClientId());
            if (!authClaim.isSuperTenant() && !this.tokenAuthorizer.validateParentChildTenantRelationShip(authClaim.getTenantId(), metadata.getOwnerId())) throw new UnauthorizedException("Request is not authorized, user not authorized with the requested clientId: " + request.getClientId());
            request = request.toBuilder().setTenantId(metadata.getOwnerId()).build();
        }
        AllRoles response = this.tenantManagementService.addTenantRoles(request);
        return ResponseEntity.ok((Object)response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GetMapping(value={"/roles"})
    public ResponseEntity<AllRoles> getTenantRoles(@Valid @RequestBody GetRolesRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        AuthClaim authClaim = (AuthClaim)claim.get();
        if (StringUtils.isBlank((CharSequence)request.getClientId())) {
            request = request.toBuilder().setTenantId(authClaim.getTenantId()).setClientId(authClaim.getCustosId()).build();
        } else {
            CredentialMetadata metadata = this.tokenAuthorizer.getCredentialsFromClientId(request.getClientId());
            if (!authClaim.isSuperTenant() && !this.tokenAuthorizer.validateParentChildTenantRelationShip(authClaim.getTenantId(), metadata.getOwnerId())) throw new UnauthorizedException("Request is not authorized, user not authorized with the requested clientId: " + request.getClientId());
            request = request.toBuilder().setTenantId(metadata.getOwnerId()).build();
        }
        AllRoles response = this.tenantManagementService.getTenantRoles(request);
        return ResponseEntity.ok((Object)response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DeleteMapping(value={"/role"})
    public ResponseEntity<OperationStatus> deleteRole(@Valid @RequestBody DeleteRoleRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        AuthClaim authClaim = (AuthClaim)claim.get();
        if (StringUtils.isBlank((CharSequence)request.getClientId())) {
            request = request.toBuilder().setTenantId(authClaim.getTenantId()).setClientId(authClaim.getCustosId()).build();
        } else {
            CredentialMetadata metadata = this.tokenAuthorizer.getCredentialsFromClientId(request.getClientId());
            if (!authClaim.isSuperTenant() && !this.tokenAuthorizer.validateParentChildTenantRelationShip(authClaim.getTenantId(), metadata.getOwnerId())) throw new UnauthorizedException("Request is not authorized, user not authorized with the requested clientId: " + request.getClientId());
            request = request.toBuilder().setTenantId(metadata.getOwnerId()).build();
        }
        OperationStatus response = this.tenantManagementService.deleteRole(request);
        return ResponseEntity.ok((Object)response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"/protocol/mapper"})
    public ResponseEntity<OperationStatus> addProtocolMapper(@Valid @RequestBody AddProtocolMapperRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        AuthClaim authClaim = (AuthClaim)claim.get();
        if (StringUtils.isBlank((CharSequence)request.getClientId())) {
            request = request.toBuilder().setTenantId(authClaim.getTenantId()).setClientId(authClaim.getCustosId()).build();
        } else {
            CredentialMetadata metadata = this.tokenAuthorizer.getCredentialsFromClientId(request.getClientId());
            if (!authClaim.isSuperTenant() && !this.tokenAuthorizer.validateParentChildTenantRelationShip(authClaim.getTenantId(), metadata.getOwnerId())) throw new UnauthorizedException("Request is not authorized, user not authorized with the requested clientId: " + request.getClientId());
            request = request.toBuilder().setTenantId(metadata.getOwnerId()).build();
        }
        OperationStatus response = this.tenantManagementService.addProtocolMapper(request);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/events"})
    public ResponseEntity<OperationStatus> configureEventPersistence(@Valid @RequestBody EventPersistenceRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        }
        request = request.toBuilder().setTenantId(((AuthClaim)claim.get()).getTenantId()).setPerformedBy(((AuthClaim)claim.get()).getPerformedBy()).build();
        OperationStatus response = this.tenantManagementService.configureEventPersistence(request);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/status"})
    public ResponseEntity<UpdateStatusResponse> updateTenantStatus(@Valid @RequestBody UpdateStatusRequest request) {
        UpdateStatusResponse response = this.tenantManagementService.updateTenantStatus(request);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/tenants"})
    public ResponseEntity<GetAllTenantsResponse> getAllTenants(@Valid @RequestBody GetTenantsRequest request) {
        GetAllTenantsResponse response = this.tenantManagementService.getAllTenants(request);
        return ResponseEntity.ok((Object)response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GetMapping(value={"/child/tenants"})
    public ResponseEntity<GetAllTenantsResponse> getChildTenants(@Valid @RequestBody GetTenantsRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorizeUsingUserToken(headers);
        if (!claim.isPresent()) throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
        AuthClaim authClaim = (AuthClaim)claim.get();
        if (StringUtils.isBlank((CharSequence)request.getParentClientId())) {
            request = request.toBuilder().setParentId(authClaim.getTenantId()).build();
        } else {
            CredentialMetadata metadata = this.tokenAuthorizer.getCredentialsFromClientId(request.getParentClientId());
            if (!authClaim.isSuperTenant() && !this.tokenAuthorizer.validateParentChildTenantRelationShip(authClaim.getTenantId(), metadata.getOwnerId())) throw new UnauthorizedException("Request is not authorized, user not authorized with the requested clientId: " + request.getParentClientId());
            request = request.toBuilder().setParentId(metadata.getOwnerId()).build();
        }
        GetAllTenantsResponse response = this.tenantManagementService.getChildTenants(request);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/tenants/{requesterEmail}"})
    public ResponseEntity<GetAllTenantsForUserResponse> getAllTenantsForUser(@PathVariable(value="requesterEmail") String requesterEmail, @RequestHeader HttpHeaders headers) {
        this.tokenAuthorizer.authorize(headers);
        GetAllTenantsForUserResponse response = this.tenantManagementService.getAllTenantsForUser(GetAllTenantsForUserRequest.newBuilder().setRequesterEmail(requesterEmail).build());
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/audit/status/{tenantId}"})
    public ResponseEntity<GetStatusUpdateAuditTrailResponse> getTenantStatusUpdateAuditTrail(@PathVariable(value="tenantId") long tenantId) {
        GetStatusUpdateAuditTrailResponse response = this.tenantManagementService.getTenantStatusUpdateAuditTrail(GetAuditTrailRequest.newBuilder().setTenantId(tenantId).build());
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/cache/institutions/CILogon"})
    public ResponseEntity<GetInstitutionsResponse> getFromCache(@Valid @RequestBody CacheManipulationRequest request, @RequestHeader HttpHeaders headers) {
        GetInstitutionsResponse response = this.tenantManagementService.getFromCache(this.generateCacheManipulationRequest(request, headers));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/institutions/CILogon"})
    public ResponseEntity<GetInstitutionsResponse> getInstitutions(@Valid @RequestBody CacheManipulationRequest request, @RequestHeader HttpHeaders headers) {
        GetInstitutionsResponse response = this.tenantManagementService.getInstitutions(this.generateCacheManipulationRequest(request, headers));
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/cache/institutions/CILogon"})
    public ResponseEntity<Status> addToCache(@Valid @RequestBody CacheManipulationRequest request, @RequestHeader HttpHeaders headers) {
        request = this.generateCacheManipulationRequest(request, headers);
        Optional userClaim = this.tokenAuthorizer.validateUserToken(headers);
        if (userClaim.isPresent()) {
            request = request.toBuilder().setPerformedBy(((AuthClaim)userClaim.get()).getUsername()).build();
        }
        Status response = this.tenantManagementService.addToCache(request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/cache/institutions/CILogon"})
    public ResponseEntity<Status> removeFromCache(@Valid @RequestBody CacheManipulationRequest request, @RequestHeader HttpHeaders headers) {
        request = this.generateCacheManipulationRequest(request, headers);
        Optional userClaim = this.tokenAuthorizer.validateUserToken(headers);
        if (userClaim.isPresent()) {
            request = request.toBuilder().setPerformedBy(((AuthClaim)userClaim.get()).getUsername()).build();
        }
        Status response = this.tenantManagementService.removeFromCache(request);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/audit/attributes/{tenantId}"})
    public ResponseEntity<GetAttributeUpdateAuditTrailResponse> getTenantAttributeUpdateAuditTrail(@PathVariable(value="tenantId") int tenantId) {
        GetAttributeUpdateAuditTrailResponse response = this.tenantManagementService.getTenantAttributeUpdateAuditTrail(GetAuditTrailRequest.newBuilder().setTenantId((long)tenantId).build());
        return ResponseEntity.ok((Object)response);
    }

    @Hidden
    @PostMapping(value={"/oauth2/tenant/{tenantId}/client"})
    public ResponseEntity<?> configureClient(@PathVariable(value="tenantId") int tenantId, @RequestBody Map<String, Object> body, @RequestHeader HttpHeaders headers) {
        Map response = this.tenantManagementService.addClient((long)tenantId, (String)body.get("tenantUrl"), (List)body.get("redirectUris"));
        return ResponseEntity.ok((Object)response);
    }

    private Credentials getCredentials(AuthClaim claim) {
        return Credentials.newBuilder().setCustosClientId(claim.getCustosId()).setCustosClientSecret(claim.getCustosSecret()).setCustosClientIdIssuedAt((double)claim.getCustosIdIssuedAt()).setCustosClientSecretExpiredAt((double)claim.getCustosSecretExpiredAt()).setIamClientId(claim.getIamAuthId()).setIamClientSecret(claim.getIamAuthSecret()).setCiLogonClientId(claim.getCiLogonId()).setCiLogonClientSecret(claim.getCiLogonSecret()).build();
    }

    private CacheManipulationRequest generateCacheManipulationRequest(CacheManipulationRequest request, @RequestHeader HttpHeaders headers) {
        Optional claim = this.tokenAuthorizer.authorize(headers);
        if (claim.isPresent()) {
            AuthClaim authClaim = (AuthClaim)claim.get();
            return request.toBuilder().setTenantId(authClaim.getTenantId()).build();
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Request is not authorized, token not found");
    }
}

