// source: src/main/proto/UserManagementService.proto
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

var google_api_annotations_pb = require('../../../google/api/annotations_pb.js');
goog.object.extend(proto, google_api_annotations_pb);
var UserProfileService_pb = require('../../../UserProfileService_pb.js');
goog.object.extend(proto, UserProfileService_pb);
var IamAdminService_pb = require('../../../IamAdminService_pb.js');
goog.object.extend(proto, IamAdminService_pb);
goog.exportSymbol('proto.org.apache.custos.user.management.service.GetUserRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.user.management.service.GetUsersRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.user.management.service.LinkUserProfileRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.user.management.service.ResetPassword', null, global);
goog.exportSymbol('proto.org.apache.custos.user.management.service.ResetPasswordRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.user.management.service.UserProfileRequest', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.user.management.service.UserProfileRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.user.management.service.UserProfileRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.user.management.service.UserProfileRequest.displayName = 'proto.org.apache.custos.user.management.service.UserProfileRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.user.management.service.GetUserRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.user.management.service.GetUserRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.user.management.service.GetUserRequest.displayName = 'proto.org.apache.custos.user.management.service.GetUserRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.user.management.service.GetUsersRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.user.management.service.GetUsersRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.user.management.service.GetUsersRequest.displayName = 'proto.org.apache.custos.user.management.service.GetUsersRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.user.management.service.ResetPassword = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.user.management.service.ResetPassword, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.user.management.service.ResetPassword.displayName = 'proto.org.apache.custos.user.management.service.ResetPassword';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.user.management.service.ResetPasswordRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.user.management.service.ResetPasswordRequest.displayName = 'proto.org.apache.custos.user.management.service.ResetPasswordRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.org.apache.custos.user.management.service.LinkUserProfileRequest.repeatedFields_, null);
};
goog.inherits(proto.org.apache.custos.user.management.service.LinkUserProfileRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.user.management.service.LinkUserProfileRequest.displayName = 'proto.org.apache.custos.user.management.service.LinkUserProfileRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.displayName = 'proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.user.management.service.UserProfileRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.user.management.service.UserProfileRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    userProfile: (f = msg.getUserProfile()) && UserProfileService_pb.UserProfile.toObject(includeInstance, f),
    clientid: jspb.Message.getFieldWithDefault(msg, 2, ""),
    tenantid: jspb.Message.getFieldWithDefault(msg, 3, 0),
    accesstoken: jspb.Message.getFieldWithDefault(msg, 4, ""),
    clientsecret: jspb.Message.getFieldWithDefault(msg, 5, ""),
    performedby: jspb.Message.getFieldWithDefault(msg, 6, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.user.management.service.UserProfileRequest;
  return proto.org.apache.custos.user.management.service.UserProfileRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.user.management.service.UserProfileRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new UserProfileService_pb.UserProfile;
      reader.readMessage(value,UserProfileService_pb.UserProfile.deserializeBinaryFromReader);
      msg.setUserProfile(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientid(value);
      break;
    case 3:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantid(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setAccesstoken(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientsecret(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setPerformedby(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.user.management.service.UserProfileRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.user.management.service.UserProfileRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUserProfile();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      UserProfileService_pb.UserProfile.serializeBinaryToWriter
    );
  }
  f = message.getClientid();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getTenantid();
  if (f !== 0) {
    writer.writeInt64(
      3,
      f
    );
  }
  f = message.getAccesstoken();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getClientsecret();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getPerformedby();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
};


/**
 * optional org.apache.custos.user.profile.service.UserProfile user_profile = 1;
 * @return {?proto.org.apache.custos.user.profile.service.UserProfile}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.getUserProfile = function() {
  return /** @type{?proto.org.apache.custos.user.profile.service.UserProfile} */ (
    jspb.Message.getWrapperField(this, UserProfileService_pb.UserProfile, 1));
};


/**
 * @param {?proto.org.apache.custos.user.profile.service.UserProfile|undefined} value
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest} returns this
*/
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.setUserProfile = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.clearUserProfile = function() {
  return this.setUserProfile(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.hasUserProfile = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string clientId = 2;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.getClientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.setClientid = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional int64 tenantId = 3;
 * @return {number}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.getTenantid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.setTenantid = function(value) {
  return jspb.Message.setProto3IntField(this, 3, value);
};


/**
 * optional string accessToken = 4;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.getAccesstoken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.setAccesstoken = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string clientSecret = 5;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.getClientsecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.setClientsecret = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string performedBy = 6;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.getPerformedby = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.UserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.UserProfileRequest.prototype.setPerformedby = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.user.management.service.GetUserRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.user.management.service.GetUserRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.GetUserRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    username: jspb.Message.getFieldWithDefault(msg, 1, ""),
    usersearchrequest: (f = msg.getUsersearchrequest()) && IamAdminService_pb.UserSearchRequest.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.user.management.service.GetUserRequest}
 */
proto.org.apache.custos.user.management.service.GetUserRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.user.management.service.GetUserRequest;
  return proto.org.apache.custos.user.management.service.GetUserRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.user.management.service.GetUserRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.user.management.service.GetUserRequest}
 */
proto.org.apache.custos.user.management.service.GetUserRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setUsername(value);
      break;
    case 2:
      var value = new IamAdminService_pb.UserSearchRequest;
      reader.readMessage(value,IamAdminService_pb.UserSearchRequest.deserializeBinaryFromReader);
      msg.setUsersearchrequest(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.user.management.service.GetUserRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.user.management.service.GetUserRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.GetUserRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUsername();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getUsersearchrequest();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      IamAdminService_pb.UserSearchRequest.serializeBinaryToWriter
    );
  }
};


/**
 * optional string username = 1;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.getUsername = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.GetUserRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.setUsername = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional org.apache.custos.iam.service.UserSearchRequest userSearchRequest = 2;
 * @return {?proto.org.apache.custos.iam.service.UserSearchRequest}
 */
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.getUsersearchrequest = function() {
  return /** @type{?proto.org.apache.custos.iam.service.UserSearchRequest} */ (
    jspb.Message.getWrapperField(this, IamAdminService_pb.UserSearchRequest, 2));
};


/**
 * @param {?proto.org.apache.custos.iam.service.UserSearchRequest|undefined} value
 * @return {!proto.org.apache.custos.user.management.service.GetUserRequest} returns this
*/
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.setUsersearchrequest = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.user.management.service.GetUserRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.clearUsersearchrequest = function() {
  return this.setUsersearchrequest(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.user.management.service.GetUserRequest.prototype.hasUsersearchrequest = function() {
  return jspb.Message.getField(this, 2) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.user.management.service.GetUsersRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.user.management.service.GetUsersRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    tenantid: jspb.Message.getFieldWithDefault(msg, 1, 0),
    email: jspb.Message.getFieldWithDefault(msg, 2, ""),
    username: jspb.Message.getFieldWithDefault(msg, 3, ""),
    offset: jspb.Message.getFieldWithDefault(msg, 4, 0),
    limit: jspb.Message.getFieldWithDefault(msg, 5, 0),
    search: jspb.Message.getFieldWithDefault(msg, 6, ""),
    iamclientid: jspb.Message.getFieldWithDefault(msg, 7, ""),
    iamclientsecret: jspb.Message.getFieldWithDefault(msg, 8, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.user.management.service.GetUsersRequest;
  return proto.org.apache.custos.user.management.service.GetUsersRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.user.management.service.GetUsersRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantid(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setEmail(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setUsername(value);
      break;
    case 4:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setOffset(value);
      break;
    case 5:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setLimit(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setSearch(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientid(value);
      break;
    case 8:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientsecret(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.user.management.service.GetUsersRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.user.management.service.GetUsersRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTenantid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getEmail();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getUsername();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getOffset();
  if (f !== 0) {
    writer.writeInt32(
      4,
      f
    );
  }
  f = message.getLimit();
  if (f !== 0) {
    writer.writeInt32(
      5,
      f
    );
  }
  f = message.getSearch();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getIamclientid();
  if (f.length > 0) {
    writer.writeString(
      7,
      f
    );
  }
  f = message.getIamclientsecret();
  if (f.length > 0) {
    writer.writeString(
      8,
      f
    );
  }
};


/**
 * optional int64 tenantId = 1;
 * @return {number}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getTenantid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setTenantid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string email = 2;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getEmail = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setEmail = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string username = 3;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getUsername = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setUsername = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional int32 offset = 4;
 * @return {number}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getOffset = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setOffset = function(value) {
  return jspb.Message.setProto3IntField(this, 4, value);
};


/**
 * optional int32 limit = 5;
 * @return {number}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getLimit = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 5, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setLimit = function(value) {
  return jspb.Message.setProto3IntField(this, 5, value);
};


/**
 * optional string search = 6;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getSearch = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setSearch = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional string iamClientId = 7;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getIamclientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setIamclientid = function(value) {
  return jspb.Message.setProto3StringField(this, 7, value);
};


/**
 * optional string iamClientSecret = 8;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.getIamclientsecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 8, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.GetUsersRequest} returns this
 */
proto.org.apache.custos.user.management.service.GetUsersRequest.prototype.setIamclientsecret = function(value) {
  return jspb.Message.setProto3StringField(this, 8, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.user.management.service.ResetPassword.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.user.management.service.ResetPassword} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.ResetPassword.toObject = function(includeInstance, msg) {
  var f, obj = {
    tenantid: jspb.Message.getFieldWithDefault(msg, 1, 0),
    accesstoken: jspb.Message.getFieldWithDefault(msg, 2, ""),
    username: jspb.Message.getFieldWithDefault(msg, 3, ""),
    password: jspb.Message.getFieldWithDefault(msg, 4, ""),
    iamclientid: jspb.Message.getFieldWithDefault(msg, 5, ""),
    iamclientsecret: jspb.Message.getFieldWithDefault(msg, 6, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword}
 */
proto.org.apache.custos.user.management.service.ResetPassword.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.user.management.service.ResetPassword;
  return proto.org.apache.custos.user.management.service.ResetPassword.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.user.management.service.ResetPassword} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword}
 */
proto.org.apache.custos.user.management.service.ResetPassword.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantid(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setAccesstoken(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setUsername(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setPassword(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientid(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientsecret(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.user.management.service.ResetPassword.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.user.management.service.ResetPassword} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.ResetPassword.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTenantid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getAccesstoken();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getUsername();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getPassword();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getIamclientid();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getIamclientsecret();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
};


/**
 * optional int64 tenantId = 1;
 * @return {number}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.getTenantid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword} returns this
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.setTenantid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string accessToken = 2;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.getAccesstoken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword} returns this
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.setAccesstoken = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string username = 3;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.getUsername = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword} returns this
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.setUsername = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string password = 4;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.getPassword = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword} returns this
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.setPassword = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string iamClientId = 5;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.getIamclientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword} returns this
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.setIamclientid = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string iamClientSecret = 6;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.getIamclientsecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.ResetPassword} returns this
 */
proto.org.apache.custos.user.management.service.ResetPassword.prototype.setIamclientsecret = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.user.management.service.ResetPasswordRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.user.management.service.ResetPasswordRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    passwordmetadata: (f = msg.getPasswordmetadata()) && proto.org.apache.custos.user.management.service.ResetPassword.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.user.management.service.ResetPasswordRequest}
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.user.management.service.ResetPasswordRequest;
  return proto.org.apache.custos.user.management.service.ResetPasswordRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.user.management.service.ResetPasswordRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.user.management.service.ResetPasswordRequest}
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.org.apache.custos.user.management.service.ResetPassword;
      reader.readMessage(value,proto.org.apache.custos.user.management.service.ResetPassword.deserializeBinaryFromReader);
      msg.setPasswordmetadata(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.user.management.service.ResetPasswordRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.user.management.service.ResetPasswordRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPasswordmetadata();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      proto.org.apache.custos.user.management.service.ResetPassword.serializeBinaryToWriter
    );
  }
};


/**
 * optional ResetPassword passwordMetadata = 1;
 * @return {?proto.org.apache.custos.user.management.service.ResetPassword}
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.prototype.getPasswordmetadata = function() {
  return /** @type{?proto.org.apache.custos.user.management.service.ResetPassword} */ (
    jspb.Message.getWrapperField(this, proto.org.apache.custos.user.management.service.ResetPassword, 1));
};


/**
 * @param {?proto.org.apache.custos.user.management.service.ResetPassword|undefined} value
 * @return {!proto.org.apache.custos.user.management.service.ResetPasswordRequest} returns this
*/
proto.org.apache.custos.user.management.service.ResetPasswordRequest.prototype.setPasswordmetadata = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.user.management.service.ResetPasswordRequest} returns this
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.prototype.clearPasswordmetadata = function() {
  return this.setPasswordmetadata(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.user.management.service.ResetPasswordRequest.prototype.hasPasswordmetadata = function() {
  return jspb.Message.getField(this, 1) != null;
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.repeatedFields_ = [3];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.user.management.service.LinkUserProfileRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    currentUsername: jspb.Message.getFieldWithDefault(msg, 1, ""),
    previousUsername: jspb.Message.getFieldWithDefault(msg, 2, ""),
    linkingAttributesList: (f = jspb.Message.getRepeatedField(msg, 3)) == null ? undefined : f,
    tenantid: jspb.Message.getFieldWithDefault(msg, 4, 0),
    iamclientid: jspb.Message.getFieldWithDefault(msg, 5, ""),
    iamclientsecret: jspb.Message.getFieldWithDefault(msg, 6, ""),
    accesstoken: jspb.Message.getFieldWithDefault(msg, 7, ""),
    performedby: jspb.Message.getFieldWithDefault(msg, 8, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.user.management.service.LinkUserProfileRequest;
  return proto.org.apache.custos.user.management.service.LinkUserProfileRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setCurrentUsername(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPreviousUsername(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.addLinkingAttributes(value);
      break;
    case 4:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantid(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientid(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientsecret(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setAccesstoken(value);
      break;
    case 8:
      var value = /** @type {string} */ (reader.readString());
      msg.setPerformedby(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.user.management.service.LinkUserProfileRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCurrentUsername();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getPreviousUsername();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getLinkingAttributesList();
  if (f.length > 0) {
    writer.writeRepeatedString(
      3,
      f
    );
  }
  f = message.getTenantid();
  if (f !== 0) {
    writer.writeInt64(
      4,
      f
    );
  }
  f = message.getIamclientid();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getIamclientsecret();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getAccesstoken();
  if (f.length > 0) {
    writer.writeString(
      7,
      f
    );
  }
  f = message.getPerformedby();
  if (f.length > 0) {
    writer.writeString(
      8,
      f
    );
  }
};


/**
 * optional string current_username = 1;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getCurrentUsername = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setCurrentUsername = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string previous_username = 2;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getPreviousUsername = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setPreviousUsername = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * repeated string linking_attributes = 3;
 * @return {!Array<string>}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getLinkingAttributesList = function() {
  return /** @type {!Array<string>} */ (jspb.Message.getRepeatedField(this, 3));
};


/**
 * @param {!Array<string>} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setLinkingAttributesList = function(value) {
  return jspb.Message.setField(this, 3, value || []);
};


/**
 * @param {string} value
 * @param {number=} opt_index
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.addLinkingAttributes = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 3, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.clearLinkingAttributesList = function() {
  return this.setLinkingAttributesList([]);
};


/**
 * optional int64 tenantId = 4;
 * @return {number}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getTenantid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setTenantid = function(value) {
  return jspb.Message.setProto3IntField(this, 4, value);
};


/**
 * optional string iamClientId = 5;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getIamclientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setIamclientid = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string iamClientSecret = 6;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getIamclientsecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setIamclientsecret = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional string accessToken = 7;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getAccesstoken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setAccesstoken = function(value) {
  return jspb.Message.setProto3StringField(this, 7, value);
};


/**
 * optional string performedBy = 8;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.getPerformedby = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 8, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.LinkUserProfileRequest} returns this
 */
proto.org.apache.custos.user.management.service.LinkUserProfileRequest.prototype.setPerformedby = function(value) {
  return jspb.Message.setProto3StringField(this, 8, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    tenantid: jspb.Message.getFieldWithDefault(msg, 2, 0),
    clientid: jspb.Message.getFieldWithDefault(msg, 4, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest}
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest;
  return proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest}
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 2:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantid(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientid(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTenantid();
  if (f !== 0) {
    writer.writeInt64(
      2,
      f
    );
  }
  f = message.getClientid();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
};


/**
 * optional int64 tenantId = 2;
 * @return {number}
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.prototype.getTenantid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest} returns this
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.prototype.setTenantid = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};


/**
 * optional string clientId = 4;
 * @return {string}
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.prototype.getClientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest} returns this
 */
proto.org.apache.custos.user.management.service.SynchronizeUserDBRequest.prototype.setClientid = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


goog.object.extend(exports, proto.org.apache.custos.user.management.service);
