/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.bookkeeper.net.AbstractDNSToSwitchMapping;
import org.apache.bookkeeper.net.CachedDNSToSwitchMapping;
import org.apache.bookkeeper.util.Shell;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptBasedMapping
extends CachedDNSToSwitchMapping {
    static final int MIN_ALLOWABLE_ARGS = 1;
    static final int DEFAULT_ARG_COUNT = 100;
    static final String SCRIPT_FILENAME_KEY = "networkTopologyScriptFileName";
    static final String SCRIPT_ARG_COUNT_KEY = "networkTopologyScriptNumberArgs";
    public static final String NO_SCRIPT = "no script";

    public ScriptBasedMapping() {
        super(new RawScriptBasedMapping());
    }

    public ScriptBasedMapping(Configuration conf) {
        this();
        this.setConf(conf);
    }

    private RawScriptBasedMapping getRawMapping() {
        return (RawScriptBasedMapping)this.rawMapping;
    }

    @Override
    public Configuration getConf() {
        return this.getRawMapping().getConf();
    }

    @Override
    public String toString() {
        return "script-based mapping with " + this.getRawMapping().toString();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.getRawMapping().setConf(conf);
    }

    private static final class RawScriptBasedMapping
    extends AbstractDNSToSwitchMapping {
        private String scriptName;
        private int maxArgs;
        private static final Logger LOG = LoggerFactory.getLogger(RawScriptBasedMapping.class);

        @Override
        protected void validateConf() {
            Configuration conf = this.getConf();
            if (conf != null) {
                String scriptNameConfValue = conf.getString(ScriptBasedMapping.SCRIPT_FILENAME_KEY);
                if (StringUtils.isNotBlank((String)scriptNameConfValue)) {
                    this.scriptName = scriptNameConfValue;
                    this.maxArgs = conf.getInt(ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY, 100);
                } else {
                    this.scriptName = null;
                    this.maxArgs = 0;
                }
            } else {
                this.scriptName = null;
                this.maxArgs = 0;
            }
            if (null == this.scriptName) {
                throw new RuntimeException("No network topology script is found when using script based DNS resolver.");
            }
            File dir = null;
            String userDir = System.getProperty("user.dir");
            if (userDir != null) {
                dir = new File(userDir);
            }
            String[] execString = new String[]{this.scriptName};
            Shell.ShellCommandExecutor s = new Shell.ShellCommandExecutor(execString, dir);
            try {
                s.execute();
            }
            catch (Exception e) {
                LOG.error("Conf validation failed. Got exception for sanity check of script: " + this.scriptName, (Throwable)e);
                throw new RuntimeException("Conf validation failed. Got exception for sanity check of script: " + this.scriptName, e);
            }
        }

        @Override
        public List<String> resolve(List<String> names) {
            ArrayList<String> m = new ArrayList<String>(names.size());
            if (names.isEmpty()) {
                return m;
            }
            if (this.scriptName == null) {
                return null;
            }
            String output = this.runResolveCommand(names);
            if (output != null) {
                StringTokenizer allSwitchInfo = new StringTokenizer(output);
                while (allSwitchInfo.hasMoreTokens()) {
                    String switchInfo = allSwitchInfo.nextToken();
                    m.add(switchInfo);
                }
                if (m.size() != names.size()) {
                    LOG.error("Script " + this.scriptName + " returned " + m.size() + " values when " + names.size() + " were expected.");
                    return null;
                }
            } else {
                return null;
            }
            return m;
        }

        private String runResolveCommand(List<String> args) {
            int loopCount = 0;
            if (args.size() == 0) {
                return null;
            }
            StringBuilder allOutput = new StringBuilder();
            int numProcessed = 0;
            if (this.maxArgs < 1) {
                LOG.warn("Invalid value " + this.maxArgs + " for " + ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY + "; must be >= " + 1);
                return null;
            }
            while (numProcessed != args.size()) {
                int start = this.maxArgs * loopCount;
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add(this.scriptName);
                for (numProcessed = start; numProcessed < start + this.maxArgs && numProcessed < args.size(); ++numProcessed) {
                    cmdList.add(args.get(numProcessed));
                }
                File dir = null;
                String userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    dir = new File(userDir);
                }
                Shell.ShellCommandExecutor s = new Shell.ShellCommandExecutor(cmdList.toArray(new String[cmdList.size()]), dir);
                try {
                    s.execute();
                    allOutput.append(s.getOutput()).append(" ");
                }
                catch (Exception e) {
                    LOG.warn("Exception running: {} Exception message: {}", (Object)s, (Object)e.getMessage());
                    return null;
                }
                ++loopCount;
            }
            return allOutput.toString();
        }

        @Override
        public boolean isSingleSwitch() {
            return this.scriptName == null;
        }

        public String toString() {
            return this.scriptName != null ? "script " + this.scriptName : ScriptBasedMapping.NO_SCRIPT;
        }

        @Override
        public void reloadCachedMappings() {
        }
    }
}

