/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.xds.FaultFilter;
import io.grpc.xds.Filter;
import io.grpc.xds.RbacFilter;
import io.grpc.xds.RouterFilter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class FilterRegistry {
    private static FilterRegistry instance;
    private final Map<String, Filter.Provider> supportedFilters = new HashMap<String, Filter.Provider>();

    private FilterRegistry() {
    }

    static synchronized FilterRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = FilterRegistry.newRegistry().register(new FaultFilter.Provider(), new RouterFilter.Provider(), new RbacFilter.Provider());
        }
        return instance;
    }

    @VisibleForTesting
    static FilterRegistry newRegistry() {
        return new FilterRegistry();
    }

    @VisibleForTesting
    FilterRegistry register(Filter.Provider ... filters) {
        for (Filter.Provider filter : filters) {
            for (String typeUrl : filter.typeUrls()) {
                this.supportedFilters.put(typeUrl, filter);
            }
        }
        return this;
    }

    @Nullable
    Filter.Provider get(String typeUrl) {
        return this.supportedFilters.get(typeUrl);
    }
}

