/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.bookkeeper.auth.AuthToken;
import org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieConnectionPeer;
import org.apache.bookkeeper.sasl.SaslServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLBookieAuthProvider
implements BookieAuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SASLBookieAuthProvider.class);
    private SaslServerState server;
    private final AuthCallbacks.GenericCallback<Void> completeCb;

    SASLBookieAuthProvider(BookieConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb, ServerConfiguration serverConfiguration, Subject subject, Pattern allowedIdsPattern) {
        this.completeCb = completeCb;
        try {
            this.server = new SaslServerState(serverConfiguration, subject, allowedIdsPattern);
        }
        catch (IOException | LoginException error) {
            LOG.error("Error while booting SASL server", (Throwable)error);
            completeCb.operationComplete(-102, null);
        }
    }

    @Override
    public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
        try {
            byte[] clientSideToken = m.getData();
            byte[] response = this.server.response(clientSideToken);
            if (response != null) {
                cb.operationComplete(0, AuthToken.wrap(response));
            }
            if (this.server.isComplete()) {
                this.completeCb.operationComplete(0, null);
            }
        }
        catch (SaslException err) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL error", (Throwable)err);
            }
            this.completeCb.operationComplete(-102, null);
        }
    }
}

