/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.sidecar.acl.authentication.JwtParameters;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtParameterExtractor
implements JwtParameters {
    protected static final String SITE_SUFFIX = "/.well-known/openid-configuration";
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtParameterExtractor.class);
    private static final String ENABLED_PARAM_KEY = "enabled";
    private static final String DEFAULT_ENABLED = "false";
    private static final String SITE_PARAM_KEY = "site";
    private static final String CLIENT_ID_PARAM_KEY = "client_id";
    private static final String SCOPE_SEPARATOR_PARAM_KEY = "scope_separator";
    private static final String DEFAULT_SCOPE_SEPARATOR = ",";
    private static final String SCOPES_SUPPORTED_PARAM_KEY = "scopes_supported";
    private static final String CONFIG_DISCOVER_INTERVAL_PARAM_KEY = "config_discover_interval";
    private static final SecondBoundConfiguration DEFAULT_CONFIG_DISCOVER_INTERVAL = SecondBoundConfiguration.parse((String)"1h");
    private final boolean enabled;
    private final String site;
    private final String clientId;
    private final SecondBoundConfiguration configDiscoverInterval;
    private final List<String> scopes;

    public JwtParameterExtractor(Map<String, String> parameters) {
        this.validate(parameters);
        this.enabled = Boolean.parseBoolean(parameters.getOrDefault(ENABLED_PARAM_KEY, DEFAULT_ENABLED));
        this.site = this.removeSiteSuffix(parameters);
        this.clientId = parameters.get(CLIENT_ID_PARAM_KEY);
        this.scopes = this.buildScopes(parameters);
        this.configDiscoverInterval = parameters.containsKey(CONFIG_DISCOVER_INTERVAL_PARAM_KEY) ? SecondBoundConfiguration.parse((String)parameters.get(CONFIG_DISCOVER_INTERVAL_PARAM_KEY)) : DEFAULT_CONFIG_DISCOVER_INTERVAL;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public String site() {
        return this.site;
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public List<String> scopes() {
        return this.scopes;
    }

    @Override
    public SecondBoundConfiguration configDiscoverInterval() {
        return this.configDiscoverInterval;
    }

    private void validate(Map<String, String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("JWT parameters can not be null");
        }
        this.validateParameterPresence(parameters, SITE_PARAM_KEY);
        this.validateParameterPresence(parameters, CLIENT_ID_PARAM_KEY);
    }

    private void validateParameterPresence(Map<String, String> parameters, String paramKey) {
        if (StringUtils.isNullOrEmpty((String)parameters.get(paramKey))) {
            throw new IllegalArgumentException(String.format("Missing %s JWT parameter", paramKey));
        }
    }

    private String removeSiteSuffix(Map<String, String> parameters) {
        String site = parameters.get(SITE_PARAM_KEY);
        if (site.endsWith(SITE_SUFFIX)) {
            LOGGER.info("Removing site suffix {}, it is added during OpenID discover", (Object)SITE_SUFFIX);
            return site.substring(0, site.length() - SITE_SUFFIX.length());
        }
        return site;
    }

    private List<String> buildScopes(Map<String, String> parameters) {
        ArrayList<String> scopes = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)parameters.get(SCOPES_SUPPORTED_PARAM_KEY))) {
            String delimiter = StringUtils.isNotEmpty((String)parameters.get(SCOPE_SEPARATOR_PARAM_KEY)) ? parameters.get(SCOPE_SEPARATOR_PARAM_KEY) : DEFAULT_SCOPE_SEPARATOR;
            scopes.addAll(Arrays.asList(parameters.get(SCOPES_SUPPORTED_PARAM_KEY).split(delimiter)));
        }
        return scopes;
    }
}

