/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;

public class RestoreRangesSchema
extends TableSchema
implements ExecuteOnClusterLeaseholderOnly {
    private static final String TABLE_NAME = "restore_range_v1";
    private final SchemaKeyspaceConfiguration keyspaceConfig;
    private final SecondBoundConfiguration tableTtl;
    private PreparedStatement createRange;
    private PreparedStatement findAll;
    private PreparedStatement update;

    public RestoreRangesSchema(SchemaKeyspaceConfiguration keyspaceConfig, SecondBoundConfiguration tableTtl) {
        this.keyspaceConfig = keyspaceConfig;
        this.tableTtl = tableTtl;
    }

    protected String keyspaceName() {
        return this.keyspaceConfig.keyspace();
    }

    protected void prepareStatements(@NotNull Session session) {
        this.createRange = this.prepare(this.createRange, session, CqlLiterals.createRange(this.keyspaceConfig));
        this.findAll = this.prepare(this.findAll, session, CqlLiterals.findAll(this.keyspaceConfig));
        this.update = this.prepare(this.update, session, CqlLiterals.update(this.keyspaceConfig));
    }

    protected String tableName() {
        return TABLE_NAME;
    }

    protected String createSchemaStatement() {
        return String.format("CREATE TABLE IF NOT EXISTS %s.%s (  job_id timeuuid,  bucket_id smallint,  start_token varint,  end_token varint,  slice_id text,  slice_bucket text,  slice_key text,  status_by_replica map<text, text>,  PRIMARY KEY ((job_id, bucket_id), start_token, end_token)) WITH default_time_to_live = %s", this.keyspaceConfig.keyspace(), TABLE_NAME, this.tableTtl.toSeconds());
    }

    public PreparedStatement createRange() {
        return this.createRange;
    }

    public PreparedStatement findAll() {
        return this.findAll;
    }

    public PreparedStatement updateStatus() {
        return this.update;
    }

    private static class CqlLiterals {
        private CqlLiterals() {
        }

        static String createRange(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("UPDATE %s.%s SET slice_id = ?, slice_bucket = ?, slice_key = ?, status_by_replica = status_by_replica + ? WHERE job_id = ? AND bucket_id = ? AND start_token = ? AND end_token = ?", config);
        }

        static String findAll(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("SELECT job_id, bucket_id, slice_id, slice_bucket, slice_key, start_token, end_token, status_by_replica FROM %s.%s WHERE job_id = ? AND bucket_id = ? ALLOW FILTERING", config);
        }

        static String update(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("UPDATE %s.%s SET status_by_replica = status_by_replica + ? WHERE job_id = ? AND bucket_id = ? AND start_token = ? AND end_token = ?", config);
        }

        private static String withTable(String format, SchemaKeyspaceConfiguration config) {
            return String.format(format, config.keyspace(), RestoreRangesSchema.TABLE_NAME);
        }
    }
}

