/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.CassandraPermissions;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScopes;
import org.apache.cassandra.sidecar.common.server.MetricsOperations;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.RequestUtils;
import org.jetbrains.annotations.NotNull;

public class ConnectedClientStatsHandler
extends AbstractHandler<Boolean>
implements AccessProtected {
    @Inject
    protected ConnectedClientStatsHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, null);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        Set<String> eligibleResources = Set.of(ResourceScopes.DATA_SCOPE.variableAwareResource(), "data/system_views", "data/system_views/*", "data/system_views/clients");
        return Collections.singleton(CassandraPermissions.SELECT.toAuthorization(eligibleResources));
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Boolean summaryOnly) {
        MetricsOperations operations = this.metadataFetcher.delegate(host).metricsOperations();
        this.executorPools.service().executeBlocking(() -> operations.connectedClientStats(summaryOnly.booleanValue())).onSuccess(arg_0 -> ((RoutingContext)context).json(arg_0)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, summaryOnly));
    }

    @Override
    protected Boolean extractParamsOrThrow(RoutingContext context) {
        return RequestUtils.parseBooleanQueryParam(context.request(), "summary", true);
    }
}

