/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.common.data.OperationalJobStatus;
import org.apache.cassandra.sidecar.common.response.OperationalJobResponse;
import org.apache.cassandra.sidecar.job.OperationalJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationalJobUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationalJobUtils.class);

    public static void sendStatusBasedResponse(RoutingContext context, OperationalJob job) {
        OperationalJobStatus status = job.status();
        LOGGER.info("Job completion status={} jobId={}", (Object)status, (Object)job.jobId());
        if (status.isCompleted()) {
            context.response().setStatusCode(HttpResponseStatus.OK.code());
        } else {
            context.response().setStatusCode(HttpResponseStatus.ACCEPTED.code());
        }
        String reason = status == OperationalJobStatus.FAILED ? job.asyncResult().cause().getMessage() : null;
        context.json((Object)new OperationalJobResponse(job.jobId(), status, job.name(), reason));
    }
}

