/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.net.InetSocketAddress;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.server.ClusterMembershipOperations;
import org.apache.cassandra.sidecar.common.server.MetricsOperations;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.TableOperations;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.jetbrains.annotations.NotNull;

public interface ICassandraAdapter {
    @NotNull
    public Metadata metadata() throws CassandraUnavailableException;

    @NotNull
    public NodeSettings nodeSettings() throws CassandraUnavailableException;

    @NotNull
    default public ResultSet executeLocal(String query) throws CassandraUnavailableException {
        return this.executeLocal((Statement)new SimpleStatement(query));
    }

    @NotNull
    public ResultSet executeLocal(Statement var1) throws CassandraUnavailableException;

    @NotNull
    public InetSocketAddress localNativeTransportAddress() throws CassandraUnavailableException;

    @NotNull
    public InetSocketAddress localStorageBroadcastAddress() throws CassandraUnavailableException;

    @NotNull
    public StorageOperations storageOperations() throws CassandraUnavailableException;

    @NotNull
    public MetricsOperations metricsOperations() throws CassandraUnavailableException;

    @NotNull
    public ClusterMembershipOperations clusterMembershipOperations() throws CassandraUnavailableException;

    @NotNull
    public TableOperations tableOperations();
}

