/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.sidecar.common.utils.Preconditions;

public enum RestoreRangeStatus {
    SUCCEEDED(new RestoreRangeStatus[0]),
    FAILED(new RestoreRangeStatus[0]),
    ABORTED(new RestoreRangeStatus[0]),
    DISCARDED(new RestoreRangeStatus[0]),
    STAGED(SUCCEEDED, FAILED, ABORTED, DISCARDED),
    CREATED(STAGED, FAILED, ABORTED, DISCARDED);

    private final Set<RestoreRangeStatus> validTargetStatusSet = new HashSet<RestoreRangeStatus>();

    private RestoreRangeStatus(RestoreRangeStatus ... targetStatuses) {
        Collections.addAll(this.validTargetStatusSet, targetStatuses);
    }

    public RestoreRangeStatus advanceTo(RestoreRangeStatus targetStatus) {
        Preconditions.checkArgument((boolean)this.validTargetStatusSet.contains((Object)targetStatus), (String)(this.name() + " status can only advance to one of the follow statuses: " + this.validTargetStatusSet));
        return targetStatus;
    }
}

