/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.ParameterClosingConsumer;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxExtensionParameterProvider;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

public class VertxParameterProvider
implements VertxExtensionParameterProvider<Vertx> {
    private static final Logger LOG = LoggerFactory.getLogger(VertxParameterProvider.class);
    static final String VERTX_PARAMETER_FILENAME = "vertx.parameter.filename";
    static final String VERTX_PARAMETER_FILENAME_ENV_VAR = "VERTX_PARAMETER_FILENAME";
    static final String VERTX_PARAMETER_FILENAME_SYS_PROP = "vertx.parameter.filename";
    private static final String DEPRECATION_WARNING = String.format("'%s' environment variable is deprecated and will be removed in a future version, use '%s' instead", "vertx.parameter.filename", "VERTX_PARAMETER_FILENAME");

    @Override
    public Class<Vertx> type() {
        return Vertx.class;
    }

    @Override
    public String key() {
        return "Vertx";
    }

    @Override
    public Vertx newInstance(ExtensionContext extensionContext, ParameterContext parameterContext) {
        JsonObject parameters = this.getVertxOptions();
        VertxOptions options = new VertxOptions(parameters);
        return Vertx.vertx((VertxOptions)options);
    }

    @Override
    public ParameterClosingConsumer<Vertx> parameterClosingConsumer() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, VertxExtension.DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    public JsonObject getVertxOptions() {
        String optionFileName = System.getenv(VERTX_PARAMETER_FILENAME_ENV_VAR);
        if (optionFileName == null && (optionFileName = System.getProperty("vertx.parameter.filename")) == null) {
            optionFileName = System.getenv("vertx.parameter.filename");
            if (optionFileName != null) {
                LOG.warn((Object)DEPRECATION_WARNING);
            } else {
                return new JsonObject();
            }
        }
        try {
            Path path = Paths.get(optionFileName, new String[0]);
            Buffer content = Buffer.buffer((byte[])Files.readAllBytes(path));
            return new JsonObject(content);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failure when reading Vert.x options file, will use default options", (Throwable)e);
            return new JsonObject();
        }
    }
}

