/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode.nonstiff;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.core.RealFieldElement;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.ode.AbstractFieldIntegrator;
import org.apache.commons.math4.legacy.ode.FieldEquationsMapper;
import org.apache.commons.math4.legacy.ode.FieldODEState;
import org.apache.commons.math4.legacy.ode.FieldODEStateAndDerivative;

public abstract class AdaptiveStepsizeFieldIntegrator<T extends RealFieldElement<T>>
extends AbstractFieldIntegrator<T> {
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected int mainSetDimension;
    private T initialStep;
    private T minStep;
    private T maxStep;

    public AdaptiveStepsizeFieldIntegrator(Field<T> field, String name, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(field, name);
        this.setStepSizeControl(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.resetInternalState();
    }

    public AdaptiveStepsizeFieldIntegrator(Field<T> field, String name, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, name);
        this.setStepSizeControl(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.resetInternalState();
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double absoluteTolerance, double relativeTolerance) {
        this.minStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(JdkMath.abs((double)minimalStep));
        this.maxStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(JdkMath.abs((double)maximalStep));
        this.initialStep = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
        this.scalAbsoluteTolerance = absoluteTolerance;
        this.scalRelativeTolerance = relativeTolerance;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double[] absoluteTolerance, double[] relativeTolerance) {
        this.minStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(JdkMath.abs((double)minimalStep));
        this.maxStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(JdkMath.abs((double)maximalStep));
        this.initialStep = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])absoluteTolerance.clone();
        this.vecRelativeTolerance = (double[])relativeTolerance.clone();
    }

    public void setInitialStepSize(T initialStepSize) {
        this.initialStep = ((RealFieldElement)initialStepSize.subtract(this.minStep)).getReal() < 0.0 || ((RealFieldElement)initialStepSize.subtract(this.maxStep)).getReal() > 0.0 ? (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate() : initialStepSize;
    }

    @Override
    protected void sanityChecks(FieldODEState<T> eqn, T t) throws DimensionMismatchException, NumberIsTooSmallException {
        super.sanityChecks(eqn, t);
        this.mainSetDimension = eqn.getStateDimension();
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecAbsoluteTolerance.length);
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecRelativeTolerance.length);
        }
    }

    public T initializeStep(boolean forward, int order, T[] scale, FieldODEStateAndDerivative<T> state0, FieldEquationsMapper<T> mapper) throws MaxCountExceededException, DimensionMismatchException {
        RealFieldElement h;
        if (this.initialStep.getReal() > 0.0) {
            return (T)(forward ? this.initialStep : (RealFieldElement)this.initialStep.negate());
        }
        RealFieldElement[] y0 = mapper.mapState(state0);
        RealFieldElement[] yDot0 = mapper.mapDerivative(state0);
        RealFieldElement yOnScale2 = (RealFieldElement)this.getField().getZero();
        RealFieldElement yDotOnScale2 = (RealFieldElement)this.getField().getZero();
        for (int j = 0; j < scale.length; ++j) {
            RealFieldElement ratio = (RealFieldElement)y0[j].divide(scale[j]);
            yOnScale2 = (RealFieldElement)yOnScale2.add((Object)((RealFieldElement)ratio.multiply((Object)ratio)));
            RealFieldElement ratioDot = (RealFieldElement)yDot0[j].divide(scale[j]);
            yDotOnScale2 = (RealFieldElement)yDotOnScale2.add((Object)((RealFieldElement)ratioDot.multiply((Object)ratioDot)));
        }
        RealFieldElement realFieldElement = h = yOnScale2.getReal() < 1.0E-10 || yDotOnScale2.getReal() < 1.0E-10 ? (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(1.0E-6) : (RealFieldElement)((RealFieldElement)((RealFieldElement)yOnScale2.divide((Object)yDotOnScale2)).sqrt()).multiply(0.01);
        if (!forward) {
            h = (RealFieldElement)h.negate();
        }
        RealFieldElement[] y1 = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)y0.length);
        for (int j = 0; j < y0.length; ++j) {
            y1[j] = (RealFieldElement)y0[j].add((Object)((RealFieldElement)yDot0[j].multiply((Object)h)));
        }
        RealFieldElement[] yDot1 = this.computeDerivatives((RealFieldElement)state0.getTime().add((Object)h), y1);
        RealFieldElement yDDotOnScale = (RealFieldElement)this.getField().getZero();
        for (int j = 0; j < scale.length; ++j) {
            RealFieldElement ratioDotDot = (RealFieldElement)((RealFieldElement)yDot1[j].subtract((Object)yDot0[j])).divide(scale[j]);
            yDDotOnScale = (RealFieldElement)yDDotOnScale.add((Object)((RealFieldElement)ratioDotDot.multiply((Object)ratioDotDot)));
        }
        yDDotOnScale = (RealFieldElement)((RealFieldElement)yDDotOnScale.sqrt()).divide((Object)h);
        RealFieldElement maxInv2 = RealFieldElement.max((RealFieldElement)((RealFieldElement)yDotOnScale2.sqrt()), (RealFieldElement)yDDotOnScale);
        RealFieldElement h1 = maxInv2.getReal() < 1.0E-15 ? RealFieldElement.max((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(1.0E-6)), (RealFieldElement)((RealFieldElement)((RealFieldElement)h.abs()).multiply(0.001))) : (RealFieldElement)((RealFieldElement)((RealFieldElement)maxInv2.multiply(100)).reciprocal()).pow(1.0 / (double)order);
        h = RealFieldElement.min((RealFieldElement)((RealFieldElement)((RealFieldElement)h.abs()).multiply(100)), (RealFieldElement)h1);
        h = RealFieldElement.max((RealFieldElement)h, (RealFieldElement)((RealFieldElement)((RealFieldElement)state0.getTime().abs()).multiply(1.0E-12)));
        h = RealFieldElement.max(this.minStep, (RealFieldElement)RealFieldElement.min(this.maxStep, (RealFieldElement)h));
        if (!forward) {
            h = (RealFieldElement)h.negate();
        }
        return (T)h;
    }

    protected T filterStep(T h, boolean forward, boolean acceptSmall) throws NumberIsTooSmallException {
        Object filteredH = h;
        if (((RealFieldElement)((RealFieldElement)h.abs()).subtract(this.minStep)).getReal() < 0.0) {
            if (acceptSmall) {
                filteredH = forward ? this.minStep : (RealFieldElement)this.minStep.negate();
            } else {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, (Number)((RealFieldElement)h.abs()).getReal(), (Number)this.minStep.getReal(), true);
            }
        }
        if (((RealFieldElement)filteredH.subtract(this.maxStep)).getReal() > 0.0) {
            filteredH = this.maxStep;
        } else if (((RealFieldElement)filteredH.add(this.maxStep)).getReal() < 0.0) {
            filteredH = (RealFieldElement)this.maxStep.negate();
        }
        return filteredH;
    }

    protected void resetInternalState() {
        this.setStepStart(null);
        this.setStepSize((RealFieldElement)((RealFieldElement)this.minStep.multiply(this.maxStep)).sqrt());
    }

    public T getMinStep() {
        return this.minStep;
    }

    public T getMaxStep() {
        return this.maxStep;
    }
}

