/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.ArrayList;
import org.apache.commons.validator.routines.DomainValidator;
import org.bitstrings.test.junit.runner.ClassLoaderPerTestRunner;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;

@RunWith(value=ClassLoaderPerTestRunner.class)
class DomainValidatorStartupTest {
    DomainValidatorStartupTest() {
    }

    @Test
    void testCannotUpdate() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator dv = DomainValidator.getInstance();
        Assertions.assertNotNull((Object)dv);
        Assertions.assertThrows(IllegalStateException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"}));
    }

    @Test
    void testInstanceOverride() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"gp"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"com"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS, (String[])new String[]{"cp"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance((boolean)false);
        Assertions.assertTrue((boolean)validator.isValidGenericTld("gp"));
        Assertions.assertFalse((boolean)validator.isValidGenericTld("com"));
        Assertions.assertTrue((boolean)validator.isValidCountryCodeTld("cp"));
        Assertions.assertFalse((boolean)validator.isValidCountryCodeTld("ch"));
        ArrayList<DomainValidator.Item> items = new ArrayList<DomainValidator.Item>();
        items.add(new DomainValidator.Item(DomainValidator.ArrayType.GENERIC_MINUS, new String[]{""}));
        items.add(new DomainValidator.Item(DomainValidator.ArrayType.COUNTRY_CODE_MINUS, new String[]{""}));
        validator = DomainValidator.getInstance((boolean)false, items);
        Assertions.assertTrue((boolean)validator.isValidGenericTld("gp"));
        Assertions.assertTrue((boolean)validator.isValidGenericTld("com"));
        Assertions.assertTrue((boolean)validator.isValidCountryCodeTld("cp"));
        Assertions.assertTrue((boolean)validator.isValidCountryCodeTld("ch"));
        validator = DomainValidator.getInstance((boolean)false);
        Assertions.assertTrue((boolean)validator.isValidGenericTld("gp"));
        Assertions.assertFalse((boolean)validator.isValidGenericTld("com"));
        Assertions.assertTrue((boolean)validator.isValidCountryCodeTld("cp"));
        Assertions.assertFalse((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    void testUpdateBaseArrayCC() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_RO, (String[])new String[]{"com"}));
        Assertions.assertEquals((Object)"Cannot update the table: COUNTRY_CODE_RO", (Object)thrown.getMessage());
    }

    @Test
    void testUpdateBaseArrayGeneric() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_RO, (String[])new String[]{"com"}));
        Assertions.assertEquals((Object)"Cannot update the table: GENERIC_RO", (Object)thrown.getMessage());
    }

    @Test
    void testUpdateBaseArrayInfra() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.INFRASTRUCTURE_RO, (String[])new String[]{"com"}));
        Assertions.assertEquals((Object)"Cannot update the table: INFRASTRUCTURE_RO", (Object)thrown.getMessage());
    }

    @Test
    void testUpdateBaseArrayLocal() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_RO, (String[])new String[]{"com"}));
        Assertions.assertEquals((Object)"Cannot update the table: LOCAL_RO", (Object)thrown.getMessage());
    }

    @Test
    void testUpdateCountryCode1a() {
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValidCountryCodeTld("com"));
    }

    @Test
    void testUpdateCountryCode1b() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS, (String[])new String[]{"com"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidCountryCodeTld("com"));
    }

    @Test
    void testUpdateCountryCode2() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS, (String[])new String[]{"com"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"com"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValidCountryCodeTld("com"));
    }

    @Test
    void testUpdateCountryCode3a() {
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    void testUpdateCountryCode3b() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    void testUpdateCountryCode3c() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"xx"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    void testUpdateGeneric1() {
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValidGenericTld("ch"));
    }

    @Test
    void testUpdateGeneric2() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidGenericTld("ch"));
    }

    @Test
    void testUpdateGeneric3() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValidGenericTld("ch"));
        Assertions.assertTrue((boolean)validator.isValidGenericTld("com"));
    }

    @Test
    void testUpdateGeneric4() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"com"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValidGenericTld("com"));
    }

    @Test
    void testUpdateGeneric5() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"com"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"xx"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidGenericTld("com"));
    }

    @Test
    void testValidator412a() {
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValidGenericTld("local"));
        Assertions.assertFalse((boolean)validator.isValid("abc.local"));
        Assertions.assertFalse((boolean)validator.isValidGenericTld("pvt"));
        Assertions.assertFalse((boolean)validator.isValid("abc.pvt"));
    }

    @Test
    void testValidator412b() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"local", "pvt"});
        DomainValidator validator = DomainValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidGenericTld("local"));
        Assertions.assertTrue((boolean)validator.isValid("abc.local"));
        Assertions.assertTrue((boolean)validator.isValidGenericTld("pvt"));
        Assertions.assertTrue((boolean)validator.isValid("abc.pvt"));
    }

    @Test
    void testValidator412c() {
        DomainValidator validator = DomainValidator.getInstance((boolean)true);
        Assertions.assertFalse((boolean)validator.isValidLocalTld("local"));
        Assertions.assertFalse((boolean)validator.isValid("abc.local"));
        Assertions.assertFalse((boolean)validator.isValidLocalTld("pvt"));
        Assertions.assertFalse((boolean)validator.isValid("abc.pvt"));
    }

    @Test
    void testValidator412d() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_PLUS, (String[])new String[]{"local", "pvt"});
        DomainValidator validator = DomainValidator.getInstance((boolean)true);
        Assertions.assertTrue((boolean)validator.isValidLocalTld("local"));
        Assertions.assertTrue((boolean)validator.isValidLocalTld("pvt"));
        Assertions.assertTrue((boolean)validator.isValid("abc.local"));
        Assertions.assertTrue((boolean)validator.isValid("abc.pvt"));
    }
}

