/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.apache.cxf.microprofile.client.MicroProfileClientConfigurableImpl;
import org.apache.cxf.microprofile.client.MicroProfileClientFactoryBean;
import org.apache.cxf.microprofile.client.Validator;
import org.apache.cxf.microprofile.client.sse.SseMessageBodyReader;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class CxfTypeSafeClientBuilder
implements RestClientBuilder,
Configurable<RestClientBuilder> {
    private static final Map<ClassLoader, Collection<RestClientListener>> REST_CLIENT_LISTENERS = new WeakHashMap<ClassLoader, Collection<RestClientListener>>();
    private String baseUri;
    private ExecutorService executorService;
    private final MicroProfileClientConfigurableImpl<RestClientBuilder> configImpl = new MicroProfileClientConfigurableImpl<CxfTypeSafeClientBuilder>(this);
    private TLSConfiguration secConfig = new TLSConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<RestClientListener> listeners() {
        ClassLoader threadContextClassLoader = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        Map<ClassLoader, Collection<RestClientListener>> map = REST_CLIENT_LISTENERS;
        synchronized (map) {
            return REST_CLIENT_LISTENERS.computeIfAbsent(threadContextClassLoader, key -> StreamSupport.stream(ServiceLoader.load(RestClientListener.class).spliterator(), false).collect(Collectors.toList()));
        }
    }

    public RestClientBuilder baseUrl(URL url) {
        this.baseUri = Objects.requireNonNull(url).toExternalForm();
        return this;
    }

    public RestClientBuilder baseUri(URI uri) {
        this.baseUri = Objects.requireNonNull(uri).toString();
        return this;
    }

    public RestClientBuilder executorService(ExecutorService executor) {
        if (null == executor) {
            throw new IllegalArgumentException("executor must not be null");
        }
        this.executorService = executor;
        return this;
    }

    public RestClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        if (null == unit) {
            throw new IllegalArgumentException("time unit must not be null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        return this.property("http.connection.timeout", unit.toMillis(timeout));
    }

    public RestClientBuilder readTimeout(long timeout, TimeUnit unit) {
        if (null == unit) {
            throw new IllegalArgumentException("time unit must not be null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        return this.property("http.receive.timeout", unit.toMillis(timeout));
    }

    public <T> T build(Class<T> aClass) {
        if (this.baseUri == null) {
            throw new IllegalStateException("baseUrl not set");
        }
        Validator.checkValid(aClass);
        RegisterProvider[] providers = (RegisterProvider[])aClass.getAnnotationsByType(RegisterProvider.class);
        Configuration config = this.configImpl.getConfiguration();
        if (providers != null) {
            for (RegisterProvider provider : providers) {
                if (config.isRegistered(provider.value())) continue;
                if (provider.priority() == -1) {
                    this.register(provider.value());
                    continue;
                }
                this.register(provider.value(), provider.priority());
            }
        }
        this.register(SseMessageBodyReader.class);
        CxfTypeSafeClientBuilder.listeners().forEach(l -> l.onNewClient(aClass, (RestClientBuilder)this));
        MicroProfileClientFactoryBean bean = new MicroProfileClientFactoryBean(this.configImpl, this.baseUri, aClass, this.executorService, this.secConfig);
        return (T)bean.create(aClass, new Object[0]);
    }

    public Configuration getConfiguration() {
        return this.configImpl.getConfiguration();
    }

    public RestClientBuilder property(String key, Object value) {
        this.configImpl.property(key, value);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass) {
        this.configImpl.register(componentClass);
        return this;
    }

    public RestClientBuilder register(Object component) {
        this.configImpl.register(component);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, int priority) {
        this.configImpl.register(componentClass, priority);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.configImpl.register(componentClass, contracts);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.configImpl.register(componentClass, contracts);
        return this;
    }

    public RestClientBuilder register(Object component, int priority) {
        this.configImpl.register(component, priority);
        return this;
    }

    public RestClientBuilder register(Object component, Class<?> ... contracts) {
        this.configImpl.register(component, contracts);
        return this;
    }

    public RestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.configImpl.register(component, contracts);
        return this;
    }

    public RestClientBuilder sslContext(SSLContext sslContext) {
        this.property("org.apache.cxf.microprofile.client.sslConfigProvided", "true");
        this.secConfig.getTlsClientParams().setKeyManagers(null);
        this.secConfig.getTlsClientParams().setTrustManagers(null);
        this.secConfig.setSslContext(sslContext);
        return this;
    }

    public RestClientBuilder keyStore(KeyStore store, String password) {
        this.property("org.apache.cxf.microprofile.client.sslConfigProvided", "true");
        this.secConfig.setSslContext(null);
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(store, password.toCharArray());
            this.secConfig.getTlsClientParams().setKeyManagers(kmf.getKeyManagers());
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
        return this;
    }

    public RestClientBuilder trustStore(KeyStore store) {
        this.property("org.apache.cxf.microprofile.client.sslConfigProvided", "true");
        this.secConfig.setSslContext(null);
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(store);
            this.secConfig.getTlsClientParams().setTrustManagers(tmf.getTrustManagers());
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
        return this;
    }

    public RestClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.property("org.apache.cxf.microprofile.client.sslConfigProvided", "true");
        this.secConfig.getTlsClientParams().setHostnameVerifier(verifier);
        return this;
    }

    public RestClientBuilder followRedirects(boolean follows) {
        this.configImpl.property("http.autoredirect", Boolean.toString(follows));
        return this;
    }

    public RestClientBuilder proxyAddress(String proxyHost, int proxyPort) {
        if (proxyHost == null) {
            throw new IllegalArgumentException("proxyHost must not be null");
        }
        if (proxyPort < 1 || proxyPort > 65535) {
            throw new IllegalArgumentException("proxyPort must be between 1 and 65535");
        }
        this.configImpl.property("http.proxy.server.uri", proxyHost);
        this.configImpl.property("http.proxy.server.port", proxyPort);
        return this;
    }

    public RestClientBuilder queryParamStyle(QueryParamStyle style) {
        switch (style) {
            case ARRAY_PAIRS: {
                this.configImpl.property("use.array.syntax.for.query.values", true);
                break;
            }
            case COMMA_SEPARATED: {
                this.configImpl.property("expand.query.value.as.collection", true);
                break;
            }
        }
        return this;
    }

    public void close() {
        this.configImpl.close();
    }
}

