/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleDownHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final PagingManager pagingManager;
    final PostOffice postOffice;
    private NodeManager nodeManager;
    private final ClusterController clusterController;
    private final StorageManager storageManager;
    private final int commitInterval;
    private String targetNodeId;

    public ScaleDownHandler(PagingManager pagingManager, PostOffice postOffice, NodeManager nodeManager, ClusterController clusterController, StorageManager storageManager, int commitInterval) {
        this.pagingManager = pagingManager;
        this.postOffice = postOffice;
        this.nodeManager = nodeManager;
        this.clusterController = clusterController;
        this.storageManager = storageManager;
        this.commitInterval = commitInterval;
    }

    public long scaleDown(ClientSessionFactory sessionFactory, ResourceManager resourceManager, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, SimpleString managementAddress, SimpleString targetNodeId) throws Exception {
        ClusterControl clusterControl = this.clusterController.connectToNodeInCluster((ClientSessionFactoryInternal)sessionFactory);
        clusterControl.authorize();
        long num = this.scaleDownMessages(sessionFactory, targetNodeId, clusterControl.getClusterUser(), clusterControl.getClusterPassword());
        ActiveMQServerLogger.LOGGER.infoScaledDownMessages(num);
        this.scaleDownTransactions(sessionFactory, resourceManager, clusterControl.getClusterUser(), clusterControl.getClusterPassword());
        this.scaleDownDuplicateIDs(duplicateIDMap, sessionFactory, managementAddress, clusterControl.getClusterUser(), clusterControl.getClusterPassword());
        clusterControl.announceScaleDown(SimpleString.of((String)this.targetNodeId), this.nodeManager.getNodeId());
        return num;
    }

    public long scaleDownMessages(ClientSessionFactory sessionFactory, SimpleString nodeId, String user, String password) throws Exception {
        long messageCount = 0L;
        this.targetNodeId = nodeId != null ? nodeId.toString() : this.getTargetNodeId(sessionFactory);
        try (ClientSession session = sessionFactory.createSession(user, password, false, true, true, false, 0);){
            ClientProducer producer = session.createProducer();
            for (SimpleString address : this.postOffice.getAddresses()) {
                logger.debug("Scaling down address {}", (Object)address);
                Bindings bindings = this.postOffice.lookupBindingsForAddress(address);
                TreeSet<Queue> queues = new TreeSet<Queue>(new OrderQueueByNumberOfReferencesComparator());
                if (bindings != null) {
                    for (Binding binding : bindings.getBindings()) {
                        LocalQueueBinding localQueueBinding;
                        Queue queue;
                        if (!(binding instanceof LocalQueueBinding) || (queue = (localQueueBinding = (LocalQueueBinding)binding).getQueue()).isTemporary()) continue;
                        queue.deliverScheduledMessages();
                        queues.add(queue);
                    }
                }
                String sfPrefix = ((PostOfficeImpl)this.postOffice).getServer().getInternalNamingPrefix() + "sf.";
                if (address.toString().startsWith(sfPrefix)) {
                    messageCount += this.scaleDownSNF(address, queues, producer);
                    continue;
                }
                messageCount += this.scaleDownRegularMessages(address, queues, session, producer);
            }
        }
        return messageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scaleDownRegularMessages(SimpleString address, Set<Queue> queues, ClientSession clientSession, ClientProducer producer) throws Exception {
        logger.debug("Scaling down messages on address {}", (Object)address);
        long messageCount = 0L;
        HashMap<Queue, QueuesXRefInnerManager> controls = new HashMap<Queue, QueuesXRefInnerManager>();
        PagingStore pageStore = this.pagingManager.getPageStore(address);
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        if (pageStore != null) {
            pageStore.disableCleanup();
        }
        try {
            for (Queue queue : queues) {
                controls.put(queue, new QueuesXRefInnerManager(clientSession, queue, pageStore));
            }
            for (Queue loopQueue : queues) {
                logger.debug("Scaling down messages on address {} / performing loop on queue {}", (Object)address, (Object)loopQueue);
                try {
                    LinkedListIterator<MessageReference> messagesIterator = loopQueue.browserIterator();
                    try {
                        while (messagesIterator.hasNext()) {
                            MessageReference messageReference = (MessageReference)messagesIterator.next();
                            Message message = messageReference.getMessage().copy();
                            logger.debug("Reading message {} from queue {}", (Object)message, (Object)loopQueue);
                            HashSet<QueuesXRefInnerManager> queuesFound = new HashSet<QueuesXRefInnerManager>();
                            for (Map.Entry controlEntry : controls.entrySet()) {
                                if (controlEntry.getKey() == loopQueue) {
                                    queuesFound.add((QueuesXRefInnerManager)controlEntry.getValue());
                                    continue;
                                }
                                if (!((QueuesXRefInnerManager)controlEntry.getValue()).lookup(messageReference)) continue;
                                logger.debug("Message existed on queue {} removeID={}", (Object)((Queue)controlEntry.getKey()).getID(), (Object)((QueuesXRefInnerManager)controlEntry.getValue()).getQueueID());
                                queuesFound.add((QueuesXRefInnerManager)controlEntry.getValue());
                            }
                            ByteBuffer buffer = ByteBuffer.allocate(queuesFound.size() * 8);
                            for (QueuesXRefInnerManager control : queuesFound) {
                                long queueID = control.getQueueID();
                                buffer.putLong(queueID);
                            }
                            message.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), buffer.array());
                            if (logger.isDebugEnabled()) {
                                if (messageReference.isPaged()) {
                                    logger.debug("*********************<<<<< Scaling down pdgmessage {}", (Object)message);
                                } else {
                                    logger.debug("*********************<<<<< Scaling down message {}", (Object)message);
                                }
                            }
                            producer.send(address, message);
                            if (this.commitInterval > 0 && ++messageCount % (long)this.commitInterval == 0L) {
                                tx.commit();
                                tx = new TransactionImpl(this.storageManager);
                            }
                            messagesIterator.remove();
                            for (QueuesXRefInnerManager queueFound : queuesFound) {
                                this.ackMessageOnQueue(tx, queueFound.getQueue(), messageReference);
                            }
                        }
                    }
                    finally {
                        if (messagesIterator == null) continue;
                        messagesIterator.close();
                    }
                }
                catch (NoSuchElementException ignored) {
                    logger.debug(ignored.getMessage(), (Throwable)ignored);
                }
            }
            tx.commit();
            for (QueuesXRefInnerManager controlRemoved : controls.values()) {
                controlRemoved.close();
            }
            long l = messageCount;
            return l;
        }
        finally {
            if (pageStore != null) {
                pageStore.enableCleanup();
                pageStore.getCursorProvider().scheduleCleanup();
            }
        }
    }

    private long scaleDownSNF(SimpleString address, Set<Queue> queues, ClientProducer producer) throws Exception {
        long messageCount = 0L;
        boolean queueOnTarget = address.toString().endsWith(this.targetNodeId);
        String propertyEnd = queueOnTarget ? this.targetNodeId : address.toString().substring(address.toString().lastIndexOf("."));
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        for (Queue queue : queues) {
            try {
                LinkedListIterator<MessageReference> messagesIterator = queue.browserIterator();
                try {
                    while (messagesIterator.hasNext()) {
                        MessageReference messageRef = (MessageReference)messagesIterator.next();
                        Message message = messageRef.getMessage().copy();
                        byte[] oldRouteToIDs = null;
                        ArrayList<SimpleString> propertiesToRemove = new ArrayList<SimpleString>();
                        message.removeProperty(Message.HDR_ROUTE_TO_IDS.toString());
                        for (SimpleString propName : message.getPropertyNames()) {
                            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
                            if (propName.toString().endsWith(propertyEnd)) {
                                oldRouteToIDs = message.getBytesProperty(propName.toString());
                            }
                            propertiesToRemove.add(propName);
                        }
                        for (SimpleString propertyToRemove : propertiesToRemove) {
                            message.removeProperty(propertyToRemove.toString());
                        }
                        if (queueOnTarget) {
                            message.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), oldRouteToIDs);
                        } else {
                            message.putBytesProperty(Message.HDR_SCALEDOWN_TO_IDS.toString(), oldRouteToIDs);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Scaling down message {} from {} to {} on node {}", new Object[]{message, address, message.getAddress(), this.targetNodeId});
                        }
                        producer.send(message.getAddress(), message);
                        if (this.commitInterval > 0 && ++messageCount % (long)this.commitInterval == 0L) {
                            tx.commit();
                            tx = new TransactionImpl(this.storageManager);
                        }
                        messagesIterator.remove();
                        this.ackMessageOnQueue(tx, queue, messageRef);
                    }
                }
                finally {
                    if (messagesIterator == null) continue;
                    messagesIterator.close();
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        tx.commit();
        return messageCount;
    }

    private String getTargetNodeId(ClientSessionFactory sessionFactory) {
        return sessionFactory.getServerLocator().getTopology().getMember(sessionFactory.getConnection()).getNodeId();
    }

    public void scaleDownTransactions(ClientSessionFactory sessionFactory, ResourceManager resourceManager, String user, String password) throws Exception {
        ClientSession session = sessionFactory.createSession(user, password, true, false, false, false, 0);
        ClientSession queueCreateSession = sessionFactory.createSession(user, password, false, true, true, false, 0);
        List<Xid> preparedTransactions = resourceManager.getPreparedTransactions();
        HashMap<String, Long> queueIDs = new HashMap<String, Long>();
        for (Xid xid : preparedTransactions) {
            logger.debug("Scaling down transaction: {}", (Object)xid);
            Transaction transaction = resourceManager.getTransaction(xid);
            session.start(xid, 0);
            List<TransactionOperation> allOperations = transaction.getAllOperations();
            HashMap<Message, Pair> queuesToSendTo = new HashMap<Message, Pair>();
            for (TransactionOperation operation : allOperations) {
                Pair queueIds;
                long queueID;
                String queueName;
                Queue queue;
                Message message;
                List<MessageReference> refs;
                if (operation instanceof PostOfficeImpl.AddOperation) {
                    PostOfficeImpl.AddOperation addOperation = (PostOfficeImpl.AddOperation)operation;
                    refs = addOperation.getRelatedMessageReferences();
                    for (MessageReference ref : refs) {
                        message = ref.getMessage();
                        queue = ref.getQueue();
                        queueName = queue.getName().toString();
                        if (queueIDs.containsKey(queueName)) {
                            queueID = (Long)queueIDs.get(queueName);
                        } else {
                            queueID = this.createQueueWithRoutingTypeIfNecessaryAndGetID(queueCreateSession, queue, message.getAddressSimpleString(), message.getRoutingType());
                            queueIDs.put(queueName, queueID);
                        }
                        queueIds = (Pair)queuesToSendTo.get(message);
                        if (queueIds == null) {
                            queueIds = new Pair(new ArrayList(), new ArrayList());
                            queuesToSendTo.put(message, queueIds);
                        }
                        ((List)queueIds.getA()).add(queueID);
                    }
                    continue;
                }
                if (!(operation instanceof RefsOperation)) continue;
                RefsOperation refsOperation = (RefsOperation)operation;
                refs = refsOperation.getReferencesToAcknowledge();
                for (MessageReference ref : refs) {
                    message = ref.getMessage();
                    queue = ref.getQueue();
                    queueName = queue.getName().toString();
                    if (queueIDs.containsKey(queueName)) {
                        queueID = (Long)queueIDs.get(queueName);
                    } else {
                        queueID = this.createQueueWithRoutingTypeIfNecessaryAndGetID(queueCreateSession, queue, message.getAddressSimpleString(), message.getRoutingType());
                        queueIDs.put(queueName, queueID);
                    }
                    queueIds = (Pair)queuesToSendTo.get(message);
                    if (queueIds == null) {
                        queueIds = new Pair(new ArrayList(), new ArrayList());
                        queuesToSendTo.put(message, queueIds);
                    }
                    ((List)queueIds.getA()).add(queueID);
                    ((List)queueIds.getB()).add(queueID);
                }
            }
            ClientProducer producer = session.createProducer();
            for (Map.Entry entry : queuesToSendTo.entrySet()) {
                List ids = (List)((Pair)entry.getValue()).getA();
                ByteBuffer buffer = ByteBuffer.allocate(ids.size() * 8);
                for (Long id : ids) {
                    buffer.putLong(id);
                }
                Message message = (Message)entry.getKey();
                message.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), buffer.array());
                ids = (List)((Pair)entry.getValue()).getB();
                if (!ids.isEmpty()) {
                    buffer = ByteBuffer.allocate(ids.size() * 8);
                    for (Long id : ids) {
                        buffer.putLong(id);
                    }
                    message.putBytesProperty(Message.HDR_ROUTE_TO_ACK_IDS.toString(), buffer.array());
                }
                producer.send(message.getAddressSimpleString().toString(), message);
            }
            session.end(xid, 0x4000000);
            session.prepare(xid);
        }
    }

    public void scaleDownDuplicateIDs(Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, ClientSessionFactory sessionFactory, SimpleString managementAddress, String user, String password) throws Exception {
        try (ClientSession session = sessionFactory.createSession(user, password, true, false, false, false, 0);
             ClientProducer producer = session.createProducer(managementAddress);){
            for (Map.Entry<SimpleString, List<Pair<byte[], Long>>> entry : duplicateIDMap.entrySet()) {
                ClientMessage message = session.createMessage(false);
                List<Pair<byte[], Long>> list = entry.getValue();
                String[] array = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Pair<byte[], Long> pair = list.get(i);
                    array[i] = new String((byte[])pair.getA());
                }
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"updateDuplicateIdCache", (Object[])new Object[]{entry.getKey().toString(), array});
                producer.send((Message)message);
            }
        }
    }

    private long createQueueWithRoutingTypeIfNecessaryAndGetID(ClientSession session, Queue queue, SimpleString addressName, RoutingType routingType) throws Exception {
        long queueID = this.getQueueID(session, queue.getName());
        if (queueID == -1L) {
            session.createQueue(QueueConfiguration.of((SimpleString)queue.getName()).setAddress(addressName).setRoutingType(routingType).setFilterString(queue.getFilter() == null ? null : queue.getFilter().getFilterString()).setDurable(Boolean.valueOf(queue.isDurable())));
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to get queue ID, creating queue [addressName={}, queueName={}, routingType={}, filter={}, durable={}]", new Object[]{addressName, queue.getName(), queue.getRoutingType(), queue.getFilter() == null ? "" : queue.getFilter().getFilterString(), queue.isDurable()});
            }
            queueID = this.getQueueID(session, queue.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ID for {} is: {}", (Object)queue, (Object)queueID);
        }
        return queueID;
    }

    private Long getQueueID(ClientSession session, SimpleString queueName) throws Exception {
        Object result;
        Long queueID = -1L;
        try (ClientRequestor requestor = new ClientRequestor(session, "activemq.management");){
            ClientMessage managementMessage = session.createMessage(false);
            ManagementHelper.putAttribute((ICoreMessage)managementMessage, (String)("queue." + String.valueOf(queueName)), (String)"ID");
            session.start();
            logger.debug("Requesting ID for: {}", (Object)queueName);
            ClientMessage reply = requestor.request(managementMessage);
            result = ManagementHelper.getResult((ICoreMessage)reply);
        }
        if (result != null && result instanceof Number) {
            Number number = (Number)result;
            queueID = number.longValue();
        }
        return queueID;
    }

    private void ackMessageOnQueue(Transaction tx, Queue queue, MessageReference messageRef) throws Exception {
        queue.acknowledge(tx, messageRef);
    }

    public static class OrderQueueByNumberOfReferencesComparator
    implements Comparator<Queue> {
        @Override
        public int compare(Queue queue1, Queue queue2) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            int result = 0;
            if (queue1 == queue2) {
                return 0;
            }
            if (queue1.getMessageCount() == queue2.getMessageCount()) {
                long tieBreak = queue2.getID() - queue1.getID();
                if (tieBreak > 0L) {
                    return 1;
                }
                if (tieBreak < 0L) {
                    return -1;
                }
                return 0;
            }
            if (queue1.getMessageCount() > queue2.getMessageCount()) {
                return -1;
            }
            if (queue1.getMessageCount() < queue2.getMessageCount()) {
                return 1;
            }
            return result;
        }
    }

    private class QueuesXRefInnerManager {
        private final Queue queue;
        private LinkedListIterator<MessageReference> memoryIterator;
        private MessageReference lastRef = null;
        private final PagingStore store;
        private final ClientSession clientSession;
        private long targetQueueID = -1L;

        QueuesXRefInnerManager(ClientSession clientSession, Queue queue, PagingStore store) {
            this.queue = queue;
            this.store = store;
            this.clientSession = clientSession;
        }

        public Queue getQueue() {
            return this.queue;
        }

        public long getQueueID() throws Exception {
            if (this.targetQueueID < 0L) {
                this.targetQueueID = ScaleDownHandler.this.createQueueWithRoutingTypeIfNecessaryAndGetID(this.clientSession, this.queue, this.queue.getAddress(), this.queue.getRoutingType());
            }
            return this.targetQueueID;
        }

        public void close() {
            if (this.memoryIterator != null) {
                this.memoryIterator.close();
            }
        }

        public boolean lookup(MessageReference reference) throws Exception {
            if (reference.isPaged()) {
                if (this.store == null) {
                    return false;
                }
                PageSubscription subscription = this.store.getCursorProvider().getSubscription(this.queue.getID());
                if (subscription.contains((PagedReference)reference)) {
                    return true;
                }
            } else {
                if (this.lastRef != null && this.lastRef.getMessage().equals(reference.getMessage())) {
                    this.lastRef = null;
                    this.memoryIterator.remove();
                    return true;
                }
                int numberOfScans = 2;
                if (this.memoryIterator == null) {
                    numberOfScans = 1;
                }
                MessageReference initialRef = null;
                for (int i = 0; i < numberOfScans; ++i) {
                    logger.debug("Iterating on queue {} while looking for reference {}", (Object)this.queue, (Object)reference);
                    this.memoryIterator = this.queue.iterator();
                    while (this.memoryIterator.hasNext()) {
                        this.lastRef = (MessageReference)this.memoryIterator.next();
                        logger.debug("Iterating on message {}", (Object)this.lastRef);
                        if (this.lastRef.getMessage().equals(reference.getMessage())) {
                            this.memoryIterator.remove();
                            this.lastRef = null;
                            return true;
                        }
                        if (initialRef == null) {
                            initialRef = this.lastRef;
                            continue;
                        }
                        if (!initialRef.equals(this.lastRef)) continue;
                        if (!this.memoryIterator.hasNext()) {
                            this.lastRef = null;
                            this.memoryIterator.close();
                            this.memoryIterator = null;
                        }
                        return false;
                    }
                }
            }
            this.lastRef = null;
            if (this.memoryIterator != null) {
                this.memoryIterator.close();
                this.memoryIterator = null;
            }
            return false;
        }
    }
}

