/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.impl.PermDAO;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.AuthZ;
import org.apache.directory.fortress.core.model.Bind;
import org.apache.directory.fortress.core.model.Mod;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.core.util.AuditUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.time.TUtil;
import org.apache.directory.ldap.client.api.LdapConnection;

final class AuditDAO
extends LdapDataProvider {
    private static final String CREATETIMESTAMP = "createTimestamp";
    private static final String CREATORSNAME = "creatorsName";
    private static final String ENTRYCSN = "entryCSN";
    private static final String ENTRYDN = "entryDN";
    private static final String ENTRYUUID = "entryUUID";
    private static final String HASSUBORDINATES = "hasSubordinates";
    private static final String MODIFIERSNAME = "modifiersName";
    private static final String MODIFYTIMESTAMP = "modifyTimestamp";
    private static final String OBJECTCLASS = "objectClass";
    private static final String REQUAUTHZID = "reqAuthzID";
    private static final String REQCONTROLS = "reqControls";
    private static final String REQDN = "reqDN";
    private static final String REQEND = "reqEnd";
    private static final String REQMETHOD = "reqMethod";
    private static final String REQRESULT = "reqResult";
    private static final String REQSESSION = "reqSession";
    private static final String REQSTART = "reqStart";
    private static final String REQTYPE = "reqType";
    private static final String REQVERSION = "reqVersion";
    private static final String REQMOD = "reqMod";
    private static final String STRUCTURALOBJECTCLASS = "structuralObjectClass";
    private static final String SUBSCHEMAENTRY = "subschemaSubentry";
    private static final String REQATTR = "reqAttr";
    private static final String REQATTRSONLY = "reqAttrsOnly";
    private static final String REQDREFALIASES = "reqDerefAliases";
    private static final String REQENTRIES = "reqEntries";
    private static final String REQFILTER = "reqFilter";
    private static final String REQSCOPE = "reqScope";
    private static final String REQSIZELIMIT = "reqSizeLimit";
    private static final String REQTIMELIMIT = "reqTimeLimit";
    private static final String REQASSERTION = "reqAssertion";
    private static final String ACCESS_BIND_CLASS_NM = "auditBind";
    private static final String ACCESS_AUTHZ_CLASS_NM = "auditCompare";
    private static final String ACCESS_MOD_CLASS_NM = "auditModify";
    private static final String ACCESS_ADD_CLASS_NM = "auditAdd";
    private static final String AUDIT_ROOT = "audit.root";
    private static final String[] AUDIT_AUTHZ_ATRS = new String[]{"createTimestamp", "creatorsName", "entryCSN", "entryDN", "entryUUID", "hasSubordinates", "modifiersName", "modifyTimestamp", "objectClass", "reqAttr", "reqAttrsOnly", "reqAuthzID", "reqControls", "reqDN", "reqDerefAliases", "reqEnd", "reqEntries", "reqFilter", "reqResult", "reqScope", "reqSession", "reqSizeLimit", "reqStart", "reqTimeLimit", "reqType", "structuralObjectClass", "subschemaSubentry"};
    private static final String[] AUDIT_BIND_ATRS = new String[]{"createTimestamp", "creatorsName", "entryCSN", "entryDN", "entryUUID", "hasSubordinates", "modifiersName", "modifyTimestamp", "objectClass", "reqAuthzID", "reqControls", "reqDN", "reqEnd", "reqMethod", "reqResult", "reqSession", "reqStart", "reqType", "reqVersion", "structuralObjectClass", "subschemaSubentry"};
    private static final String[] AUDIT_MOD_ATRS = new String[]{"objectClass", "reqAuthzID", "reqDN", "reqEnd", "reqResult", "reqSession", "reqStart", "reqType", "reqMod"};

    List<AuthZ> searchInvalidAuthNs(UserAudit audit) throws FinderException {
        ArrayList<AuthZ> auditList = new ArrayList<AuthZ>();
        LdapConnection ld = null;
        String auditRoot = Config.getInstance().getProperty(AUDIT_ROOT);
        String userRoot = Config.getInstance().getProperty("user.root");
        try {
            Object filter = "(&(objectClass=auditCompare)(";
            if (StringUtils.isNotEmpty((String)audit.getUserId())) {
                String userId = audit.getUserId();
                filter = (String)filter + "reqDN=uid=" + userId + "," + userRoot + ")(reqAuthzID=cn=Manager," + Config.getInstance().getProperty("suffix") + ")";
            } else {
                filter = (String)filter + "reqAttr=uid)(reqAuthzID=cn=Manager," + Config.getInstance().getProperty("suffix") + ")";
            }
            if (audit.isFailedOnly()) {
                filter = (String)filter + "(reqEntries=0)";
            }
            if (audit.getBeginDate() != null) {
                String szTime = TUtil.encodeGeneralizedTime(audit.getBeginDate());
                filter = (String)filter + "(reqEnd>=" + szTime + ")";
            }
            filter = (String)filter + ")";
            ld = this.getLogConnection();
            try (SearchCursor searchResults = this.search(ld, auditRoot, SearchScope.ONELEVEL, (String)filter, AUDIT_AUTHZ_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    AuthZ authZ = this.getAuthzEntityFromLdapEntry(searchResults.getEntry(), sequence++);
                    if (AuditUtil.getAuthZId(authZ.getReqDN()).equalsIgnoreCase("People")) continue;
                    auditList.add(authZ);
                }
            }
            catch (IOException i) {
                String error = "IOException in AuditDAO.searchAuthZs id=" + i.getMessage();
                throw new FinderException(7005, error, i);
            }
            catch (CursorException e) {
                String error = "CursorException in AuditDAO.searchAuthZs id=" + e.getMessage();
                throw new FinderException(7005, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "LdapException in AuditDAO.searchAuthZs id=" + e;
                throw new FinderException(7005, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeLogConnection(ld);
                throw throwable;
            }
        }
        this.closeLogConnection(ld);
        return auditList;
    }

    List<AuthZ> searchAuthZs(UserAudit audit) throws FinderException {
        ArrayList<AuthZ> auditList = new ArrayList<AuthZ>();
        LdapConnection ld = null;
        String auditRoot = Config.getInstance().getProperty(AUDIT_ROOT);
        String permRoot = this.getRootDn(audit.isAdmin(), audit.getContextId());
        String userRoot = AuditDAO.getRootDn(audit.getContextId(), "user.root");
        try {
            String reqDn = PermDAO.getOpRdn(audit.getOpName(), audit.getObjId()) + ",ftObjNm=" + audit.getObjName() + "," + permRoot;
            String filter = "(&(objectClass=auditCompare)(reqDN=" + reqDn + ")(reqAuthzID=uid=" + audit.getUserId() + "," + userRoot + ")";
            if (audit.isFailedOnly()) {
                filter = filter + "(reqResult=5)";
            }
            if (audit.getBeginDate() != null) {
                String szTime = TUtil.encodeGeneralizedTime(audit.getBeginDate());
                filter = filter + "(reqEnd>=" + szTime + ")";
            }
            filter = filter + ")";
            ld = this.getLogConnection();
            try (SearchCursor searchResults = this.search(ld, auditRoot, SearchScope.ONELEVEL, filter, AUDIT_AUTHZ_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    auditList.add(this.getAuthzEntityFromLdapEntry(searchResults.getEntry(), sequence++));
                }
            }
            catch (IOException i) {
                String error = "IOException in AuditDAO.searchAuthZs id=" + i.getMessage();
                throw new FinderException(7002, error, i);
            }
            catch (CursorException e) {
                String error = "CursorException in AuditDAO.searchAuthZs id=" + e.getMessage();
                throw new FinderException(7002, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "LdapException in AuditDAO.searchAuthZs id=" + e;
                throw new FinderException(7002, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeLogConnection(ld);
                throw throwable;
            }
        }
        this.closeLogConnection(ld);
        return auditList;
    }

    private String getRootDn(boolean isAdmin, String contextId) {
        String dn = isAdmin ? AuditDAO.getRootDn(contextId, "adminperm.root") : AuditDAO.getRootDn(contextId, "perm.root");
        return dn;
    }

    List<AuthZ> getAllAuthZs(UserAudit audit) throws FinderException {
        ArrayList<AuthZ> auditList = new ArrayList<AuthZ>();
        LdapConnection ld = null;
        String auditRoot = Config.getInstance().getProperty(AUDIT_ROOT);
        String userRoot = AuditDAO.getRootDn(audit.getContextId(), "user.root");
        try {
            Object filter = "(&(objectClass=auditCompare)(";
            if (audit.getUserId() != null && audit.getUserId().length() > 0) {
                filter = (String)filter + "reqAuthzID=uid=" + audit.getUserId() + "," + userRoot + ")";
            } else {
                filter = (String)filter + "reqAuthzID=*)(!(reqAuthzID=cn=Manager," + Config.getInstance().getProperty("suffix") + "))";
                if (audit.isFailedOnly()) {
                    filter = (String)filter + "(reqResult=5)";
                }
            }
            if (audit.getBeginDate() != null) {
                String szTime = TUtil.encodeGeneralizedTime(audit.getBeginDate());
                filter = (String)filter + "(reqEnd>=" + szTime + ")";
            }
            filter = (String)filter + ")";
            ld = this.getLogConnection();
            try (SearchCursor searchResults = this.search(ld, auditRoot, SearchScope.ONELEVEL, (String)filter, AUDIT_AUTHZ_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    auditList.add(this.getAuthzEntityFromLdapEntry(searchResults.getEntry(), sequence++));
                }
            }
            catch (IOException i) {
                String error = "IOException in AuditDAO.getAllAuthZs id=" + i.getMessage();
                throw new FinderException(7002, error, i);
            }
            catch (CursorException e) {
                String error = "CursorException in AuditDAO.getAllAuthZs id=" + e.getMessage();
                throw new FinderException(7002, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "LdapException in AuditDAO.getAllAuthZs id=" + e;
                throw new FinderException(7002, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeLogConnection(ld);
                throw throwable;
            }
        }
        this.closeLogConnection(ld);
        return auditList;
    }

    List<Bind> searchBinds(UserAudit audit) throws FinderException {
        ArrayList<Bind> auditList = new ArrayList<Bind>();
        LdapConnection ld = null;
        String auditRoot = Config.getInstance().getProperty(AUDIT_ROOT);
        String userRoot = AuditDAO.getRootDn(audit.getContextId(), "user.root");
        try {
            String szTime;
            Object filter;
            if (audit.getUserId() != null && audit.getUserId().length() > 0) {
                filter = "(&(objectClass=auditBind)(reqDN=uid=" + audit.getUserId() + "," + userRoot + ")";
                if (audit.isFailedOnly()) {
                    filter = (String)filter + "(reqResult>=1)";
                }
                if (audit.getBeginDate() != null) {
                    szTime = TUtil.encodeGeneralizedTime(audit.getBeginDate());
                    filter = (String)filter + "(reqEnd>=" + szTime + ")";
                }
                filter = (String)filter + ")";
            } else {
                filter = "(&(objectClass=auditBind)";
                if (audit.isFailedOnly()) {
                    filter = (String)filter + "(reqResult>=1)";
                }
                if (audit.getBeginDate() != null) {
                    szTime = TUtil.encodeGeneralizedTime(audit.getBeginDate());
                    filter = (String)filter + "(reqEnd>=" + szTime + ")";
                }
                filter = (String)filter + ")";
            }
            ld = this.getLogConnection();
            try (SearchCursor searchResults = this.search(ld, auditRoot, SearchScope.ONELEVEL, (String)filter, AUDIT_BIND_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    auditList.add(this.getBindEntityFromLdapEntry(searchResults.getEntry(), sequence++));
                }
            }
            catch (IOException i) {
                String error = "IOException in AuditDAO.searchBinds id=" + i.getMessage();
                throw new FinderException(7000, error, i);
            }
            catch (CursorException e) {
                String error = "CursorException in AuditDAO.searchBinds id=" + e.getMessage();
                throw new FinderException(7000, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "LdapException in AuditDAO.searchBinds id=" + e;
                throw new FinderException(7000, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeLogConnection(ld);
                throw throwable;
            }
        }
        this.closeLogConnection(ld);
        return auditList;
    }

    List<Mod> searchUserMods(UserAudit audit) throws FinderException {
        ArrayList<Mod> modList = new ArrayList<Mod>();
        LdapConnection ld = null;
        String auditRoot = Config.getInstance().getProperty(AUDIT_ROOT);
        String userRoot = AuditDAO.getRootDn(audit.getContextId(), "user.root");
        try {
            String filter = "(&(objectClass=auditModify)(reqDN=uid=" + audit.getUserId() + "," + userRoot + ")";
            if (audit.getBeginDate() != null) {
                String szTime = TUtil.encodeGeneralizedTime(audit.getBeginDate());
                filter = filter + "(reqEnd>=" + szTime + ")";
            }
            filter = filter + ")";
            ld = this.getLogConnection();
            try (SearchCursor searchResults = this.search(ld, auditRoot, SearchScope.ONELEVEL, filter, AUDIT_MOD_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    modList.add(this.getModEntityFromLdapEntry(searchResults.getEntry(), sequence++));
                }
            }
            catch (IOException i) {
                String error = "searchUserMods caught IOException id=" + i.getMessage();
                throw new FinderException(7003, error, i);
            }
            catch (CursorException e) {
                String error = "searchUserMods caught CursorException id=" + e.getMessage();
                throw new FinderException(7003, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "searchUserMods caught LdapException id=" + e;
                throw new FinderException(7003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeLogConnection(ld);
                throw throwable;
            }
        }
        this.closeLogConnection(ld);
        return modList;
    }

    List<Mod> searchAdminMods(UserAudit audit) throws FinderException {
        ArrayList<Mod> modList = new ArrayList<Mod>();
        LdapConnection ld = null;
        String auditRoot = Config.getInstance().getProperty(AUDIT_ROOT);
        try {
            String szTime;
            Object filter = "(&(|(objectclass=auditModify)";
            filter = (String)filter + "(objectclass=auditAdd))";
            if (StringUtils.isNotEmpty((String)audit.getDn())) {
                filter = (String)filter + "(reqDN=" + audit.getDn() + ")";
            }
            if (StringUtils.isNotEmpty((String)audit.getObjName())) {
                filter = (String)filter + "(|(reqMod=ftModCode:= " + audit.getObjName() + ".";
                if (StringUtils.isNotEmpty((String)audit.getOpName())) {
                    filter = (String)filter + audit.getOpName();
                }
                filter = (String)filter + "*)";
                filter = (String)filter + "(reqMod=ftModCode:+ " + audit.getObjName() + ".";
                if (StringUtils.isNotEmpty((String)audit.getOpName())) {
                    filter = (String)filter + audit.getOpName();
                }
                filter = (String)filter + "*))";
            }
            if (StringUtils.isNotEmpty((String)audit.getInternalUserId())) {
                filter = (String)filter + "(|(reqMod=ftModifier:= " + audit.getInternalUserId() + ")";
                filter = (String)filter + "(reqMod=ftModifier:+ " + audit.getInternalUserId() + "))";
            }
            if (audit.getBeginDate() != null) {
                szTime = TUtil.encodeGeneralizedTime(audit.getBeginDate());
                filter = (String)filter + "(reqEnd>=" + szTime + ")";
            }
            if (audit.getEndDate() != null) {
                szTime = TUtil.encodeGeneralizedTime(audit.getEndDate());
                filter = (String)filter + "(reqEnd<=" + szTime + ")";
            }
            filter = (String)filter + ")";
            ld = this.getLogConnection();
            try (SearchCursor searchResults = this.search(ld, auditRoot, SearchScope.ONELEVEL, (String)filter, AUDIT_MOD_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    modList.add(this.getModEntityFromLdapEntry(searchResults.getEntry(), sequence++));
                }
            }
            catch (IOException i) {
                String error = "searchAdminMods caught IOException id=" + i.getMessage();
                throw new FinderException(7004, error, i);
            }
            catch (CursorException e) {
                String error = "searchAdminMods caught CursorException id=" + e.getMessage();
                throw new FinderException(7004, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "searchAdminMods caught LdapException id=" + e;
                throw new FinderException(7004, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeLogConnection(ld);
                throw throwable;
            }
        }
        this.closeLogConnection(ld);
        return modList;
    }

    private Bind getBindEntityFromLdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        Bind auditBind = new ObjectFactory().createBind();
        auditBind.setSequenceId(sequence);
        auditBind.setCreateTimestamp(this.getAttribute(le, CREATETIMESTAMP));
        auditBind.setCreatorsName(this.getAttribute(le, CREATORSNAME));
        auditBind.setEntryCSN(this.getAttribute(le, ENTRYCSN));
        auditBind.setEntryDN(this.getAttribute(le, ENTRYDN));
        auditBind.setEntryUUID(this.getAttribute(le, ENTRYUUID));
        auditBind.setHasSubordinates(this.getAttribute(le, HASSUBORDINATES));
        auditBind.setModifiersName(this.getAttribute(le, MODIFIERSNAME));
        auditBind.setModifyTimestamp(this.getAttribute(le, MODIFYTIMESTAMP));
        auditBind.setObjectClass(this.getAttribute(le, OBJECTCLASS));
        auditBind.setReqAuthzID(this.getAttribute(le, REQUAUTHZID));
        auditBind.setReqControls(this.getAttribute(le, REQCONTROLS));
        auditBind.setReqDN(this.getAttribute(le, REQDN));
        auditBind.setReqEnd(this.getAttribute(le, REQEND));
        auditBind.setReqMethod(this.getAttribute(le, REQMETHOD));
        auditBind.setReqResult(this.getAttribute(le, REQRESULT));
        auditBind.setReqSession(this.getAttribute(le, REQSESSION));
        auditBind.setReqStart(this.getAttribute(le, REQSTART));
        auditBind.setReqType(this.getAttribute(le, REQTYPE));
        auditBind.setReqVersion(this.getAttribute(le, REQVERSION));
        auditBind.setStructuralObjectClass(this.getAttribute(le, STRUCTURALOBJECTCLASS));
        return auditBind;
    }

    private AuthZ getAuthzEntityFromLdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        AuthZ authZ = new ObjectFactory().createAuthZ();
        authZ.setSequenceId(sequence);
        authZ.setCreateTimestamp(this.getAttribute(le, CREATETIMESTAMP));
        authZ.setCreatorsName(this.getAttribute(le, CREATORSNAME));
        authZ.setEntryCSN(this.getAttribute(le, ENTRYCSN));
        authZ.setEntryDN(this.getAttribute(le, ENTRYDN));
        authZ.setEntryUUID(this.getAttribute(le, ENTRYUUID));
        authZ.setHasSubordinates(this.getAttribute(le, HASSUBORDINATES));
        authZ.setModifiersName(this.getAttribute(le, MODIFIERSNAME));
        authZ.setModifyTimestamp(this.getAttribute(le, MODIFYTIMESTAMP));
        authZ.setObjectClass(this.getAttribute(le, OBJECTCLASS));
        authZ.setReqAuthzID(this.getAttribute(le, REQUAUTHZID));
        authZ.setReqControls(this.getAttribute(le, REQCONTROLS));
        authZ.setReqDN(this.getAttribute(le, REQDN));
        authZ.setReqEnd(this.getAttribute(le, REQEND));
        authZ.setReqResult(this.getAttribute(le, REQRESULT));
        authZ.setReqSession(this.getAttribute(le, REQSESSION));
        authZ.setReqStart(this.getAttribute(le, REQSTART));
        authZ.setReqType(this.getAttribute(le, REQTYPE));
        authZ.setStructuralObjectClass(this.getAttribute(le, STRUCTURALOBJECTCLASS));
        authZ.setReqAttr(this.getAttribute(le, REQATTR));
        authZ.setReqAttrsOnly(this.getAttribute(le, REQATTRSONLY));
        authZ.setReqDerefAliases(this.getAttribute(le, REQDREFALIASES));
        authZ.setReqEntries(this.getAttribute(le, REQENTRIES));
        authZ.setReqFilter(this.getAttribute(le, REQFILTER));
        authZ.setReqScope(this.getAttribute(le, REQSCOPE));
        authZ.setReqSizeLimit(this.getAttribute(le, REQSIZELIMIT));
        authZ.setReqTimeLimit(this.getAttribute(le, REQTIMELIMIT));
        return authZ;
    }

    private Mod getModEntityFromLdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        Mod mod = new ObjectFactory().createMod();
        mod.setSequenceId(sequence);
        mod.setObjectClass(this.getAttribute(le, OBJECTCLASS));
        mod.setReqAuthzID(this.getAttribute(le, REQUAUTHZID));
        mod.setReqDN(this.getAttribute(le, REQDN));
        mod.setReqEnd(this.getAttribute(le, REQEND));
        mod.setReqResult(this.getAttribute(le, REQRESULT));
        mod.setReqSession(this.getAttribute(le, REQSESSION));
        mod.setReqStart(this.getAttribute(le, REQSTART));
        mod.setReqType(this.getAttribute(le, REQTYPE));
        mod.setReqMod(this.getAttributes(le, REQMOD));
        return mod;
    }
}

