/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.RestException;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.Props;
import org.apache.directory.fortress.core.rest.CachedJaxbContext;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.EncryptUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestUtils {
    private static final String CLS_NM = RestUtils.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final int HTTP_OK = 200;
    private static final int HTTP_400_VALIDATION_EXCEPTION = 400;
    private static final int HTTP_401_UNAUTHORIZED = 401;
    private static final int HTTP_403_FORBIDDEN = 403;
    private static final int HTTP_404_NOT_FOUND = 404;
    private static final int HTTP_500_INTERNAL_SERVER_ERROR = 500;
    private static final String VALID_RESPONSE = "FortResponse";
    private static CachedJaxbContext cachedJaxbContext = new CachedJaxbContext();
    private static volatile RestUtils sINSTANCE = null;
    private String trustStore;
    private String trustStorePw;
    private String httpUid;
    private String httpPw;
    private String httpHost;
    private String httpPort;
    private String httpProtocol;
    private String fortressRestVersion;
    private String serviceName;
    private String uri;

    static FortRequest getRequest(String szContextId) {
        FortRequest request = new FortRequest();
        request.setContextId(szContextId);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestUtils getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<RestUtils> clazz = RestUtils.class;
        synchronized (RestUtils.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new RestUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private void init() {
        this.httpUid = Config.getInstance().getProperty("http.user");
        this.httpPw = EncryptUtil.isEnabled() ? EncryptUtil.getInstance().decrypt(Config.getInstance().getProperty("http.pw")) : Config.getInstance().getProperty("http.pw");
        this.httpHost = Config.getInstance().getProperty("http.host");
        this.httpPort = Config.getInstance().getProperty("http.port");
        this.httpProtocol = Config.getInstance().getProperty("http.protocol", "http");
        this.trustStore = Config.getInstance().getProperty("trust.store");
        this.trustStorePw = Config.getInstance().getProperty("trust.store.password");
        this.fortressRestVersion = System.getProperty("version");
        this.serviceName = "fortress-rest-" + this.fortressRestVersion;
        this.uri = this.httpProtocol + "://" + this.httpHost + ":" + this.httpPort + "/" + this.serviceName + "/";
        LOG.info("HTTP Connect Properties: host:{}, port:{}, protocol:{}, version:{}, service:{}, uri:{}", new Object[]{this.httpHost, this.httpPort, this.httpProtocol, this.fortressRestVersion, this.serviceName, this.uri});
        if (StringUtils.isNotEmpty((String)this.trustStore) && StringUtils.isNotEmpty((String)this.trustStorePw)) {
            LOG.info("javax.net.ssl.trustStore: {}", (Object)this.trustStore);
            System.setProperty("javax.net.ssl.trustStore", this.trustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePw);
        }
    }

    private RestUtils() {
        this.init();
    }

    public static String marshal(FortRequest request) throws RestException {
        String szRetValue;
        try {
            JAXBContext context = cachedJaxbContext.getJaxbContext(FortRequest.class);
            Marshaller marshaller = context.createMarshaller();
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)request, (Writer)stringWriter);
            szRetValue = stringWriter.toString();
        }
        catch (JAXBException je) {
            String error = "marshal caught JAXBException=" + je;
            throw new RestException(10103, error, (Exception)((Object)je));
        }
        return szRetValue;
    }

    public static FortResponse unmarshall(String szResponse) throws RestException {
        FortResponse response;
        try {
            JAXBContext context = cachedJaxbContext.getJaxbContext(FortResponse.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            response = (FortResponse)unmarshaller.unmarshal((Reader)new StringReader(szResponse));
        }
        catch (JAXBException je) {
            String error = "unmarshall caught JAXBException=" + je;
            throw new RestException(10104, error, (Exception)((Object)je));
        }
        return response;
    }

    public String get(String userId, String password, String id, String id2, String id3, String function) throws RestException {
        String szResponse;
        String url = this.uri + function + "/" + id;
        if (id2 != null) {
            url = url + "/" + id2;
        }
        if (id3 != null) {
            url = url + "/" + id3;
        }
        LOG.debug("get function1:{}, id1:{}, id2:{}, id3:{}, url:{}", new Object[]{function, id, id2, id3, url});
        HttpGet get = null;
        try {
            get = new HttpGet(url);
            RestUtils.setMethodHeaders((HttpRequest)get);
            szResponse = RestUtils.handleHttpMethod((HttpRequestBase)get, (HttpClient)HttpClientBuilder.create().useSystemProperties().setDefaultCredentialsProvider(this.getCredentialProvider(userId, password)).build());
        }
        catch (WebApplicationException we) {
            String error = this.generateErrorMessage(this.uri, function, "caught WebApplicationException=" + we.getMessage());
            LOG.error(error, (Throwable)we);
            throw new RestException(10101, error, (Exception)((Object)we));
        }
        catch (NoSuchMethodError e) {
            String error = this.generateErrorMessage(this.uri, function, "caught NoSuchMethodError = " + e.getMessage());
            LOG.error(error, (Throwable)e);
            throw new RestException(10107, error);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return szResponse;
    }

    public String get(String id, String id2, String id3, String function) throws RestException {
        return this.get(null, null, id, id2, id3, function);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String post(String userId, String password, String szInput, String function) throws RestException {
        LOG.debug("post uri=[{}], function=[{}], request=[{}]", new Object[]{this.uri, function, szInput});
        String szResponse = null;
        HttpPost post = new HttpPost(this.uri + function);
        post.addHeader("Accept", "text/xml");
        RestUtils.setMethodHeaders((HttpRequest)post);
        try {
            StringEntity entity = new StringEntity(szInput, ContentType.TEXT_XML);
            post.setEntity((HttpEntity)entity);
            CloseableHttpClient httpclient = HttpClientBuilder.create().useSystemProperties().setDefaultCredentialsProvider(this.getCredentialProvider(userId, password)).build();
            HttpResponse response = httpclient.execute((HttpUriRequest)post);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    szResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                    if (StringUtils.isNotEmpty((String)szResponse) && szResponse.contains(VALID_RESPONSE)) {
                        LOG.debug("post uri=[{}], function=[{}], response=[{}]", new Object[]{this.uri, function, szResponse});
                        return szResponse;
                    }
                    String error = this.generateErrorMessage(this.uri, function, "invalid response");
                    LOG.error(error);
                    throw new RestException(10106, error);
                }
                case 401: {
                    String error = this.generateErrorMessage(this.uri, function, "401 function unauthorized on host");
                    LOG.error(error);
                    throw new RestException(10109, error);
                }
                case 403: {
                    String error = this.generateErrorMessage(this.uri, function, "403 function forbidden on host");
                    LOG.error(error);
                    throw new RestException(10108, error);
                }
                case 404: {
                    szResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                    if (StringUtils.isNotEmpty((String)szResponse) && szResponse.contains(VALID_RESPONSE)) {
                        LOG.debug("HTTP: 404: post uri=[{}], function=[{}], response=[{}]", new Object[]{this.uri, function, szResponse});
                        return szResponse;
                    }
                    String error = this.generateErrorMessage(this.uri, function, "HTTP Error:" + response.getStatusLine().getStatusCode());
                    LOG.error(error);
                    throw new RestException(10106, error);
                }
                case 500: {
                    szResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                    if (StringUtils.isNotEmpty((String)szResponse) && szResponse.contains(VALID_RESPONSE)) {
                        LOG.debug("HTTP 500: post uri=[{}], function=[{}], response=[{}]", new Object[]{this.uri, function, szResponse});
                        return szResponse;
                    }
                    String error = this.generateErrorMessage(this.uri, function, "HTTP 500 Internal Error:" + response.getStatusLine().getStatusCode());
                    LOG.error(error);
                    throw new RestException(10111, error);
                }
                case 400: {
                    szResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                    if (StringUtils.isNotEmpty((String)szResponse) && szResponse.contains(VALID_RESPONSE)) {
                        LOG.debug("HTTP 400: post uri=[{}], function=[{}], response=[{}]", new Object[]{this.uri, function, szResponse});
                        return szResponse;
                    }
                    String error = this.generateErrorMessage(this.uri, function, "HTTP 400 Validation Error:" + response.getStatusLine().getStatusCode());
                    LOG.error(error);
                    throw new RestException(10112, error);
                }
                default: {
                    String error = this.generateErrorMessage(this.uri, function, "error received from host: " + response.getStatusLine().getStatusCode());
                    LOG.error(error);
                    throw new RestException(10107, error);
                }
            }
        }
        catch (IOException ioe) {
            String error = this.generateErrorMessage(this.uri, function, "caught IOException=" + ioe.getMessage());
            LOG.error(error, (Throwable)ioe);
            throw new RestException(10102, error, ioe);
        }
        catch (WebApplicationException we) {
            String error = this.generateErrorMessage(this.uri, function, "caught WebApplicationException=" + we.getMessage());
            LOG.error(error, (Throwable)we);
            throw new RestException(10101, error, (Exception)((Object)we));
        }
        catch (NoSuchMethodError e) {
            String error = this.generateErrorMessage(this.uri, function, "caught Exception = " + e.getMessage());
            LOG.error(error, (Throwable)e);
            throw new RestException(10107, error);
        }
        finally {
            post.releaseConnection();
        }
    }

    private String generateErrorMessage(String uri, String function, String messageToShow) {
        return "post uri=[" + uri + "], function=[" + function + "], " + messageToShow;
    }

    public String post(String szInput, String function) throws RestException {
        return this.post(null, null, szInput, function);
    }

    private CredentialsProvider getCredentialProvider(String uid, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.httpHost, Integer.valueOf(this.httpPort).intValue()), (Credentials)new UsernamePasswordCredentials(uid == null ? this.httpUid : uid, password == null ? this.httpPw : password));
        return credentialsProvider;
    }

    private static void setMethodHeaders(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpPost || httpRequest instanceof HttpPut) {
            httpRequest.addHeader("Content-Type", "application/xml");
            httpRequest.addHeader("Accept", "application/xml");
        }
    }

    private static String base64Encode(String value) {
        return new String(Base64.encodeBase64((byte[])value.getBytes()));
    }

    private static String handleHttpMethod(HttpRequestBase httpGetRequest, HttpClient client) throws RestException {
        String szResponse = null;
        try {
            HttpResponse response = client.execute((HttpUriRequest)httpGetRequest);
            LOG.debug("handleHttpMethod Response status : {}", (Object)response.getStatusLine().getStatusCode());
            Response.Status status = Response.Status.fromStatusCode((int)response.getStatusLine().getStatusCode());
            if (status == Response.Status.OK) {
                szResponse = IOUtils.toString((InputStream)response.getEntity().getContent());
                LOG.debug(szResponse);
            } else if (status == Response.Status.FORBIDDEN) {
                LOG.debug("handleHttpMethod Authorization failure");
            } else if (status == Response.Status.UNAUTHORIZED) {
                LOG.debug("handleHttpMethod Authentication failure");
            } else {
                LOG.debug("handleHttpMethod Unknown error");
            }
        }
        catch (IOException ioe) {
            String error = "handleHttpMethod caught IOException=" + ioe;
            LOG.error(error);
            throw new RestException(10102, error, ioe);
        }
        finally {
            httpGetRequest.releaseConnection();
        }
        return szResponse;
    }

    public static Properties getProperties(Props inProps) {
        Properties properties = null;
        List<Props.Entry> props = inProps.getEntry();
        if (props.size() > 0) {
            properties = new Properties();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                properties.setProperty(key, val);
            }
        }
        return properties;
    }

    public static Props getProps(Properties properties) {
        Props props = null;
        if (properties != null) {
            props = new ObjectFactory().createProps();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = properties.getProperty(key);
                Props.Entry entry = new Props.Entry();
                entry.setKey(key);
                entry.setValue(val);
                props.getEntry().add(entry);
            }
        }
        return props;
    }
}

