/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin.schema;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.drill.plugin.DrillStoragePlugin;
import org.apache.drill.exec.store.drill.plugin.schema.DrillPluginSchema;
import org.apache.drill.exec.util.ImpersonationUtil;

public class DrillSchemaFactory
extends AbstractSchemaFactory {
    private final LoadingCache<Pair<String, String>, DrillPluginSchema> databases;
    private final DrillStoragePlugin plugin;

    public DrillSchemaFactory(DrillStoragePlugin plugin, String schemaName) {
        super(schemaName);
        this.plugin = plugin;
        this.databases = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new DatabaseLoader());
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        try {
            String userName = Optional.ofNullable(schemaConfig.getUserName()).orElse(ImpersonationUtil.getProcessUserName());
            DrillPluginSchema schema = (DrillPluginSchema)((Object)this.databases.get((Object)Pair.of((Object)this.getName(), (Object)userName)));
            SchemaPlus hPlus = parent.add(this.getName(), (Schema)schema);
            schema.setHolder(hPlus);
        }
        catch (ExecutionException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    private class DatabaseLoader
    extends CacheLoader<Pair<String, String>, DrillPluginSchema> {
        private DatabaseLoader() {
        }

        public DrillPluginSchema load(Pair<String, String> key) {
            return new DrillPluginSchema(DrillSchemaFactory.this.plugin, (String)key.getKey(), (String)key.getValue());
        }
    }
}

