/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.msaccess;

import com.google.common.io.Files;
import java.io.File;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.ReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.msaccess.MSAccessBatchReader;
import org.apache.drill.exec.store.msaccess.MSAccessFormatConfig;
import org.apache.hadoop.conf.Configuration;

public class MSAccessFormatPlugin
extends EasyFormatPlugin<MSAccessFormatConfig> {
    protected static final String DEFAULT_NAME = "msaccess";
    private final DrillbitContext context;

    public MSAccessFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig, MSAccessFormatConfig formatConfig) {
        super(name, MSAccessFormatPlugin.easyConfig(fsConf, formatConfig), context, storageConfig, (FormatPluginConfig)formatConfig);
        this.context = context;
    }

    private static EasyFormatPlugin.EasyFormatConfig easyConfig(Configuration fsConf, MSAccessFormatConfig pluginConfig) {
        return EasyFormatPlugin.EasyFormatConfig.builder().readable(true).writable(false).blockSplittable(false).blockSplittable(false).compressible(true).supportsProjectPushdown(true).extensions(pluginConfig.getExtensions()).fsConf(fsConf).defaultName(DEFAULT_NAME).scanVersion(EasyFormatPlugin.ScanFrameworkVersion.EVF_V2).supportsLimitPushdown(true).build();
    }

    protected void configureScan(FileScanLifecycleBuilder builder, EasySubScan scan) {
        builder.nullType(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        builder.readerFactory((ReaderFactory)new MSAccessReaderFactory(this.getTmpDir(), (MSAccessFormatConfig)this.formatConfig));
    }

    protected File getTmpDir() {
        DrillConfig config = this.context.getConfig();
        String drillTempDir = config.hasPath("drill.tmp-dir") ? config.getString("drill.tmp-dir") : System.getenv("DRILL_TMP_DIR");
        if (drillTempDir == null) {
            return Files.createTempDir();
        }
        return new File(drillTempDir);
    }

    private static class MSAccessReaderFactory
    extends FileReaderFactory {
        private final File tempDir;
        private final MSAccessFormatConfig config;

        public MSAccessReaderFactory(File tempDir, MSAccessFormatConfig config) {
            this.tempDir = tempDir;
            this.config = config;
        }

        public ManagedReader newReader(FileSchemaNegotiator negotiator) {
            return new MSAccessBatchReader(negotiator, this.tempDir, this.config);
        }
    }
}

