/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.util.SchemaUtil;

public class TableInfo {
    private final byte[] tenantId;
    private final byte[] schema;
    private final byte[] name;

    public TableInfo(byte[] tenantId, byte[] schema, byte[] name) {
        this.tenantId = tenantId;
        this.schema = schema;
        this.name = name;
    }

    public byte[] getRowKeyPrefix() {
        return SchemaUtil.getTableKey(this.tenantId, this.schema, this.name);
    }

    public String toString() {
        return Bytes.toStringBinary((byte[])this.getRowKeyPrefix());
    }

    public byte[] getTenantId() {
        return this.tenantId;
    }

    public byte[] getSchemaName() {
        return this.schema;
    }

    public byte[] getTableName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.name);
        result = 31 * result + Arrays.hashCode(this.schema);
        result = 31 * result + Arrays.hashCode(this.tenantId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableInfo other = (TableInfo)obj;
        if (!Arrays.equals(this.name, other.name)) {
            return false;
        }
        if (!Arrays.equals(this.schema, other.schema)) {
            return false;
        }
        return Arrays.equals(this.tenantId, other.tenantId);
    }
}

