/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.JacksonUtil;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRegionObserver
implements RegionObserver,
RegionCoprocessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(TaskRegionObserver.class);
    public static final String TASK_DETAILS = "TaskDetails";
    protected ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(PTable.TaskType.values().length);
    private long timeInterval = 60000L;
    private long timeMaxInterval = 1800000L;
    @GuardedBy(value="TaskRegionObserver.class")
    private long initialDelay = 10000L;
    private static Map<PTable.TaskType, String> classMap = ImmutableMap.builder().put((Object)PTable.TaskType.DROP_CHILD_VIEWS, (Object)"org.apache.phoenix.coprocessor.tasks.DropChildViewsTask").put((Object)PTable.TaskType.INDEX_REBUILD, (Object)"org.apache.phoenix.coprocessor.tasks.IndexRebuildTask").build();

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.executor.shutdownNow();
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        Configuration config = env.getConfiguration();
        this.timeInterval = config.getLong("phoenix.task.handling.interval.ms", 60000L);
        this.timeMaxInterval = config.getLong("phoenix.task.handling.maxInterval.ms", 1800000L);
        this.initialDelay = config.getLong("phoenix.task.handling.initial.delay.ms", 10000L);
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e.getEnvironment();
        SelfHealingTask task = new SelfHealingTask((RegionCoprocessorEnvironment)e.getEnvironment(), this.timeMaxInterval);
        this.executor.scheduleWithFixedDelay(task, this.initialDelay, this.timeInterval, TimeUnit.MILLISECONDS);
    }

    public static class SelfHealingTask
    extends TimerTask {
        protected RegionCoprocessorEnvironment env;
        protected long timeMaxInterval;
        protected boolean accessCheckEnabled;

        public SelfHealingTask(RegionCoprocessorEnvironment env, long timeMaxInterval) {
            this.env = env;
            this.accessCheckEnabled = env.getConfiguration().getBoolean("phoenix.acls.enabled", false);
            this.timeMaxInterval = timeMaxInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PhoenixConnection connForTask = null;
            try {
                connForTask = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                String[] excludeStates = new String[]{PTable.TaskStatus.FAILED.toString(), PTable.TaskStatus.COMPLETED.toString()};
                List<Task.TaskRecord> taskRecords = Task.queryTaskTable(connForTask, excludeStates);
                for (Task.TaskRecord taskRecord : taskRecords) {
                    try {
                        PTable.TaskType taskType = taskRecord.getTaskType();
                        if (!classMap.containsKey((Object)taskType)) {
                            LOGGER.warn("Don't know how to execute task type: " + taskType.name());
                            continue;
                        }
                        String className = (String)classMap.get((Object)taskType);
                        Class<?> concreteClass = Class.forName(className);
                        Object obj = concreteClass.newInstance();
                        Method runMethod = concreteClass.getDeclaredMethod("run", Task.TaskRecord.class);
                        Method checkCurretResult = concreteClass.getDeclaredMethod("checkCurrentResult", Task.TaskRecord.class);
                        Method initMethod = concreteClass.getSuperclass().getDeclaredMethod("init", RegionCoprocessorEnvironment.class, Long.class);
                        initMethod.invoke(obj, this.env, this.timeMaxInterval);
                        TaskResult result = null;
                        if (taskRecord.getStatus() != null && taskRecord.getStatus().equals(PTable.TaskStatus.STARTED.toString())) {
                            result = (TaskResult)checkCurretResult.invoke(obj, taskRecord);
                        }
                        if (result == null) {
                            if ((taskRecord = Task.queryTaskTable(connForTask, taskRecord.getTimeStamp(), taskRecord.getSchemaName(), taskRecord.getTableName(), taskType, taskRecord.getTenantId(), null).get(0)).getStatus() != null && !taskRecord.getStatus().equals(PTable.TaskStatus.CREATED.toString())) continue;
                            Task.addTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(connForTask).setTaskType(taskRecord.getTaskType()).setTenantId(taskRecord.getTenantId()).setSchemaName(taskRecord.getSchemaName()).setTableName(taskRecord.getTableName()).setTaskStatus(PTable.TaskStatus.STARTED.toString()).setData(taskRecord.getData()).setPriority(taskRecord.getPriority()).setStartTs(taskRecord.getTimeStamp()).setEndTs(null).setAccessCheckEnabled(true).build());
                            result = (TaskResult)runMethod.invoke(obj, taskRecord);
                        }
                        if (result == null) continue;
                        String taskStatus = PTable.TaskStatus.FAILED.toString();
                        if (result.getResultCode() == TaskResultCode.SUCCESS) {
                            taskStatus = PTable.TaskStatus.COMPLETED.toString();
                        } else if (result.getResultCode() == TaskResultCode.SKIPPED) continue;
                        SelfHealingTask.setEndTaskStatus(connForTask, taskRecord, taskStatus);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Exception while running self healingtask. It will be retried in the next system task table scan :  taskType : " + taskRecord.getTaskType().name() + taskRecord.getSchemaName() + "." + taskRecord.getTableName() + " with tenant id " + (taskRecord.getTenantId() == null ? " IS NULL" : taskRecord.getTenantId()) + " and timestamp " + taskRecord.getTimeStamp().toString(), t);
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.error("SelfHealingTask failed!", t);
            }
            finally {
                if (connForTask != null) {
                    try {
                        connForTask.close();
                    }
                    catch (SQLException ignored) {
                        LOGGER.debug("SelfHealingTask can't close connection", (Throwable)ignored);
                    }
                }
            }
        }

        public static void setEndTaskStatus(PhoenixConnection connForTask, Task.TaskRecord taskRecord, String taskStatus) throws IOException, SQLException {
            String data = taskRecord.getData();
            if (Strings.isNullOrEmpty((String)data)) {
                data = "{}";
            }
            JsonNode jsonNode = JacksonUtil.getObjectReader().readTree(data);
            ((ObjectNode)jsonNode).put(TaskRegionObserver.TASK_DETAILS, taskStatus);
            data = jsonNode.toString();
            Timestamp endTs = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Task.addTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(connForTask).setTaskType(taskRecord.getTaskType()).setTenantId(taskRecord.getTenantId()).setSchemaName(taskRecord.getSchemaName()).setTableName(taskRecord.getTableName()).setTaskStatus(taskStatus).setData(data).setPriority(taskRecord.getPriority()).setStartTs(taskRecord.getTimeStamp()).setEndTs(endTs).setAccessCheckEnabled(true).build());
        }
    }

    public static class TaskResult {
        private TaskResultCode resultCode;
        private String details;

        public TaskResult(TaskResultCode resultCode, String details) {
            this.resultCode = resultCode;
            this.details = details;
        }

        public TaskResultCode getResultCode() {
            return this.resultCode;
        }

        public String getDetails() {
            return this.details;
        }

        public String toString() {
            String result = this.resultCode.name();
            if (!Strings.isNullOrEmpty((String)this.details)) {
                result = result + " - " + this.details;
            }
            return result;
        }
    }

    public static enum TaskResultCode {
        SUCCESS,
        FAIL,
        SKIPPED;

    }
}

