/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.coprocessor.tasks.BaseTask;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.util.JacksonUtil;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRebuildTask
extends BaseTask {
    public static final String INDEX_NAME = "IndexName";
    public static final String JOB_ID = "JobID";
    public static final String DISABLE_BEFORE = "DisableBefore";
    public static final String REBUILD_ALL = "RebuildAll";
    public static final Logger LOGGER = LoggerFactory.getLogger(IndexRebuildTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskRegionObserver.TaskResult run(Task.TaskRecord taskRecord) {
        Connection conn = null;
        try {
            String rebuildAllStr;
            String disableBefore;
            JsonNode jsonNode;
            String indexName;
            Configuration conf = HBaseConfiguration.create((Configuration)this.env.getConfiguration());
            conn = QueryUtil.getConnectionOnServer(this.env.getConfiguration());
            conf.set("phoenix.transactions.enabled", Boolean.TRUE.toString());
            String data = taskRecord.getData();
            if (Strings.isNullOrEmpty((String)taskRecord.getData())) {
                data = "{}";
            }
            if (Strings.isNullOrEmpty((String)(indexName = this.getIndexName(jsonNode = (JsonNode)JacksonUtil.getObjectReader(JsonNode.class).readValue(data))))) {
                String str = "Index name is not found. Index rebuild cannot continue Data : " + data;
                LOGGER.warn(str);
                TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, str);
                return taskResult;
            }
            boolean shouldDisable = false;
            if (jsonNode.has(DISABLE_BEFORE) && !Strings.isNullOrEmpty((String)(disableBefore = jsonNode.get(DISABLE_BEFORE).toString()))) {
                shouldDisable = Boolean.valueOf(disableBefore);
            }
            boolean rebuildAll = false;
            if (jsonNode.has(REBUILD_ALL) && !Strings.isNullOrEmpty((String)(rebuildAllStr = jsonNode.get(REBUILD_ALL).toString()))) {
                rebuildAll = Boolean.valueOf(rebuildAllStr);
            }
            boolean runForeground = false;
            Map.Entry<Integer, Job> indexToolRes = IndexTool.run(conf, taskRecord.getSchemaName(), taskRecord.getTableName(), indexName, false, taskRecord.getTenantId(), shouldDisable, rebuildAll, runForeground);
            int status = indexToolRes.getKey();
            if (status != 0) {
                TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, "Index tool returned : " + status);
                return taskResult;
            }
            Job job = indexToolRes.getValue();
            ((ObjectNode)jsonNode).put(JOB_ID, job.getJobID().toString());
            Task.addTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(conn.unwrap(PhoenixConnection.class)).setTaskType(taskRecord.getTaskType()).setTenantId(taskRecord.getTenantId()).setSchemaName(taskRecord.getSchemaName()).setTableName(taskRecord.getTableName()).setTaskStatus(PTable.TaskStatus.STARTED.toString()).setData(jsonNode.toString()).setPriority(taskRecord.getPriority()).setStartTs(taskRecord.getTimeStamp()).setEndTs(null).setAccessCheckEnabled(true).build());
            TaskRegionObserver.TaskResult taskResult = null;
            return taskResult;
        }
        catch (Throwable t) {
            LOGGER.warn("Exception while running index rebuild task. It will be retried in the next system task table scan : " + taskRecord.getSchemaName() + "." + taskRecord.getTableName() + " with tenant id " + (taskRecord.getTenantId() == null ? " IS NULL" : taskRecord.getTenantId()) + " and data " + taskRecord.getData(), t);
            TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, t.toString());
            return taskResult;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.debug("IndexRebuildTask can't close connection");
                }
            }
        }
    }

    private String getIndexName(JsonNode jsonNode) {
        String indexName = null;
        if (jsonNode.has(INDEX_NAME)) {
            indexName = jsonNode.get(INDEX_NAME).toString().replaceAll("\"", "");
        }
        return indexName;
    }

    private String getJobID(String data) throws JsonProcessingException {
        if (Strings.isNullOrEmpty((String)data)) {
            data = "{}";
        }
        JsonNode jsonNode = JacksonUtil.getObjectReader().readTree(data);
        String jobId = null;
        if (jsonNode.has(JOB_ID)) {
            jobId = jsonNode.get(JOB_ID).textValue().replaceAll("\"", "");
        }
        return jobId;
    }

    @Override
    public TaskRegionObserver.TaskResult checkCurrentResult(Task.TaskRecord taskRecord) throws Exception {
        String jobID = this.getJobID(taskRecord.getData());
        if (jobID != null) {
            Configuration conf = HBaseConfiguration.create((Configuration)this.env.getConfiguration());
            Configuration configuration = HBaseConfiguration.addHbaseResources((Configuration)conf);
            Cluster cluster = new Cluster(configuration);
            Job job = cluster.getJob(JobID.forName((String)jobID));
            if (job == null) {
                return new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SKIPPED, "");
            }
            if (job != null && job.isComplete()) {
                if (job.isSuccessful()) {
                    LOGGER.warn("IndexRebuildTask checkCurrentResult job is successful " + taskRecord.getTableName());
                    return new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SUCCESS, "");
                }
                return new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, "Index is DISABLED");
            }
        }
        return null;
    }
}

