/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundJodaDateExpression;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.GJChronology;

public class CeilMonthExpression
extends RoundJodaDateExpression {
    public CeilMonthExpression() {
    }

    public CeilMonthExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public long roundDateTime(DateTime dateTime) {
        return dateTime.monthOfYear().roundCeilingCopy().getMillis();
    }

    @Override
    public long rangeLower(long time) {
        return new DateTime(time - 1L, (Chronology)GJChronology.getInstanceUTC()).monthOfYear().roundFloorCopy().getMillis() + 1L;
    }

    @Override
    public long rangeUpper(long time) {
        return this.roundDateTime(new DateTime(time, (Chronology)GJChronology.getInstanceUTC()));
    }
}

