/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundJodaDateExpression;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.GJChronology;

public class FloorMonthExpression
extends RoundJodaDateExpression {
    public FloorMonthExpression() {
    }

    public FloorMonthExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public long roundDateTime(DateTime datetime) {
        return datetime.monthOfYear().roundFloorCopy().getMillis();
    }

    @Override
    public long rangeLower(long time) {
        return this.roundDateTime(new DateTime(time, (Chronology)GJChronology.getInstanceUTC()));
    }

    @Override
    public long rangeUpper(long time) {
        return new DateTime(time + 1L, (Chronology)GJChronology.getInstanceUTC()).monthOfYear().roundCeilingCopy().getMillis() - 1L;
    }
}

