/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundJodaDateExpression;
import org.apache.phoenix.util.DateUtil;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.chrono.GJChronology;

public class RoundWeekExpression
extends RoundJodaDateExpression {
    public RoundWeekExpression() {
    }

    public RoundWeekExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public long roundDateTime(DateTime dateTime) {
        return dateTime.weekOfWeekyear().roundHalfEvenCopy().getMillis();
    }

    @Override
    public long rangeLower(long epochMs) {
        DateTime rounded = new DateTime(this.roundDateTime(new DateTime(epochMs, (Chronology)GJChronology.getInstanceUTC())), (Chronology)GJChronology.getInstanceUTC());
        DateTime prev = rounded.minusWeeks(1);
        return DateUtil.rangeJodaHalfEven(rounded, prev, DateTimeFieldType.weekOfWeekyear());
    }

    @Override
    public long rangeUpper(long epochMs) {
        DateTime rounded = new DateTime(this.roundDateTime(new DateTime(epochMs, (Chronology)GJChronology.getInstanceUTC())), (Chronology)GJChronology.getInstanceUTC());
        DateTime next = rounded.plusWeeks(1);
        return DateUtil.rangeJodaHalfEven(rounded, next, DateTimeFieldType.weekOfWeekyear());
    }
}

