/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.i18n.LocaleUtils;

@FunctionParseNode.BuiltInFunction(name="UPPER", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, defaultValue="null", isConstant=true)})
public class UpperFunction
extends ScalarFunction {
    public static final String NAME = "UPPER";
    private Locale locale;

    public UpperFunction() {
    }

    public UpperFunction(List<Expression> children) throws SQLException {
        super(children);
        this.initialize();
    }

    private void initialize() {
        if (this.children.size() > 1) {
            String localeISOCode = this.getLiteralValue(1, String.class);
            this.locale = LocaleUtils.get().getLocaleByIsoCode(localeISOCode);
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.initialize();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getStrExpression().evaluate(tuple, ptr)) {
            return false;
        }
        String sourceStr = (String)PVarchar.INSTANCE.toObject(ptr, this.getStrExpression().getSortOrder());
        if (sourceStr == null) {
            return true;
        }
        String resultStr = this.locale == null ? sourceStr.toUpperCase() : sourceStr.toUpperCase(this.locale);
        ptr.set(PVarchar.INSTANCE.toBytes(resultStr));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return this.getStrExpression().getDataType();
    }

    @Override
    public Integer getMaxLength() {
        return this.getStrExpression().getMaxLength();
    }

    @Override
    public boolean isNullable() {
        return this.getStrExpression().isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Expression getStrExpression() {
        return (Expression)this.children.get(0);
    }
}

