/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerContextUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.coprocessor.UncoveredGlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.UncoveredLocalIndexRegionScanner;
import org.apache.phoenix.coprocessor.generated.DynamicColumnMetaDataProtos;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedResultTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public abstract class RegionScannerFactory {
    protected RegionCoprocessorEnvironment env;

    public Region getRegion() {
        return this.env.getRegion();
    }

    public abstract RegionScanner getRegionScanner(Scan var1, RegionScanner var2) throws Throwable;

    public RegionScanner getWrappedScanner(final RegionCoprocessorEnvironment env, final RegionScanner regionScanner, final Set<KeyValueColumnExpression> arrayKVRefs, final Expression[] arrayFuncRefs, final int offset, final Scan scan, final ColumnReference[] dataColumns, final TupleProjector tupleProjector, final Region dataRegion, final IndexMaintainer indexMaintainer, PhoenixTransactionContext tx, final byte[][] viewConstants, final KeyValueSchema kvSchema, final ValueBitSet kvSchemaBitSet, final TupleProjector projector, final ImmutableBytesWritable ptr, final boolean useQualifierAsListIndex) throws IOException {
        return new RegionScanner(){
            private RegionScanner s;
            private RegionInfo regionInfo;
            private byte[] actualStartKey;
            private boolean useNewValueColumnQualifier;
            final long pageSizeMs;
            Expression extraWhere;
            long extraLimit;
            {
                this.s = regionScanner;
                this.regionInfo = env.getRegionInfo();
                this.actualStartKey = this.getActualStartKey();
                this.useNewValueColumnQualifier = EncodedColumnsUtil.useNewValueColumnQualifier(scan);
                this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner(scan);
                this.extraWhere = null;
                this.extraLimit = -1L;
                if (ScanUtil.isLocalOrUncoveredGlobalIndex(scan)) {
                    byte[] limitBytes;
                    byte[] expBytes = scan.getAttribute("_IndexFilter");
                    if (expBytes == null) {
                        expBytes = scan.getAttribute("_LocalIndexFilter");
                    }
                    if (expBytes != null) {
                        try {
                            ByteArrayInputStream stream = new ByteArrayInputStream(expBytes);
                            DataInputStream input = new DataInputStream(stream);
                            this.extraWhere = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
                            this.extraWhere.readFields(input);
                        }
                        catch (IOException io) {
                            throw new RuntimeException(io);
                        }
                    }
                    if ((limitBytes = scan.getAttribute("_IndexLimit")) == null) {
                        limitBytes = scan.getAttribute("_LocalIndexLimit");
                    }
                    if (limitBytes != null) {
                        this.extraLimit = Bytes.toLong((byte[])limitBytes);
                    }
                    if (ScanUtil.isLocalOrUncoveredGlobalIndex(scan) && tupleProjector != null) {
                        PTable.ImmutableStorageScheme storageScheme = indexMaintainer.getIndexStorageScheme();
                        Scan dataTableScan = new Scan();
                        for (int i = 0; i < dataColumns.length; ++i) {
                            if (storageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                                dataTableScan.addFamily(dataColumns[i].getFamily());
                                continue;
                            }
                            dataTableScan.addColumn(dataColumns[i].getFamily(), dataColumns[i].getQualifier());
                        }
                        this.s = ScanUtil.isLocalIndex(scan) ? new UncoveredLocalIndexRegionScanner(regionScanner, dataRegion, scan, env, dataTableScan, tupleProjector, indexMaintainer, viewConstants, ptr, this.pageSizeMs, offset, this.actualStartKey) : new UncoveredGlobalIndexRegionScanner(regionScanner, dataRegion, scan, env, dataTableScan, tupleProjector, indexMaintainer, viewConstants, ptr, this.pageSizeMs);
                    }
                }
            }

            public byte[] getActualStartKey() {
                return ScanUtil.isLocalIndex(scan) ? ScanUtil.getActualStartRow(scan, this.regionInfo) : null;
            }

            public boolean next(List<Cell> results) throws IOException {
                try {
                    boolean next = this.s.next(results);
                    if (ScanUtil.isDummy(results)) {
                        return true;
                    }
                    return next;
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(RegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                throw new IOException("Next with scannerContext should not be called in Phoenix environment");
            }

            public void close() throws IOException {
                this.s.close();
            }

            public RegionInfo getRegionInfo() {
                return this.s.getRegionInfo();
            }

            public boolean isFilterDone() throws IOException {
                return this.s.isFilterDone();
            }

            public boolean reseek(byte[] row) throws IOException {
                return this.s.reseek(row);
            }

            public long getMvccReadPoint() {
                return this.s.getMvccReadPoint();
            }

            public boolean nextRaw(List<Cell> result) throws IOException {
                try {
                    boolean next = this.s.nextRaw(result);
                    if (ScanUtil.isDummy(result)) {
                        return true;
                    }
                    if (result.size() == 0) {
                        return next;
                    }
                    if (ScanUtil.isLocalOrUncoveredGlobalIndex(scan) && !ScanUtil.isAnalyzeTable(scan)) {
                        if (ScanUtil.isLocalIndex(scan) && tupleProjector == null) {
                            if (this.actualStartKey != null) {
                                next = this.scanTillScanStartRow(this.s, result, null);
                                if (result.isEmpty() || ScanUtil.isDummy(result)) {
                                    return next;
                                }
                            }
                            IndexUtil.wrapResultUsingOffset(result, offset);
                        }
                        if (this.extraWhere != null) {
                            BaseTuple merged = useQualifierAsListIndex ? new PositionBasedResultTuple(result) : new ResultTuple(Result.create(result));
                            ImmutableBytesWritable ptr2 = new ImmutableBytesWritable();
                            this.extraWhere.evaluate(merged, ptr2);
                            if (!Boolean.TRUE.equals(this.extraWhere.getDataType().toObject(ptr2))) {
                                result.clear();
                                return next;
                            }
                        }
                    }
                    Cell arrayElementCell = null;
                    if (arrayFuncRefs != null && arrayFuncRefs.length > 0 && arrayKVRefs.size() > 0) {
                        int arrayElementCellPosition = this.replaceArrayIndexElement(arrayKVRefs, arrayFuncRefs, result);
                        arrayElementCell = result.get(arrayElementCellPosition);
                    }
                    if (projector != null) {
                        BaseTuple toProject = useQualifierAsListIndex ? new PositionBasedResultTuple(result) : new ResultTuple(Result.create(result));
                        Pair<Tuple, byte[]> mergedTupleDynColsPair = this.getTupleWithDynColsIfRequired(result, projector.projectResults(toProject, this.useNewValueColumnQualifier));
                        Tuple tupleWithDynColsIfReqd = (Tuple)mergedTupleDynColsPair.getFirst();
                        byte[] serializedDynColsList = (byte[])mergedTupleDynColsPair.getSecond();
                        result.clear();
                        result.add(tupleWithDynColsIfReqd.mergeWithDynColsListBytesAndGetValue(0, serializedDynColsList));
                        if (arrayElementCell != null) {
                            result.add(arrayElementCell);
                        }
                    }
                    if (this.extraLimit >= 0L && --this.extraLimit == 0L) {
                        return false;
                    }
                    return next;
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(RegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            private Pair<Tuple, byte[]> getTupleWithDynColsIfRequired(List<Cell> result, Tuple tuple) throws IOException {
                ArrayList<Cell> dynColCells;
                ArrayList<PColumn> dynCols;
                TupleProjector dynColTupleProj;
                if (Bytes.equals((byte[])scan.getAttribute("_WildcardScanIncludesDynCols"), (byte[])PDataType.TRUE_BYTES) && (dynColTupleProj = TupleProjector.getDynamicColumnsTupleProjector(result, dynCols = new ArrayList<PColumn>(), dynColCells = new ArrayList<Cell>())) != null) {
                    BaseTuple toProject = useQualifierAsListIndex ? new PositionBasedResultTuple(dynColCells) : new ResultTuple(Result.create(dynColCells));
                    TupleProjector.ProjectedValueTuple dynColsProjectedTuple = dynColTupleProj.projectResults(toProject, this.useNewValueColumnQualifier);
                    ValueBitSet destBitSet = projector.getValueBitSet();
                    if (projector.getSchema().getFieldCount() == 0) {
                        destBitSet = dynColTupleProj.getValueBitSet();
                    }
                    TupleProjector.ProjectedValueTuple mergedTuple = TupleProjector.mergeProjectedValue((TupleProjector.ProjectedValueTuple)tuple, destBitSet, dynColsProjectedTuple, dynColTupleProj.getValueBitSet(), projector.getSchema().getFieldCount(), this.useNewValueColumnQualifier);
                    DynamicColumnMetaDataProtos.DynamicColumnMetaData.Builder dynColsListBuilder = DynamicColumnMetaDataProtos.DynamicColumnMetaData.newBuilder();
                    for (PColumn dynCol : dynCols) {
                        dynColsListBuilder.addDynamicColumns(PColumnImpl.toProto(dynCol));
                    }
                    return new Pair((Object)mergedTuple, (Object)dynColsListBuilder.build().toByteArray());
                }
                return new Pair((Object)tuple, (Object)new byte[0]);
            }

            public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
                boolean res = this.next(result);
                ScannerContextUtil.incrementSizeProgress(scannerContext, result);
                ScannerContextUtil.updateTimeProgress(scannerContext);
                return res;
            }

            private boolean scanTillScanStartRow(RegionScanner s, List<Cell> result, ScannerContext scannerContext) throws IOException {
                boolean next = true;
                Cell firstCell = result.get(0);
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                while (Bytes.compareTo((byte[])firstCell.getRowArray(), (int)firstCell.getRowOffset(), (int)firstCell.getRowLength(), (byte[])this.actualStartKey, (int)0, (int)this.actualStartKey.length) < 0) {
                    if (EnvironmentEdgeManager.currentTimeMillis() - startTime >= this.pageSizeMs) {
                        byte[] rowKey = CellUtil.cloneRow((Cell)result.get(0));
                        result.clear();
                        ScanUtil.getDummyResult(rowKey, result);
                        return true;
                    }
                    result.clear();
                    next = scannerContext == null ? s.nextRaw(result) : s.nextRaw(result, scannerContext);
                    if (result.isEmpty()) {
                        return next;
                    }
                    if (ScanUtil.isDummy(result)) {
                        return true;
                    }
                    firstCell = result.get(0);
                }
                return next;
            }

            private int replaceArrayIndexElement(Set<KeyValueColumnExpression> arrayKVRefs2, Expression[] arrayFuncRefs2, List<Cell> result) {
                MultiKeyValueTuple tuple = new MultiKeyValueTuple((List<Cell>)ImmutableList.copyOf(result));
                Cell rowKv = result.get(0);
                block0: for (KeyValueColumnExpression kvExp : arrayKVRefs2) {
                    if (!kvExp.evaluate(tuple, ptr)) continue;
                    ListIterator<Cell> itr = result.listIterator();
                    while (itr.hasNext()) {
                        Cell kv = itr.next();
                        if (!Bytes.equals((byte[])kvExp.getColumnFamily(), (int)0, (int)kvExp.getColumnFamily().length, (byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()) || !Bytes.equals((byte[])kvExp.getColumnQualifier(), (int)0, (int)kvExp.getColumnQualifier().length, (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength())) continue;
                        itr.remove();
                        continue block0;
                    }
                }
                byte[] value = kvSchema.toBytes(tuple, arrayFuncRefs2, kvSchemaBitSet, ptr);
                result.add((Cell)new KeyValue(rowKv.getRowArray(), rowKv.getRowOffset(), (int)rowKv.getRowLength(), QueryConstants.ARRAY_VALUE_COLUMN_FAMILY, 0, QueryConstants.ARRAY_VALUE_COLUMN_FAMILY.length, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER, 0, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER.length, Long.MAX_VALUE, KeyValue.Type.codeToType((byte)rowKv.getTypeByte()), value, 0, value.length));
                return RegionScannerFactory.getArrayCellPosition(result);
            }

            public long getMaxResultSize() {
                return this.s.getMaxResultSize();
            }

            public int getBatch() {
                return this.s.getBatch();
            }
        };
    }

    public static int getArrayCellPosition(List<Cell> result) {
        return result.size() - 1;
    }
}

