/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.ConnectionlessQueryServicesImpl;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalNotification;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.util.SQLCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhoenixDriver
extends PhoenixEmbeddedDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixDriver.class);
    public static final PhoenixDriver INSTANCE;
    private static volatile String driverShutdownMsg;
    private final Cache<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices> connectionQueryServicesCache = this.initializeConnectionCache();
    private volatile QueryServices services;
    @GuardedBy(value="closeLock")
    private volatile boolean closed = false;
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();

    private static void closeInstance(PhoenixDriver instance) {
        try {
            instance.close();
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to close PhoenixDriver on shutdown", (Throwable)e);
        }
        finally {
            driverShutdownMsg = "Phoenix driver closed because server is shutting down";
        }
    }

    private Cache<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices> initializeConnectionCache() {
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        int maxCacheDuration = config.getInt("phoenix.client.connection.max.duration", 86400000);
        RemovalListener<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices> cacheRemovalListener = new RemovalListener<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices>(){

            public void onRemoval(RemovalNotification<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices> notification) {
                String connInfoIdentifier = ((PhoenixEmbeddedDriver.ConnectionInfo)notification.getKey()).toString();
                LOGGER.debug("Expiring " + connInfoIdentifier + " because of " + notification.getCause().name());
                try {
                    ((ConnectionQueryServices)notification.getValue()).close();
                }
                catch (SQLException se) {
                    LOGGER.error("Error while closing expired cache connection " + connInfoIdentifier, (Throwable)se);
                }
            }
        };
        return CacheBuilder.newBuilder().expireAfterAccess((long)maxCacheDuration, TimeUnit.MILLISECONDS).removalListener((RemovalListener)cacheRemovalListener).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryServices getQueryServices() throws SQLException {
        try {
            SQLCloseable sQLCloseable;
            this.lockInterruptibly(LockMode.READ);
            this.checkClosed();
            QueryServices result = this.services;
            if (result == null) {
                sQLCloseable = this;
                synchronized (sQLCloseable) {
                    result = this.services;
                    if (result == null) {
                        this.services = result = new QueryServicesImpl(this.getDefaultProps());
                    }
                }
            }
            sQLCloseable = result;
            return sQLCloseable;
        }
        finally {
            this.unlock(LockMode.READ);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return super.acceptsURL(url) && !PhoenixDriver.isTestUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            this.lockInterruptibly(LockMode.READ);
            this.checkClosed();
            Connection connection = this.createConnection(url, info);
            return connection;
        }
        finally {
            this.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConnectionQueryServices getConnectionQueryServices(String url, final Properties info) throws SQLException {
        try {
            ConnectionQueryServices connectionQueryServices;
            block11: {
                this.lockInterruptibly(LockMode.READ);
                this.checkClosed();
                PhoenixEmbeddedDriver.ConnectionInfo connInfo = PhoenixEmbeddedDriver.ConnectionInfo.create(url);
                SQLException sqlE = null;
                boolean success = false;
                final QueryServices services = this.getQueryServices();
                connectionQueryServices = null;
                final PhoenixEmbeddedDriver.ConnectionInfo normalizedConnInfo = connInfo.normalize(services.getProps(), info);
                try {
                    connectionQueryServices = (ConnectionQueryServices)this.connectionQueryServicesCache.get((Object)normalizedConnInfo, (Callable)new Callable<ConnectionQueryServices>(){

                        @Override
                        public ConnectionQueryServices call() throws Exception {
                            DelegateQueryServices connectionQueryServices = normalizedConnInfo.isConnectionless() ? new ConnectionlessQueryServicesImpl(services, normalizedConnInfo, info) : new ConnectionQueryServicesImpl(services, normalizedConnInfo, info);
                            return connectionQueryServices;
                        }
                    });
                    connectionQueryServices.init(url, info);
                    success = true;
                }
                catch (ExecutionException ee) {
                    if (ee.getCause() instanceof SQLException) {
                        sqlE = (SQLException)ee.getCause();
                    }
                    throw new SQLException(ee);
                }
                catch (SQLException e) {
                    sqlE = e;
                    return sqlE;
                }
                finally {
                    if (success) break block11;
                    this.connectionQueryServicesCache.invalidate((Object)normalizedConnInfo);
                    if (sqlE == null) break block11;
                    throw sqlE;
                }
            }
            ConnectionQueryServices connectionQueryServices2 = connectionQueryServices;
            return connectionQueryServices2;
        }
        finally {
            this.unlock(LockMode.READ);
        }
    }

    @GuardedBy(value="closeLock")
    private void checkClosed() {
        if (this.closed) {
            this.throwDriverClosedException();
        }
    }

    private void throwDriverClosedException() {
        throw new IllegalStateException(driverShutdownMsg != null ? driverShutdownMsg : "The Phoenix jdbc driver has been closed.");
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.lockInterruptibly(LockMode.WRITE);
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.unlock(LockMode.WRITE);
        }
        if (this.services != null) {
            try {
                this.services.close();
            }
            finally {
                this.services = null;
            }
        }
    }

    private void lockInterruptibly(LockMode mode) throws SQLException {
        Preconditions.checkNotNull((Object)((Object)mode));
        switch (mode) {
            case READ: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
            }
            case WRITE: {
                try {
                    this.closeLock.writeLock().lockInterruptibly();
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
            }
        }
    }

    private void unlock(LockMode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        switch (mode) {
            case READ: {
                this.closeLock.readLock().unlock();
                break;
            }
            case WRITE: {
                this.closeLock.writeLock().unlock();
            }
        }
    }

    static {
        try {
            INSTANCE = new PhoenixDriver();
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
                        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("PHOENIX-DRIVER-SHUTDOWNHOOK-thread-%s").build();
                        ExecutorService svc = Executors.newSingleThreadExecutor(threadFactory);
                        try {
                            Future<?> future = svc.submit(new Runnable(){

                                @Override
                                public void run() {
                                    PhoenixDriver.closeInstance(INSTANCE);
                                }
                            });
                            long millisBeforeShutdown = config.getLong("phoenix.shutdown.timeoutMs", 5000L);
                            future.get(millisBeforeShutdown, TimeUnit.MILLISECONDS);
                        }
                        catch (ExecutionException e) {
                            LOGGER.warn("Failed to close instance", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            LOGGER.warn("Interrupted waiting to close instance", (Throwable)e);
                        }
                        catch (TimeoutException e) {
                            LOGGER.warn("Timed out waiting to close instance", (Throwable)e);
                        }
                        finally {
                            svc.shutdownNow();
                        }
                    }
                });
                DriverManager.registerDriver(INSTANCE);
            }
            catch (IllegalStateException e) {
                LOGGER.warn("Failed to register PhoenixDriver shutdown hook as the JVM is already shutting down");
                PhoenixDriver.closeInstance(INSTANCE);
                throw e;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to register " + PhoenixDriver.class.getName() + ": " + e.getMessage());
        }
    }

    private static enum LockMode {
        READ,
        WRITE;

    }
}

