/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.IndexUtil;

public class IndexExpressionParseNodeRewriter
extends ParseNodeRewriter {
    private final Map<ParseNode, ParseNode> indexedParseNodeToColumnParseNodeMap;

    public IndexExpressionParseNodeRewriter(PTable index, String alias, PhoenixConnection connection, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
        this.indexedParseNodeToColumnParseNodeMap = Maps.newHashMapWithExpectedSize((int)index.getColumns().size());
        NamedTableNode tableNode = NamedTableNode.create(alias, TableName.create(index.getParentSchemaName().getString(), index.getParentTableName().getString()), Collections.emptyList());
        ColumnResolver dataResolver = FromCompiler.getResolver(tableNode, connection, udfParseNodes);
        StatementContext context = new StatementContext(new PhoenixStatement(connection), dataResolver);
        IndexStatementRewriter rewriter = new IndexStatementRewriter(dataResolver, null, true);
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
        int indexPosOffset = (index.getBucketNum() == null ? 0 : 1) + (index.isMultiTenant() ? 1 : 0) + (index.getViewIndexId() == null ? 0 : 1);
        List<PColumn> pkColumns = index.getPKColumns();
        for (int i = indexPosOffset; i < pkColumns.size(); ++i) {
            PColumn column = pkColumns.get(i);
            String expressionStr = IndexUtil.getIndexColumnExpressionStr(column);
            ParseNode expressionParseNode = SQLParser.parseCondition(expressionStr);
            String colName = "\"" + column.getName().getString() + "\"";
            Expression dataExpression = expressionParseNode.accept(expressionCompiler);
            PDataType expressionDataType = dataExpression.getDataType();
            ParseNode indexedParseNode = expressionParseNode.accept(rewriter);
            PDataType indexColType = IndexUtil.getIndexColumnDataType(dataExpression.isNullable(), expressionDataType);
            ParseNode columnParseNode = new ColumnParseNode(alias != null ? TableName.create(null, alias) : null, colName, null);
            if (indexColType != expressionDataType) {
                columnParseNode = NODE_FACTORY.cast(columnParseNode, expressionDataType, null, null);
            }
            this.indexedParseNodeToColumnParseNodeMap.put(indexedParseNode, columnParseNode);
        }
    }

    @Override
    protected ParseNode leaveCompoundNode(CompoundParseNode node, List<ParseNode> children, ParseNodeRewriter.CompoundNodeFactory factory) {
        return this.indexedParseNodeToColumnParseNodeMap.containsKey(node) ? this.indexedParseNodeToColumnParseNodeMap.get(node) : super.leaveCompoundNode(node, children, factory);
    }
}

