/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.PhoenixRowTimestampFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixRowTimestampParseNode
extends FunctionParseNode {
    PhoenixRowTimestampParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public FunctionExpression create(List<Expression> children, StatementContext context) throws SQLException {
        if (children.size() != 0) {
            throw new IllegalArgumentException("PhoenixRowTimestampFunction does not take any parameters");
        }
        PTable table = context.getCurrentTable().getTable();
        byte[] emptyColumnFamilyName = SchemaUtil.getEmptyColumnFamily(table);
        byte[] emptyColumnName = table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : table.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
        KeyValueColumnExpression emptyColumnExpression = new KeyValueColumnExpression(new PDatum(){

            @Override
            public boolean isNullable() {
                return false;
            }

            @Override
            public PDataType getDataType() {
                return PDate.INSTANCE;
            }

            @Override
            public Integer getMaxLength() {
                return null;
            }

            @Override
            public Integer getScale() {
                return null;
            }

            @Override
            public SortOrder getSortOrder() {
                return SortOrder.getDefault();
            }
        }, emptyColumnFamilyName, emptyColumnName);
        List<Expression> expressionList = Arrays.asList(emptyColumnExpression);
        context.getScan().setAttribute("_EmptyCFName", emptyColumnFamilyName);
        context.getScan().setAttribute("_EmptyCQName", emptyColumnName);
        return new PhoenixRowTimestampFunction(expressionList);
    }
}

