/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ToDateFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;

public class ToDateParseNode
extends FunctionParseNode {
    public ToDateParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public FunctionExpression create(List<Expression> children, StatementContext context) throws SQLException {
        String dateFormat = (String)((LiteralExpression)children.get(1)).getValue();
        String timeZoneId = (String)((LiteralExpression)children.get(2)).getValue();
        if (dateFormat == null) {
            dateFormat = context.getDateFormat();
        }
        if (timeZoneId == null) {
            timeZoneId = context.getDateFormatTimeZone().getID();
        }
        return new ToDateFunction(children, dateFormat, timeZoneId);
    }
}

