/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.text.Format;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataTypeEncoder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.base.Objects;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public abstract class PArrayDataType<T>
extends PDataType<T> {
    public static final byte SORTABLE_SERIALIZATION_VERSION = 1;
    @Deprecated
    public static final byte IMMUTABLE_SERIALIZATION_VERSION = 2;
    public static final byte IMMUTABLE_SERIALIZATION_V2 = 3;

    @Override
    public final int getResultSetSqlType() {
        return 2003;
    }

    @Override
    public final void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier, boolean expectedRowKeyOrderOptimizable) {
        this.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier, expectedRowKeyOrderOptimizable);
    }

    @Override
    public final void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
        this.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier, true);
    }

    protected PArrayDataType(String sqlTypeName, int sqlType, Class clazz, PDataType.PDataCodec codec, int ordinal) {
        super(sqlTypeName, sqlType, clazz, codec, ordinal);
    }

    public static byte getSeparatorByte(boolean rowKeyOrderOptimizable, SortOrder sortOrder) {
        return SchemaUtil.getSeparatorByte(rowKeyOrderOptimizable, false, sortOrder);
    }

    public byte[] toBytes(Object object, PDataType baseType, SortOrder sortOrder) {
        return this.toBytes(object, baseType, sortOrder, true);
    }

    PhoenixArray toPhoenixArray(Object object, PDataType baseType) {
        if (object instanceof PhoenixArray) {
            return (PhoenixArray)object;
        }
        if (!(object instanceof java.sql.Array)) {
            throw new IllegalArgumentException("Expected an Array but got " + object.getClass());
        }
        java.sql.Array arr = (java.sql.Array)object;
        try {
            Object untypedArrayData = arr.getArray();
            if (!(untypedArrayData instanceof Object[])) {
                throw new IllegalArgumentException("Array data is required to be Object[] but data for " + arr.getClass() + " is " + untypedArrayData.getClass());
            }
            return this.getArrayFactory().newArray(baseType, (Object[])untypedArrayData);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Could not convert Array data", e);
        }
    }

    public byte[] toBytes(Object object, PDataType baseType, SortOrder sortOrder, boolean rowKeyOrderOptimizable) {
        if (object == null) {
            throw new ConstraintViolationException(this + " may not be null");
        }
        PhoenixArray arr = this.toPhoenixArray(object, baseType);
        int noOfElements = arr.numElements;
        if (noOfElements == 0) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        TrustedByteArrayOutputStream byteStream = null;
        if (!baseType.isFixedWidth()) {
            Pair nullsVsNullRepeationCounter = new Pair();
            int size = this.estimateByteSize(object, (Pair<Integer, Integer>)nullsVsNullRepeationCounter, PDataType.fromTypeId(baseType.getSqlType() + 3000));
            int capacity = noOfElements * 2;
            byteStream = new TrustedByteArrayOutputStream((size += 2 + (noOfElements - (Integer)nullsVsNullRepeationCounter.getFirst()) * 1 + (Integer)nullsVsNullRepeationCounter.getSecond() * 2 * 1) + capacity + 4 + 1 + 4);
        } else {
            int elemLength = arr.getMaxLength() == null ? baseType.getByteSize() : arr.getMaxLength();
            int size = elemLength * noOfElements;
            byteStream = new TrustedByteArrayOutputStream(size);
        }
        DataOutputStream oStream = new DataOutputStream(byteStream);
        return this.createArrayBytes(byteStream, oStream, arr, noOfElements, baseType, sortOrder, rowKeyOrderOptimizable);
    }

    public static int serializeNulls(DataOutputStream oStream, int nulls) throws IOException {
        if (nulls > 0) {
            oStream.write(0);
            int nMultiplesOver255 = nulls / 255;
            while (nMultiplesOver255-- > 0) {
                oStream.write(1);
            }
            int nRemainingNulls = nulls % 255;
            if (nRemainingNulls > 0) {
                byte nNullByte = SortOrder.invert((byte)(nRemainingNulls - 1));
                oStream.write(nNullByte);
            }
        }
        return 0;
    }

    public static int serializeNulls(byte[] bytes, int position, int nulls) {
        int nMultiplesOver255 = nulls / 255;
        while (nMultiplesOver255-- > 0) {
            bytes[position++] = 1;
        }
        int nRemainingNulls = nulls % 255;
        if (nRemainingNulls > 0) {
            byte nNullByte = SortOrder.invert((byte)(nRemainingNulls - 1));
            bytes[position++] = nNullByte;
        }
        return position;
    }

    public static void writeEndSeperatorForVarLengthArray(DataOutputStream oStream, SortOrder sortOrder) throws IOException {
        PArrayDataType.writeEndSeperatorForVarLengthArray(oStream, sortOrder, true);
    }

    public static void writeEndSeperatorForVarLengthArray(DataOutputStream oStream, SortOrder sortOrder, boolean rowKeyOrderOptimizable) throws IOException {
        byte sepByte = PArrayDataType.getSeparatorByte(rowKeyOrderOptimizable, sortOrder);
        oStream.write(sepByte);
        oStream.write(sepByte);
    }

    public static boolean useShortForOffsetArray(int maxoffset) {
        return PArrayDataType.useShortForOffsetArray(maxoffset, (byte)1);
    }

    public static boolean useShortForOffsetArray(int maxoffset, byte serializationVersion) {
        if (serializationVersion == 2 || serializationVersion == 3) {
            return maxoffset <= Short.MAX_VALUE && maxoffset >= Short.MIN_VALUE;
        }
        return maxoffset <= 65534;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        PhoenixArray array = (PhoenixArray)object;
        if (array == null || array.baseType == null) {
            return 0;
        }
        return this.estimateByteSize(object, null, PDataType.fromTypeId(array.baseType.getSqlType() + 3000));
    }

    public int estimateByteSize(Object o, Pair<Integer, Integer> nullsVsNullRepeationCounter, PDataType baseType) {
        if (baseType.isFixedWidth()) {
            return baseType.getByteSize();
        }
        if (baseType.isArrayType()) {
            PhoenixArray array = (PhoenixArray)o;
            int noOfElements = array.numElements;
            int totalVarSize = 0;
            int nullsRepeationCounter = 0;
            int nulls = 0;
            int totalNulls = 0;
            for (int i = 0; i < noOfElements; ++i) {
                totalVarSize += array.estimateByteSize(i);
                if (PDataType.fromTypeId(baseType.getSqlType() - 3000).isFixedWidth()) continue;
                if (array.isNull(i)) {
                    ++nulls;
                    continue;
                }
                if (nulls <= 0) continue;
                totalNulls += nulls;
                nulls = 0;
                ++nullsRepeationCounter;
            }
            if (nullsVsNullRepeationCounter != null) {
                if (nulls > 0) {
                    totalNulls += nulls;
                }
                nullsVsNullRepeationCounter.setFirst((Object)totalNulls);
                nullsVsNullRepeationCounter.setSecond((Object)nullsRepeationCounter);
            }
            return totalVarSize;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return targetType.isCoercibleTo(targetType, value);
    }

    public boolean isCoercibleTo(PDataType targetType, PDataType expectedTargetType) {
        if (!targetType.isArrayType()) {
            return false;
        }
        PDataType targetElementType = PDataType.fromTypeId(targetType.getSqlType() - 3000);
        PDataType expectedTargetElementType = PDataType.fromTypeId(expectedTargetType.getSqlType() - 3000);
        return expectedTargetElementType.isCoercibleTo(targetElementType);
    }

    @Override
    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, SortOrder sortOrder, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        if (value == null) {
            return true;
        }
        PhoenixArray pArr = (PhoenixArray)value;
        PDataType baseType = PDataType.fromTypeId(srcType.getSqlType() - 3000);
        ImmutableBytesWritable elementPtr = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
        for (int i = 0; i < pArr.numElements; ++i) {
            Object val = pArr.getElement(i);
            if (baseType.isSizeCompatible(elementPtr, val, baseType, sortOrder, srcType.getMaxLength(val), scale, desiredMaxLength, desiredScale)) continue;
            return false;
        }
        return true;
    }

    @SuppressWarnings(value={"RC_REF_COMPARISON"}, justification="PDataTypes are expected to be singletons")
    private void coerceBytes(ImmutableBytesWritable ptr, Object value, PDataType actualType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale, PDataType desiredType, SortOrder actualSortOrder, SortOrder desiredSortOrder, boolean expectedRowKeyOrderOptimizable) {
        PhoenixArray pArr;
        if (ptr.getLength() == 0) {
            return;
        }
        PDataType baseType = PDataType.fromTypeId(actualType.getSqlType() - 3000);
        PDataType desiredBaseType = PDataType.fromTypeId(desiredType.getSqlType() - 3000);
        if ((Objects.equal((Object)maxLength, (Object)desiredMaxLength) || maxLength == null || desiredMaxLength == null) && actualType.isBytesComparableWith(desiredType) && baseType.isFixedWidth() == desiredBaseType.isFixedWidth() && actualSortOrder == desiredSortOrder && (desiredSortOrder == SortOrder.ASC || desiredBaseType.isFixedWidth() || PArrayDataType.isRowKeyOrderOptimized(actualType, actualSortOrder, ptr) == expectedRowKeyOrderOptimizable)) {
            return;
        }
        if (value == null || actualType != desiredType) {
            value = this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), baseType, actualSortOrder, maxLength, desiredScale, desiredBaseType);
            pArr = (PhoenixArray)value;
            if (baseType.isFixedWidth() != desiredBaseType.isFixedWidth() && !pArr.isPrimitiveType()) {
                pArr = new PhoenixArray(pArr, desiredMaxLength);
            }
            if (actualType == desiredType && !pArr.isPrimitiveType() && maxLength != null && maxLength != desiredMaxLength) {
                pArr = new PhoenixArray(pArr, desiredMaxLength);
            }
            baseType = desiredBaseType;
        } else {
            pArr = (PhoenixArray)value;
            if (!Objects.equal((Object)maxLength, (Object)desiredMaxLength)) {
                pArr = new PhoenixArray(pArr, desiredMaxLength);
            }
        }
        ptr.set(this.toBytes(pArr, baseType, desiredSortOrder, expectedRowKeyOrderOptimizable));
    }

    public static boolean isRowKeyOrderOptimized(PDataType type, SortOrder sortOrder, ImmutableBytesWritable ptr) {
        return PArrayDataType.isRowKeyOrderOptimized(type, sortOrder, ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public static boolean isRowKeyOrderOptimized(PDataType type, SortOrder sortOrder, byte[] buf, int offset, int length) {
        PDataType baseType = PDataType.fromTypeId(type.getSqlType() - 3000);
        return PArrayDataType.isRowKeyOrderOptimized(baseType.isFixedWidth(), sortOrder, buf, offset, length);
    }

    private static boolean isRowKeyOrderOptimized(boolean isFixedWidth, SortOrder sortOrder, byte[] buf, int offset, int length) {
        if (length == 0 || sortOrder == SortOrder.ASC || isFixedWidth) {
            return true;
        }
        int offsetToHeaderOffset = offset + length - 1 - 8;
        int offsetToSeparatorByte = Bytes.readAsInt((byte[])buf, (int)offsetToHeaderOffset, (int)4) - 1;
        return buf[offsetToSeparatorByte] == QueryConstants.DESC_SEPARATOR_BYTE;
    }

    @Override
    public Object toObject(String value) {
        throw new IllegalArgumentException("This operation is not suppported");
    }

    public Object toObject(byte[] bytes, int offset, int length, PDataType baseType, SortOrder sortOrder, Integer maxLength, Integer scale, PDataType desiredDataType) {
        return this.createPhoenixArray(bytes, offset, length, sortOrder, baseType, maxLength, desiredDataType);
    }

    static int getOffset(byte[] bytes, int arrayIndex, boolean useShort, int indexOffset, byte serializationVersion) {
        return Math.abs(PArrayDataType.getSerializedOffset(bytes, arrayIndex, useShort, indexOffset, serializationVersion));
    }

    static int getSerializedOffset(byte[] bytes, int arrayIndex, boolean useShort, int indexOffset, byte serializationVersion) {
        if (useShort) {
            int offset = indexOffset + 2 * arrayIndex;
            return Bytes.toShort((byte[])bytes, (int)offset, (int)2) + (serializationVersion == 2 || serializationVersion == 3 ? 0 : Short.MAX_VALUE);
        }
        int offset = indexOffset + 4 * arrayIndex;
        return Bytes.toInt((byte[])bytes, (int)offset, (int)4);
    }

    private static int getOffset(ByteBuffer indexBuffer, int arrayIndex, boolean useShort, int indexOffset) {
        int offset = useShort ? indexBuffer.getShort() + Short.MAX_VALUE : indexBuffer.getInt();
        return offset;
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        return this.toPhoenixArray(object, PArrayDataType.arrayBaseType(actualType));
    }

    public Object toObject(Object object, PDataType actualType, SortOrder sortOrder) {
        return this.toObject(object, actualType);
    }

    private byte[] createArrayBytes(TrustedByteArrayOutputStream byteStream, DataOutputStream oStream, PhoenixArray array, int noOfElements, PDataType baseType, SortOrder sortOrder, boolean rowKeyOrderOptimizable) {
        PArrayDataTypeEncoder builder = new PArrayDataTypeEncoder(byteStream, oStream, noOfElements, baseType, sortOrder, rowKeyOrderOptimizable);
        for (int i = 0; i < noOfElements; ++i) {
            byte[] bytes = array.toBytes(i);
            builder.appendValue(bytes);
        }
        return builder.encode();
    }

    private static byte[] generateEmptyArrayBytes(PDataType baseType, SortOrder sortOrder) {
        PArrayDataTypeEncoder encoder = new PArrayDataTypeEncoder(baseType, sortOrder);
        byte[] arrayBytes = encoder.encode();
        if (arrayBytes == null) {
            arrayBytes = ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return arrayBytes;
    }

    public static boolean appendItemToArray(ImmutableBytesWritable ptr, int length, int offset, byte[] arrayBytes, PDataType baseType, int arrayLength, Integer maxLength, SortOrder sortOrder) {
        byte[] newArray;
        int elementLength;
        if (ptr.getLength() == 0) {
            ptr.set(arrayBytes, offset, length);
            return true;
        }
        if (arrayBytes.length == 0) {
            arrayBytes = PArrayDataType.generateEmptyArrayBytes(baseType, sortOrder);
            offset = 0;
            length = arrayBytes.length;
        }
        int n = elementLength = maxLength == null ? ptr.getLength() : maxLength.intValue();
        if (elementLength > ptr.getLength()) {
            baseType.pad(ptr, (Integer)elementLength, sortOrder);
        }
        int elementOffset = ptr.getOffset();
        byte[] elementBytes = ptr.get();
        if (!baseType.isFixedWidth()) {
            byte sepByte;
            byte serializationVersion = arrayBytes[offset + length - 1];
            int offsetArrayPosition = Bytes.toInt((byte[])arrayBytes, (int)(offset + length - 4 - 4 - 1), (int)4);
            int offsetArrayLength = length - offsetArrayPosition - 4 - 4 - 1;
            boolean useInt = arrayLength == 0 ? false : offsetArrayLength / Math.abs(arrayLength) == 4;
            boolean convertToInt = false;
            int newElementPosition = offsetArrayPosition - 2;
            if (!useInt) {
                if (PArrayDataType.useShortForOffsetArray(newElementPosition)) {
                    newArray = new byte[length + elementLength + 2 + 1];
                } else {
                    newArray = new byte[length + elementLength + arrayLength * 2 + 4 + 1];
                    convertToInt = true;
                }
            } else {
                newArray = new byte[length + elementLength + 4 + 1];
            }
            int newOffsetArrayPosition = newElementPosition + elementLength + 3;
            System.arraycopy(arrayBytes, offset, newArray, 0, newElementPosition);
            newArray[newOffsetArrayPosition - 3] = sepByte = PArrayDataType.getSeparatorByte(PArrayDataType.isRowKeyOrderOptimized(false, sortOrder, arrayBytes, offset, length), sortOrder);
            newArray[newOffsetArrayPosition - 2] = sepByte;
            newArray[newOffsetArrayPosition - 1] = sepByte;
            System.arraycopy(elementBytes, elementOffset, newArray, newElementPosition, elementLength);
            int factor = (int)Math.signum(arrayLength);
            if (factor == 0) {
                factor = 1;
            }
            arrayLength = (Math.abs(arrayLength) + 1) * factor;
            if (useInt) {
                System.arraycopy(arrayBytes, offset + offsetArrayPosition, newArray, newOffsetArrayPosition, offsetArrayLength);
                Bytes.putInt((byte[])newArray, (int)(newOffsetArrayPosition + offsetArrayLength), (int)newElementPosition);
                PArrayDataType.writeEndBytes(newArray, newOffsetArrayPosition, offsetArrayLength, arrayLength, arrayBytes[offset + length - 1], true);
            } else if (!convertToInt) {
                System.arraycopy(arrayBytes, offset + offsetArrayPosition, newArray, newOffsetArrayPosition, offsetArrayLength);
                Bytes.putShort((byte[])newArray, (int)(newOffsetArrayPosition + offsetArrayLength), (short)((short)(newElementPosition - Short.MAX_VALUE)));
                PArrayDataType.writeEndBytes(newArray, newOffsetArrayPosition, offsetArrayLength, arrayLength, arrayBytes[offset + length - 1], false);
            } else {
                int off = newOffsetArrayPosition;
                for (int arrayIndex = 0; arrayIndex < Math.abs(arrayLength) - 1; ++arrayIndex) {
                    Bytes.putInt((byte[])newArray, (int)off, (int)PArrayDataType.getOffset(arrayBytes, arrayIndex, true, offsetArrayPosition + offset, serializationVersion));
                    off += 4;
                }
                Bytes.putInt((byte[])newArray, (int)off, (int)newElementPosition);
                Bytes.putInt((byte[])newArray, (int)(off + 4), (int)newOffsetArrayPosition);
                Bytes.putInt((byte[])newArray, (int)(off + 8), (int)(-arrayLength));
                Bytes.putByte((byte[])newArray, (int)(off + 12), (byte)arrayBytes[offset + length - 1]);
            }
        } else {
            newArray = new byte[length + elementLength];
            System.arraycopy(arrayBytes, offset, newArray, 0, length);
            System.arraycopy(elementBytes, elementOffset, newArray, length, elementLength);
        }
        ptr.set(newArray);
        return true;
    }

    private static void writeEndBytes(byte[] array, int newOffsetArrayPosition, int offsetArrayLength, int arrayLength, byte header, boolean useInt) {
        int byteSize = useInt ? 4 : 2;
        Bytes.putInt((byte[])array, (int)(newOffsetArrayPosition + offsetArrayLength + byteSize), (int)newOffsetArrayPosition);
        Bytes.putInt((byte[])array, (int)(newOffsetArrayPosition + offsetArrayLength + byteSize + 4), (int)arrayLength);
        Bytes.putByte((byte[])array, (int)(newOffsetArrayPosition + offsetArrayLength + byteSize + 8), (byte)header);
    }

    public static boolean prependItemToArray(ImmutableBytesWritable ptr, int length, int offset, byte[] arrayBytes, PDataType baseType, int arrayLength, Integer maxLength, SortOrder sortOrder) {
        byte[] newArray;
        int elementLength;
        int n = elementLength = maxLength == null ? ptr.getLength() : maxLength.intValue();
        if (ptr.getLength() == 0) {
            elementLength = 0;
        }
        if (arrayBytes.length == 0) {
            arrayBytes = PArrayDataType.generateEmptyArrayBytes(baseType, sortOrder);
            offset = 0;
            length = arrayBytes.length;
        }
        if (elementLength > ptr.getLength()) {
            baseType.pad(ptr, (Integer)elementLength, sortOrder);
        }
        int elementOffset = ptr.getOffset();
        byte[] elementBytes = ptr.get();
        if (!baseType.isFixedWidth()) {
            int newOffsetArrayPosition;
            int lengthIncrease;
            byte serializationVersion = arrayBytes[offset + length - 1];
            int offsetArrayPosition = Bytes.toInt((byte[])arrayBytes, (int)(offset + length - 4 - 4 - 1), (int)4);
            int offsetArrayLength = length - offsetArrayPosition - 4 - 4 - 1;
            boolean useInt = (arrayLength = Math.abs(arrayLength)) == 0 ? false : offsetArrayLength / arrayLength == 4;
            boolean convertToInt = false;
            int endElementPosition = PArrayDataType.getOffset(arrayBytes, arrayLength - 1, !useInt, offsetArrayPosition + offset, serializationVersion) + elementLength + 1;
            int firstNonNullElementPosition = 0;
            int currentPosition = 0;
            if (elementLength == 0) {
                int nulls = 1;
                for (int index = 0; index < arrayLength; ++index) {
                    int currOffset = PArrayDataType.getOffset(arrayBytes, index, !useInt, offsetArrayPosition + offset, serializationVersion);
                    if (arrayBytes[offset + currOffset] == 0) {
                        ++nulls;
                        continue;
                    }
                    firstNonNullElementPosition = currOffset;
                    break;
                }
                int nMultiplesOver255 = nulls / 255;
                int nRemainingNulls = nulls % 255;
                lengthIncrease = nRemainingNulls == 1 ? (nMultiplesOver255 == 0 ? 2 : 1) : 0;
                endElementPosition = PArrayDataType.getOffset(arrayBytes, arrayLength - 1, !useInt, offsetArrayPosition + offset, serializationVersion) + lengthIncrease;
                if (!useInt) {
                    if (PArrayDataType.useShortForOffsetArray(endElementPosition)) {
                        newArray = new byte[length + 2 + lengthIncrease];
                    } else {
                        newArray = new byte[length + arrayLength * 2 + 4 + lengthIncrease];
                        convertToInt = true;
                    }
                } else {
                    newArray = new byte[length + 4 + lengthIncrease];
                }
                newArray[currentPosition] = 0;
                ++currentPosition;
                newOffsetArrayPosition = offsetArrayPosition + lengthIncrease;
                currentPosition = PArrayDataType.serializeNulls(newArray, currentPosition, nulls);
            } else {
                if (!useInt) {
                    if (PArrayDataType.useShortForOffsetArray(endElementPosition)) {
                        newArray = new byte[length + elementLength + 2 + 1];
                    } else {
                        newArray = new byte[length + elementLength + arrayLength * 2 + 4 + 1];
                        convertToInt = true;
                    }
                } else {
                    newArray = new byte[length + elementLength + 4 + 1];
                }
                newOffsetArrayPosition = offsetArrayPosition + 1 + elementLength;
                lengthIncrease = elementLength + 1;
                System.arraycopy(elementBytes, elementOffset, newArray, 0, elementLength);
                newArray[elementLength] = PArrayDataType.getSeparatorByte(PArrayDataType.isRowKeyOrderOptimized(false, sortOrder, arrayBytes, offset, length), sortOrder);
                currentPosition += elementLength + 1;
            }
            System.arraycopy(arrayBytes, firstNonNullElementPosition + offset, newArray, currentPosition, offsetArrayPosition);
            ++arrayLength;
            if (useInt || convertToInt) {
                PArrayDataType.writeNewOffsets(arrayBytes, newArray, false, !useInt, newOffsetArrayPosition, arrayLength, offsetArrayPosition, offset, lengthIncrease, length);
            } else {
                PArrayDataType.writeNewOffsets(arrayBytes, newArray, true, true, newOffsetArrayPosition, arrayLength, offsetArrayPosition, offset, lengthIncrease, length);
            }
        } else {
            newArray = new byte[length + elementLength];
            System.arraycopy(elementBytes, elementOffset, newArray, 0, elementLength);
            System.arraycopy(arrayBytes, offset, newArray, elementLength, length);
        }
        ptr.set(newArray);
        return true;
    }

    private static void writeNewOffsets(byte[] arrayBytes, byte[] newArray, boolean useShortNew, boolean useShortPrevious, int newOffsetArrayPosition, int arrayLength, int offsetArrayPosition, int offset, int offsetShift, int length) {
        int offsetArrayElementSize;
        int currentPosition = newOffsetArrayPosition;
        int n = offsetArrayElementSize = useShortNew ? 2 : 4;
        if (useShortNew) {
            Bytes.putShort((byte[])newArray, (int)currentPosition, (short)-32767);
        } else {
            Bytes.putInt((byte[])newArray, (int)currentPosition, (int)0);
        }
        currentPosition += offsetArrayElementSize;
        boolean nullsAtBeginning = true;
        byte serializationVersion = arrayBytes[offset + length - 1];
        for (int arrayIndex = 0; arrayIndex < arrayLength - 1; ++arrayIndex) {
            int oldOffset = PArrayDataType.getOffset(arrayBytes, arrayIndex, useShortPrevious, offsetArrayPosition + offset, serializationVersion);
            if (arrayBytes[offset + oldOffset] == 0 && nullsAtBeginning) {
                if (useShortNew) {
                    Bytes.putShort((byte[])newArray, (int)currentPosition, (short)((short)(oldOffset - Short.MAX_VALUE)));
                } else {
                    Bytes.putInt((byte[])newArray, (int)currentPosition, (int)oldOffset);
                }
            } else {
                if (useShortNew) {
                    Bytes.putShort((byte[])newArray, (int)currentPosition, (short)((short)(oldOffset + offsetShift - Short.MAX_VALUE)));
                } else {
                    Bytes.putInt((byte[])newArray, (int)currentPosition, (int)(oldOffset + offsetShift));
                }
                nullsAtBeginning = false;
            }
            currentPosition += offsetArrayElementSize;
        }
        Bytes.putInt((byte[])newArray, (int)currentPosition, (int)newOffsetArrayPosition);
        Bytes.putInt((byte[])newArray, (int)(currentPosition += 4), (int)(useShortNew ? arrayLength : -arrayLength));
        Bytes.putByte((byte[])newArray, (int)(currentPosition += 4), (byte)arrayBytes[offset + length - 1]);
    }

    public static boolean concatArrays(ImmutableBytesWritable ptr, int array1BytesLength, int array1BytesOffset, byte[] array1Bytes, PDataType baseType, int actualLengthOfArray1, int actualLengthOfArray2) {
        byte[] newArray;
        int array2BytesLength = ptr.getLength();
        int array2BytesOffset = ptr.getOffset();
        byte[] array2Bytes = ptr.get();
        if (!baseType.isFixedWidth()) {
            int offset;
            byte serializationVersion1 = array1Bytes[array1BytesOffset + array1BytesLength - 1];
            int offsetArrayPositionArray1 = Bytes.toInt((byte[])array1Bytes, (int)(array1BytesOffset + array1BytesLength - 4 - 4 - 1), (int)4);
            int offsetArrayPositionArray2 = Bytes.toInt((byte[])array2Bytes, (int)(array2BytesOffset + array2BytesLength - 4 - 4 - 1), (int)4);
            int offsetArrayLengthArray1 = array1BytesLength - offsetArrayPositionArray1 - 4 - 4 - 1;
            int offsetArrayLengthArray2 = array2BytesLength - offsetArrayPositionArray2 - 4 - 4 - 1;
            int newArrayLength = actualLengthOfArray1 + actualLengthOfArray2;
            int nullsAtTheEndOfArray1 = 0;
            int nullsAtTheBeginningOfArray2 = 0;
            boolean useIntArray1 = offsetArrayLengthArray1 / actualLengthOfArray1 == 4;
            boolean useIntArray2 = offsetArrayLengthArray2 / actualLengthOfArray2 == 4;
            boolean useIntNewArray = false;
            for (int index = actualLengthOfArray1 - 1; index > -1 && (array1Bytes[array1BytesOffset + (offset = PArrayDataType.getOffset(array1Bytes, index, !useIntArray1, array1BytesOffset + offsetArrayPositionArray1, serializationVersion1))] == 0 || array1Bytes[array1BytesOffset + offset] == QueryConstants.DESC_SEPARATOR_BYTE); --index) {
                ++nullsAtTheEndOfArray1;
            }
            int array2FirstNonNullElementOffset = 0;
            int array2FirstNonNullIndex = 0;
            byte serializationVersion2 = array2Bytes[array2BytesOffset + array2BytesLength - 1];
            for (int index = 0; index < actualLengthOfArray2; ++index) {
                int offset2 = PArrayDataType.getOffset(array2Bytes, index, !useIntArray2, array2BytesOffset + offsetArrayPositionArray2, serializationVersion2);
                if (array2Bytes[array2BytesOffset + offset2] == 0) {
                    ++nullsAtTheBeginningOfArray2;
                    continue;
                }
                array2FirstNonNullIndex = index;
                array2FirstNonNullElementOffset = offset2;
                break;
            }
            int nullsInMiddleAfterConcat = nullsAtTheEndOfArray1 + nullsAtTheBeginningOfArray2;
            int bytesForNullsBefore = nullsAtTheBeginningOfArray2 / 255 + (nullsAtTheBeginningOfArray2 % 255 == 0 ? 0 : 1);
            int bytesForNullsAfter = nullsInMiddleAfterConcat / 255 + (nullsInMiddleAfterConcat % 255 == 0 ? 0 : 1);
            int lengthIncreaseForNulls = bytesForNullsAfter - bytesForNullsBefore;
            int newOffsetArrayPosition = offsetArrayPositionArray1 + offsetArrayPositionArray2 + (lengthIncreaseForNulls += nullsAtTheBeginningOfArray2 == 0 && nullsAtTheEndOfArray1 != 0 ? 1 : 0) - 2;
            int endElementPositionOfArray2 = PArrayDataType.getOffset(array2Bytes, actualLengthOfArray2 - 1, !useIntArray2, array2BytesOffset + offsetArrayPositionArray2, serializationVersion2);
            int newEndElementPosition = lengthIncreaseForNulls + endElementPositionOfArray2 + offsetArrayPositionArray1 - 2;
            if (PArrayDataType.useShortForOffsetArray(newEndElementPosition)) {
                newArray = new byte[newOffsetArrayPosition + newArrayLength * 2 + 4 + 4 + 1];
            } else {
                useIntNewArray = true;
                newArray = new byte[newOffsetArrayPosition + newArrayLength * 4 + 4 + 4 + 1];
            }
            int currentPosition = 0;
            System.arraycopy(array1Bytes, array1BytesOffset, newArray, currentPosition, offsetArrayPositionArray1 - 2);
            int array2StartingPosition = currentPosition = offsetArrayPositionArray1 - 2;
            currentPosition += nullsInMiddleAfterConcat != 0 ? 1 : 0;
            currentPosition = PArrayDataType.serializeNulls(newArray, currentPosition, nullsInMiddleAfterConcat);
            System.arraycopy(array2Bytes, array2BytesOffset + array2FirstNonNullElementOffset, newArray, currentPosition, offsetArrayPositionArray2 - array2FirstNonNullElementOffset);
            currentPosition += offsetArrayPositionArray2 - array2FirstNonNullElementOffset;
            if (useIntNewArray) {
                int offset3;
                int index;
                for (index = 0; index < actualLengthOfArray1; ++index) {
                    offset3 = PArrayDataType.getOffset(array1Bytes, index, !useIntArray1, array1BytesOffset + offsetArrayPositionArray1, serializationVersion1);
                    Bytes.putInt((byte[])newArray, (int)currentPosition, (int)offset3);
                    currentPosition += 4;
                }
                for (index = 0; index < array2FirstNonNullIndex; ++index) {
                    offset3 = PArrayDataType.getOffset(array2Bytes, index, !useIntArray2, array2BytesOffset + offsetArrayPositionArray2, serializationVersion2);
                    Bytes.putInt((byte[])newArray, (int)currentPosition, (int)(offset3 + array2StartingPosition));
                    currentPosition += 4;
                }
                int part2NonNullStartingPosition = array2StartingPosition + bytesForNullsAfter + (bytesForNullsAfter == 0 ? 0 : 1);
                for (int index2 = array2FirstNonNullIndex; index2 < actualLengthOfArray2; ++index2) {
                    int offset4 = PArrayDataType.getOffset(array2Bytes, index2, !useIntArray2, array2BytesOffset + offsetArrayPositionArray2, serializationVersion2);
                    Bytes.putInt((byte[])newArray, (int)currentPosition, (int)(offset4 - array2FirstNonNullElementOffset + part2NonNullStartingPosition));
                    currentPosition += 4;
                }
            } else {
                int offset5;
                int index;
                for (index = 0; index < actualLengthOfArray1; ++index) {
                    offset5 = PArrayDataType.getOffset(array1Bytes, index, !useIntArray1, array1BytesOffset + offsetArrayPositionArray1, serializationVersion1);
                    Bytes.putShort((byte[])newArray, (int)currentPosition, (short)((short)(offset5 - Short.MAX_VALUE)));
                    currentPosition += 2;
                }
                for (index = 0; index < array2FirstNonNullIndex; ++index) {
                    offset5 = PArrayDataType.getOffset(array2Bytes, index, !useIntArray2, array2BytesOffset + offsetArrayPositionArray2, serializationVersion2);
                    Bytes.putShort((byte[])newArray, (int)currentPosition, (short)((short)(offset5 + array2StartingPosition - Short.MAX_VALUE)));
                    currentPosition += 2;
                }
                int part2NonNullStartingPosition = array2StartingPosition + bytesForNullsAfter + (bytesForNullsAfter == 0 ? 0 : 1);
                for (int index3 = array2FirstNonNullIndex; index3 < actualLengthOfArray2; ++index3) {
                    int offset6 = PArrayDataType.getOffset(array2Bytes, index3, !useIntArray2, array2BytesOffset + offsetArrayPositionArray2, serializationVersion2);
                    Bytes.putShort((byte[])newArray, (int)currentPosition, (short)((short)(offset6 - array2FirstNonNullElementOffset + part2NonNullStartingPosition - Short.MAX_VALUE)));
                    currentPosition += 2;
                }
            }
            Bytes.putInt((byte[])newArray, (int)currentPosition, (int)newOffsetArrayPosition);
            Bytes.putInt((byte[])newArray, (int)(currentPosition += 4), (int)(useIntNewArray ? -newArrayLength : newArrayLength));
            Bytes.putByte((byte[])newArray, (int)(currentPosition += 4), (byte)array1Bytes[array1BytesOffset + array1BytesLength - 1]);
        } else {
            newArray = new byte[array1BytesLength + array2BytesLength];
            System.arraycopy(array1Bytes, array1BytesOffset, newArray, 0, array1BytesLength);
            System.arraycopy(array2Bytes, array2BytesOffset, newArray, array1BytesLength, array2BytesLength);
        }
        ptr.set(newArray);
        return true;
    }

    public static boolean arrayToString(ImmutableBytesWritable ptr, PhoenixArray array, String delimiter, String nullString, SortOrder sortOrder) {
        StringBuilder result = new StringBuilder();
        boolean delimiterPending = false;
        for (int i = 0; i < array.getDimensions() - 1; ++i) {
            Object element = array.getElement(i);
            if (element == null) {
                if (nullString != null) {
                    result.append(nullString);
                }
            } else {
                result.append(element.toString());
                delimiterPending = true;
            }
            if (nullString == null && (array.getElement(i + 1) == null || !delimiterPending)) continue;
            result.append(delimiter);
            delimiterPending = false;
        }
        Object element = array.getElement(array.getDimensions() - 1);
        if (element == null) {
            if (nullString != null) {
                result.append(nullString);
            }
        } else {
            result.append(element.toString());
        }
        ptr.set(PVarchar.INSTANCE.toBytes(result.toString(), sortOrder));
        return true;
    }

    public static boolean stringToArray(ImmutableBytesWritable ptr, String string, String delimiter, String nullString, SortOrder sortOrder) {
        Object[] array;
        Pattern pattern = Pattern.compile(Pattern.quote(delimiter));
        if (delimiter.length() != 0) {
            array = pattern.split(string);
            if (nullString != null) {
                for (int i = 0; i < array.length; ++i) {
                    if (!((String)array[i]).equals(nullString)) continue;
                    array[i] = null;
                }
            }
        } else {
            array = string.split("(?!^)");
        }
        PhoenixArray phoenixArray = new PhoenixArray(PVarchar.INSTANCE, array);
        ptr.set(PVarcharArray.INSTANCE.toBytes((Object)phoenixArray, PVarchar.INSTANCE, sortOrder));
        return true;
    }

    public static int serializeOffsetArrayIntoStream(DataOutputStream oStream, TrustedByteArrayOutputStream byteStream, int noOfElements, int maxOffset, int[] offsetPos, byte serializationVersion) throws IOException {
        int offsetPosition = byteStream.size();
        byte[] offsetArr = null;
        boolean useInt = true;
        if (PArrayDataType.useShortForOffsetArray(maxOffset, serializationVersion)) {
            offsetArr = new byte[PArrayDataType.initOffsetArray(noOfElements, 2)];
            useInt = false;
        } else {
            offsetArr = new byte[PArrayDataType.initOffsetArray(noOfElements, 4)];
            noOfElements = -noOfElements;
        }
        int off = 0;
        if (useInt) {
            for (int pos : offsetPos) {
                Bytes.putInt((byte[])offsetArr, (int)off, (int)pos);
                off += 4;
            }
        } else {
            for (int pos : offsetPos) {
                short val = serializationVersion == 2 || serializationVersion == 3 ? (short)pos : (short)(pos - Short.MAX_VALUE);
                Bytes.putShort((byte[])offsetArr, (int)off, (short)val);
                off += 2;
            }
        }
        oStream.write(offsetArr);
        oStream.writeInt(offsetPosition);
        return noOfElements;
    }

    public static void serializeHeaderInfoIntoStream(DataOutputStream oStream, int noOfElements, byte serializationVersion) throws IOException {
        oStream.writeInt(noOfElements);
        oStream.write(serializationVersion);
    }

    public static int initOffsetArray(int noOfElements, int baseSize) {
        return noOfElements * baseSize;
    }

    private Object createPhoenixArray(byte[] bytes, int offset, int length, SortOrder sortOrder, PDataType baseDataType, Integer maxLength, PDataType desiredDataType) {
        Object[] elements;
        if (bytes == null || length == 0) {
            return null;
        }
        if (!baseDataType.isFixedWidth()) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes, offset, length);
            int initPos = buffer.position();
            buffer.position(buffer.limit() - 5);
            int noOfElements = buffer.getInt();
            boolean useShort = true;
            int baseSize = 2;
            if (noOfElements < 0) {
                noOfElements = -noOfElements;
                baseSize = 4;
                useShort = false;
            }
            elements = baseDataType == desiredDataType ? (Object[])Array.newInstance(baseDataType.getJavaClass(), noOfElements) : (Object[])Array.newInstance(desiredDataType.getJavaClass(), noOfElements);
            buffer.position(buffer.limit() - 9);
            int indexOffset = buffer.getInt();
            buffer.position(initPos);
            buffer.position(indexOffset + initPos);
            ByteBuffer indexArr = ByteBuffer.allocate(PArrayDataType.initOffsetArray(noOfElements, baseSize));
            byte[] array = indexArr.array();
            buffer.get(array);
            int countOfElementsRead = 0;
            int i = 0;
            int currOffset = -1;
            int nextOff = -1;
            boolean foundNull = false;
            if (noOfElements != 0) {
                while (countOfElementsRead <= noOfElements) {
                    if (countOfElementsRead == 0) {
                        currOffset = PArrayDataType.getOffset(indexArr, countOfElementsRead, useShort, indexOffset);
                        ++countOfElementsRead;
                    } else {
                        currOffset = nextOff;
                    }
                    nextOff = countOfElementsRead == noOfElements ? indexOffset - 2 : PArrayDataType.getOffset(indexArr, countOfElementsRead + 1, useShort, indexOffset);
                    ++countOfElementsRead;
                    if (bytes[currOffset + initPos] != 0 && bytes[currOffset + initPos] != QueryConstants.DESC_SEPARATOR_BYTE && foundNull) {
                        foundNull = false;
                    }
                    if (bytes[currOffset + initPos] == 0 || bytes[currOffset + initPos] == QueryConstants.DESC_SEPARATOR_BYTE) {
                        foundNull = true;
                        ++i;
                        continue;
                    }
                    int elementLength = nextOff - currOffset;
                    buffer.position(currOffset + initPos);
                    byte[] val = new byte[elementLength - 1];
                    buffer.get(val);
                    if (baseDataType == desiredDataType) {
                        elements[i++] = baseDataType.toObject(val, sortOrder);
                        continue;
                    }
                    elements[i++] = desiredDataType.toObject(val, sortOrder, baseDataType);
                }
            }
        } else {
            int elemLength = maxLength == null ? baseDataType.getByteSize() : maxLength;
            int noOfElements = length / elemLength;
            elements = baseDataType == desiredDataType ? (Object[])Array.newInstance(baseDataType.getJavaClass(), noOfElements) : (Object[])Array.newInstance(desiredDataType.getJavaClass(), noOfElements);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            for (int i = 0; i < noOfElements; ++i) {
                ptr.set(bytes, offset + i * elemLength, elemLength);
                elements[i] = baseDataType == desiredDataType ? baseDataType.toObject(ptr, sortOrder) : desiredDataType.toObject(ptr, baseDataType, sortOrder);
            }
        }
        if (baseDataType == desiredDataType) {
            return PArrayDataType.instantiatePhoenixArray(baseDataType, elements);
        }
        return PArrayDataType.instantiatePhoenixArray(desiredDataType, elements);
    }

    public static PhoenixArray instantiatePhoenixArray(PDataType actualType, Object[] elements) {
        return PDataType.instantiatePhoenixArray(actualType, elements);
    }

    @Override
    public int compareTo(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        PhoenixArray lhsArr = (PhoenixArray)lhs;
        PhoenixArray rhsArr = (PhoenixArray)rhs;
        if (lhsArr.equals(rhsArr)) {
            return 0;
        }
        return 1;
    }

    public static int getArrayLength(ImmutableBytesWritable ptr, PDataType baseType, Integer maxLength) {
        byte[] bytes = ptr.get();
        if (ptr.getLength() == 0) {
            return 0;
        }
        if (baseType.isFixedWidth()) {
            int elemLength = maxLength == null ? baseType.getByteSize() : maxLength;
            return ptr.getLength() / elemLength;
        }
        return Bytes.toInt((byte[])bytes, (int)(ptr.getOffset() + ptr.getLength() - 5));
    }

    public static int estimateSize(int size, PDataType baseType) {
        if (baseType.isFixedWidth()) {
            return baseType.getByteSize() * size;
        }
        return size * 10;
    }

    public Object getSampleValue(PDataType baseType, Integer arrayLength, Integer elemLength) {
        Preconditions.checkArgument((arrayLength == null || arrayLength >= 0 ? 1 : 0) != 0);
        if (arrayLength == null) {
            arrayLength = 1;
        }
        Object[] array = new Object[arrayLength.intValue()];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = baseType.getSampleValue(elemLength, arrayLength);
        }
        return PArrayDataType.instantiatePhoenixArray(baseType, array);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        StringBuilder buf = new StringBuilder("ARRAY[");
        PhoenixArray array = (PhoenixArray)o;
        PDataType baseType = PDataType.arrayBaseType(this);
        int len = array.getDimensions();
        if (len != 0) {
            for (int i = 0; i < len; ++i) {
                buf.append(baseType.toStringLiteral(array.getElement(i), null));
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
        }
        buf.append(']');
        return buf.toString();
    }
}

