/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.transaction.HBaseOmidClientConfiguration;
import org.apache.omid.transaction.HBaseTransactionManager;
import org.apache.omid.transaction.TTable;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.phoenix.coprocessor.OmidGCProcessor;
import org.apache.phoenix.coprocessor.OmidTransactionalProcessor;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.transaction.OmidTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;

public class OmidTransactionProvider
implements PhoenixTransactionProvider {
    private static final OmidTransactionProvider INSTANCE = new OmidTransactionProvider();
    private HBaseTransactionManager transactionManager = null;
    private volatile CommitTable.Client commitTableClient = null;

    public static final OmidTransactionProvider getInstance() {
        return INSTANCE;
    }

    private OmidTransactionProvider() {
    }

    public String toString() {
        return this.getProvider().toString();
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(byte[] txnBytes) throws IOException {
        return new OmidTransactionContext(Arrays.copyOf(txnBytes, txnBytes.length - 1));
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(PhoenixConnection connection) throws SQLException {
        return new OmidTransactionContext(connection);
    }

    @Override
    public PhoenixTransactionClient getTransactionClient(Configuration config, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo) throws SQLException {
        if (this.transactionManager == null) {
            try {
                HBaseOmidClientConfiguration clientConf = new HBaseOmidClientConfiguration();
                clientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
                this.transactionManager = (HBaseTransactionManager)HBaseTransactionManager.newInstance((HBaseOmidClientConfiguration)clientConf);
            }
            catch (IOException | InterruptedException e) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
            }
        }
        return new OmidTransactionClient(this.transactionManager);
    }

    public CommitTable.Client getCommitTableClient() {
        return this.commitTableClient;
    }

    public void injectTestService(HBaseTransactionManager transactionManager, CommitTable.Client commitTableClient) {
        this.transactionManager = transactionManager;
        this.commitTableClient = commitTableClient;
    }

    @Override
    public String getCoprocessorClassName() {
        return OmidTransactionalProcessor.class.getName();
    }

    @Override
    public String getGCCoprocessorClassName() {
        return OmidGCProcessor.class.getName();
    }

    @Override
    public TransactionFactory.Provider getProvider() {
        return TransactionFactory.Provider.OMID;
    }

    @Override
    public boolean isUnsupported(PhoenixTransactionProvider.Feature feature) {
        return true;
    }

    @Override
    public Put markPutAsCommitted(Put put, long timestamp, long commitTimestamp) {
        return TTable.markPutAsCommitted((Put)put, (long)timestamp, (long)timestamp);
    }

    static class OmidTransactionClient
    implements PhoenixTransactionClient {
        private final HBaseTransactionManager transactionManager;

        public OmidTransactionClient(HBaseTransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public HBaseTransactionManager getTransactionClient() {
            return this.transactionManager;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

