/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Splitter;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.phoenix.util.CSVCommonsLoader;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.apache.phoenix.util.UpgradeUtil;

public class PhoenixRuntime {
    public static final String JDBC_PROTOCOL = "jdbc:phoenix";
    public static final String JDBC_THIN_PROTOCOL = "jdbc:phoenix:thin";
    public static final char JDBC_PROTOCOL_TERMINATOR = ';';
    public static final char JDBC_PROTOCOL_SEPARATOR = ':';
    @Deprecated
    public static final String EMBEDDED_JDBC_PROTOCOL = "jdbc:phoenix:";
    public static final String CURRENT_SCN_ATTRIB = "CurrentSCN";
    public static final String BUILD_INDEX_AT_ATTRIB = "BuildIndexAt";
    public static final String TENANT_ID_ATTRIB = "TenantId";
    public static final String NO_UPGRADE_ATTRIB = "NoUpgrade";
    public static final String UPSERT_BATCH_SIZE_ATTRIB = "UpsertBatchSize";
    public static final String UPSERT_BATCH_SIZE_BYTES_ATTRIB = "UpsertBatchSizeBytes";
    public static final String AUTO_COMMIT_ATTRIB = "AutoCommit";
    public static final String CONSISTENCY_ATTRIB = "Consistency";
    public static final String REQUEST_METRIC_ATTRIB = "RequestMetric";
    public static final String EXPLAIN_PLAN_ESTIMATED_BYTES_READ_COLUMN = "EST_BYTES_READ";
    public static final String EXPLAIN_PLAN_ESTIMATED_ROWS_READ_COLUMN = "EST_ROWS_READ";
    public static final String EXPLAIN_PLAN_ESTIMATE_INFO_TS_COLUMN = "EST_INFO_TS";
    private static final String[] CONNECTION_PROPERTIES = new String[]{"CurrentSCN", "TenantId", "UpsertBatchSize", "AutoCommit", "Consistency", "RequestMetric"};
    public static final String CONNECTIONLESS = "none";
    public static final String ANNOTATION_ATTRIB_PREFIX = "phoenix.annotation.";
    private static final String HEADER_IN_LINE = "in-line";
    private static final String SQL_FILE_EXT = ".sql";
    private static final String CSV_FILE_EXT = ".csv";
    public static final String PHOENIX_TEST_DRIVER_URL_PARAM = "test=true";
    public static final String SCHEMA_ATTRIB = "schema";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ExecutionCommand execCmd = ExecutionCommand.parseArgs(args);
        String jdbcUrl = EMBEDDED_JDBC_PROTOCOL + execCmd.getConnectionString();
        int exitStatus = 0;
        PhoenixConnection conn = null;
        try {
            Properties props = new Properties();
            if (execCmd.isLocalIndexUpgrade()) {
                props.setProperty("phoenix.client.localIndexUpgrade", "false");
            }
            if (execCmd.binaryEncoding != null) {
                props.setProperty("phoenix.upload.binaryDataType.encoding", execCmd.binaryEncoding);
            }
            conn = DriverManager.getConnection(jdbcUrl, props).unwrap(PhoenixConnection.class);
            conn.setRunningUpgrade(true);
            if (execCmd.isMapNamespace()) {
                String srcTable = execCmd.getSrcTable();
                System.out.println("Starting upgrading table:" + srcTable + "... please don't kill it in between!!");
                UpgradeUtil.upgradeTable(conn, srcTable);
            } else if (execCmd.isUpgrade()) {
                if (conn.getClientInfo(CURRENT_SCN_ATTRIB) != null) {
                    throw new SQLException("May not specify the CURRENT_SCN property when upgrading");
                }
                if (conn.getClientInfo(TENANT_ID_ATTRIB) != null) {
                    throw new SQLException("May not specify the TENANT_ID_ATTRIB property when upgrading");
                }
                if (execCmd.getInputFiles().isEmpty()) {
                    String msg;
                    List<String> tablesNeedingUpgrade = UpgradeUtil.getPhysicalTablesWithDescRowKey(conn);
                    if (tablesNeedingUpgrade.isEmpty()) {
                        msg = "No tables are required to be upgraded due to incorrect row key order (PHOENIX-2067 and PHOENIX-2120)";
                        System.out.println(msg);
                    } else {
                        msg = "The following tables require upgrade due to a bug causing the row key to be incorrectly ordered (PHOENIX-2067 and PHOENIX-2120):\n" + Joiner.on((char)' ').join(tablesNeedingUpgrade);
                        System.out.println("WARNING: " + msg);
                    }
                    List<String> unsupportedTables = UpgradeUtil.getPhysicalTablesWithDescVarbinaryRowKey(conn);
                    if (!unsupportedTables.isEmpty()) {
                        String msg2 = "The following tables use an unsupported VARBINARY DESC construct and need to be changed:\n" + Joiner.on((char)' ').join(unsupportedTables);
                        System.out.println("WARNING: " + msg2);
                    }
                } else {
                    UpgradeUtil.upgradeDescVarLengthRowKeys(conn, execCmd.getInputFiles(), execCmd.isBypassUpgrade());
                }
            } else if (execCmd.isLocalIndexUpgrade()) {
                UpgradeUtil.upgradeLocalIndexes(conn);
            } else {
                for (String inputFile : execCmd.getInputFiles()) {
                    if (inputFile.endsWith(SQL_FILE_EXT)) {
                        PhoenixRuntime.executeStatements(conn, new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8), Collections.emptyList());
                        continue;
                    }
                    if (!inputFile.endsWith(CSV_FILE_EXT)) continue;
                    String tableName = execCmd.getTableName();
                    if (tableName == null) {
                        tableName = SchemaUtil.normalizeIdentifier(inputFile.substring(inputFile.lastIndexOf(File.separatorChar) + 1, inputFile.length() - CSV_FILE_EXT.length()));
                    }
                    CSVCommonsLoader csvLoader = new CSVCommonsLoader(conn, tableName, execCmd.getColumns(), execCmd.isStrict(), execCmd.getFieldDelimiter(), execCmd.getQuoteCharacter(), execCmd.getEscapeCharacter(), execCmd.getArrayElementSeparator());
                    csvLoader.upsert(inputFile);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitStatus = 1;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException props) {}
            }
            System.exit(exitStatus);
        }
    }

    private PhoenixRuntime() {
    }

    public static final String[] getConnectionProperties() {
        return Arrays.copyOf(CONNECTION_PROPERTIES, CONNECTION_PROPERTIES.length);
    }

    public static int executeStatements(Connection conn, Reader reader, List<Object> binds) throws IOException, SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        pconn.setAutoCommit(true);
        return pconn.executeStatements(reader, binds, System.out);
    }

    @Deprecated
    public static List<Cell> getUncommittedData(Connection conn) throws SQLException {
        Iterator<Pair<byte[], List<Cell>>> iterator = PhoenixRuntime.getUncommittedDataIterator(conn);
        if (iterator.hasNext()) {
            return (List)iterator.next().getSecond();
        }
        return Collections.emptyList();
    }

    public static Iterator<Pair<byte[], List<Cell>>> getUncommittedDataIterator(Connection conn) throws SQLException {
        return PhoenixRuntime.getUncommittedDataIterator(conn, false);
    }

    public static Iterator<Pair<byte[], List<Cell>>> getUncommittedDataIterator(Connection conn, boolean includeMutableIndexes) throws SQLException {
        final PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        final Iterator<Pair<byte[], List<Mutation>>> iterator = pconn.getMutationState().toMutations(includeMutableIndexes);
        return new Iterator<Pair<byte[], List<Cell>>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Pair<byte[], List<Cell>> next() {
                Pair pair = (Pair)iterator.next();
                ArrayList keyValues = Lists.newArrayListWithExpectedSize((int)(((List)pair.getSecond()).size() * 5));
                for (Mutation mutation : (List)pair.getSecond()) {
                    for (List keyValueList : mutation.getFamilyCellMap().values()) {
                        for (Cell keyValue : keyValueList) {
                            keyValues.add(PhoenixKeyValueUtil.maybeCopyCell(keyValue));
                        }
                    }
                }
                Collections.sort(keyValues, pconn.getKeyValueBuilder().getKeyValueComparator());
                return new Pair(pair.getFirst(), (Object)keyValues);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PTable getTableNoCache(Connection conn, String name) throws SQLException {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(name);
        String tableName = SchemaUtil.getTableNameFromFullName(name);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(pconn).updateCache(pconn.getTenantId(), schemaName, tableName, true);
        if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
            throw new TableNotFoundException(schemaName, tableName);
        }
        return result.getTable();
    }

    public static PTable getTable(Connection conn, String name) throws SQLException {
        PTable table = null;
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        try {
            table = pconn.getTable(new PTableKey(pconn.getTenantId(), name));
        }
        catch (TableNotFoundException e) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(name);
            String tableName = SchemaUtil.getTableNameFromFullName(name);
            MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(pconn).updateCache(schemaName, tableName);
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                throw e;
            }
            table = result.getTable();
        }
        return table;
    }

    public static PTable getTable(Connection conn, String tenantId, String fullTableName) throws SQLException {
        return PhoenixRuntime.getTable(conn, tenantId, fullTableName, Long.MAX_VALUE);
    }

    public static PTable getTable(Connection conn, @Nullable String tenantId, String fullTableName, @Nullable Long timestamp) throws SQLException {
        Preconditions.checkNotNull((Object)conn);
        Preconditions.checkNotNull((Object)fullTableName);
        if (timestamp != null) {
            Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0);
        }
        PTable table = null;
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PName pTenantId = tenantId == null ? null : PNameFactory.newName(tenantId);
        try {
            PTableRef tableref = pconn.getTableRef(new PTableKey(pTenantId, fullTableName));
            if (timestamp != null && (tableref == null || tableref.getResolvedTimeStamp() != timestamp.longValue())) {
                throw new TableNotFoundException(fullTableName);
            }
            table = tableref.getTable();
        }
        catch (TableNotFoundException e) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
            String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
            MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(pconn).updateCache(pTenantId, schemaName, tableName, false, timestamp);
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                throw e;
            }
            table = result.getTable();
        }
        return table;
    }

    public static List<ColumnInfo> generateColumnInfo(Connection conn, String tableName, List<String> columns) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, SchemaUtil.normalizeFullTableName(tableName));
        ArrayList columnInfoList = Lists.newArrayList();
        TreeSet<String> unresolvedColumnNames = new TreeSet<String>();
        if (columns == null || columns.isEmpty()) {
            int offset;
            for (int i = offset = table.getBucketNum() == null ? 0 : 1; i < table.getColumns().size(); ++i) {
                PColumn pColumn = table.getColumns().get(i);
                columnInfoList.add(PhoenixRuntime.getColumnInfo(pColumn));
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                String columnName = columns.get(i);
                try {
                    ColumnInfo columnInfo = PhoenixRuntime.getColumnInfo(table, columnName);
                    columnInfoList.add(columnInfo);
                    continue;
                }
                catch (ColumnNotFoundException cnfe) {
                    unresolvedColumnNames.add(columnName);
                    continue;
                }
                catch (AmbiguousColumnException ace) {
                    unresolvedColumnNames.add(columnName);
                }
            }
        }
        if (unresolvedColumnNames.size() > 0) {
            StringBuilder exceptionMessage = new StringBuilder();
            boolean first = true;
            exceptionMessage.append("Unable to resolve these column names:\n");
            for (String col : unresolvedColumnNames) {
                if (first) {
                    first = false;
                } else {
                    exceptionMessage.append(",");
                }
                exceptionMessage.append(col);
            }
            exceptionMessage.append("\nAvailable columns with column families:\n");
            first = true;
            for (PColumn pColumn : table.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    exceptionMessage.append(",");
                }
                exceptionMessage.append(pColumn.toString());
            }
            throw new SQLException(exceptionMessage.toString());
        }
        return columnInfoList;
    }

    public static ColumnInfo getColumnInfo(PTable table, String columnName) throws SQLException {
        if (table == null) {
            throw new SQLException("Table must not be null.");
        }
        if (columnName == null) {
            throw new SQLException("columnName must not be null.");
        }
        PColumn pColumn = null;
        if (columnName.contains(".")) {
            String[] tokens = columnName.split("\\.");
            if (tokens.length != 2) {
                throw new SQLException(String.format("Unable to process column %s, expected family-qualified name.", columnName));
            }
            String familyName = tokens[0];
            String familyColumn = tokens[1];
            PColumnFamily family = table.getColumnFamily(familyName);
            pColumn = family.getPColumnForColumnName(familyColumn);
        } else {
            pColumn = table.getColumnForColumnName(columnName);
        }
        return PhoenixRuntime.getColumnInfo(pColumn);
    }

    public static ColumnInfo getColumnInfo(PColumn pColumn) throws SQLException {
        if (pColumn == null) {
            throw new SQLException("pColumn must not be null.");
        }
        return ColumnInfo.create(pColumn.toString(), pColumn.getDataType().getSqlType(), pColumn.getMaxLength(), pColumn.getScale());
    }

    public static QueryPlan getOptimizedQueryPlan(PreparedStatement stmt) throws SQLException {
        Preconditions.checkNotNull((Object)stmt);
        QueryPlan plan = stmt.unwrap(PhoenixPreparedStatement.class).optimizeQuery();
        return plan;
    }

    public static boolean hasOrderBy(QueryPlan plan) {
        Preconditions.checkNotNull((Object)plan);
        List<OrderByExpression> orderBys = plan.getOrderBy().getOrderByExpressions();
        return orderBys != null && !orderBys.isEmpty();
    }

    public static int getLimit(QueryPlan plan) {
        Preconditions.checkNotNull((Object)plan);
        return plan.getLimit() == null ? 0 : plan.getLimit();
    }

    private static String addQuotes(String str) {
        return str == null ? str : "\"" + str + "\"";
    }

    public static List<Pair<String, String>> getPkColsForSql(Connection conn, QueryPlan plan) throws SQLException {
        Preconditions.checkNotNull((Object)plan);
        Preconditions.checkNotNull((Object)conn);
        List<PColumn> pkColumns = PhoenixRuntime.getPkColumns(plan.getTableRef().getTable(), conn);
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)pkColumns.size());
        for (PColumn pCol : pkColumns) {
            String columnName = PhoenixRuntime.addQuotes(pCol.getName().getString());
            String familyName = pCol.getFamilyName() != null ? PhoenixRuntime.addQuotes(pCol.getFamilyName().getString()) : null;
            columns.add(new Pair((Object)familyName, (Object)columnName));
        }
        return columns;
    }

    @Deprecated
    public static void getPkColsForSql(List<Pair<String, String>> columns, QueryPlan plan, Connection conn, boolean forDataTable) throws SQLException {
        Preconditions.checkNotNull(columns);
        Preconditions.checkNotNull((Object)plan);
        Preconditions.checkNotNull((Object)conn);
        List<PColumn> pkColumns = PhoenixRuntime.getPkColumns(plan.getTableRef().getTable(), conn, forDataTable);
        for (PColumn pCol : pkColumns) {
            String columnName = PhoenixRuntime.addQuotes(pCol.getName().getString());
            String familyName = pCol.getFamilyName() != null ? PhoenixRuntime.addQuotes(pCol.getFamilyName().getString()) : null;
            columns.add((Pair<String, String>)new Pair((Object)familyName, (Object)columnName));
        }
    }

    @Deprecated
    public static void getPkColsDataTypesForSql(List<Pair<String, String>> columns, List<String> dataTypes, QueryPlan plan, Connection conn, boolean forDataTable) throws SQLException {
        Preconditions.checkNotNull(columns);
        Preconditions.checkNotNull(dataTypes);
        Preconditions.checkNotNull((Object)plan);
        Preconditions.checkNotNull((Object)conn);
        List<PColumn> pkColumns = PhoenixRuntime.getPkColumns(plan.getTableRef().getTable(), conn, forDataTable);
        for (PColumn pCol : pkColumns) {
            String sqlTypeName = PhoenixRuntime.getSqlTypeName(pCol);
            dataTypes.add(sqlTypeName);
            String columnName = PhoenixRuntime.addQuotes(pCol.getName().getString());
            String familyName = pCol.getFamilyName() != null ? PhoenixRuntime.addQuotes(pCol.getFamilyName().getString()) : null;
            columns.add((Pair<String, String>)new Pair((Object)familyName, (Object)columnName));
        }
    }

    public static String getSqlTypeName(PColumn pCol) {
        PDataType dataType = pCol.getDataType();
        Integer maxLength = pCol.getMaxLength();
        Integer scale = pCol.getScale();
        return PhoenixRuntime.getSqlTypeName(dataType, maxLength, scale);
    }

    public static String getSqlTypeName(PDataType dataType, Integer maxLength, Integer scale) {
        return dataType.isArrayType() ? PhoenixRuntime.getArraySqlTypeName(maxLength, scale, dataType) : PhoenixRuntime.appendMaxLengthAndScale(maxLength, scale, dataType.getSqlTypeName());
    }

    public static String getArraySqlTypeName(@Nullable Integer maxLength, @Nullable Integer scale, PDataType arrayType) {
        String baseTypeSqlName = PDataType.arrayBaseType(arrayType).getSqlTypeName();
        return PhoenixRuntime.appendMaxLengthAndScale(maxLength, scale, baseTypeSqlName) + " " + "ARRAY";
    }

    private static String appendMaxLengthAndScale(@Nullable Integer maxLength, @Nullable Integer scale, String sqlTypeName) {
        if (maxLength != null) {
            sqlTypeName = sqlTypeName + "(" + maxLength;
            if (scale != null) {
                sqlTypeName = sqlTypeName + "," + scale;
            }
            sqlTypeName = sqlTypeName + ")";
        }
        return sqlTypeName;
    }

    @Deprecated
    private static List<PColumn> getPkColumns(PTable ptable, Connection conn, boolean forDataTable) throws SQLException {
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        List<PColumn> pkColumns = ptable.getPKColumns();
        int offset = (ptable.getBucketNum() == null ? 0 : 1) + (ptable.isMultiTenant() && pConn.getTenantId() != null ? 1 : 0) + (ptable.getViewIndexId() == null ? 0 : 1);
        pkColumns = pkColumns.subList(offset, pkColumns.size());
        if (ptable.getType() == PTableType.INDEX && forDataTable) {
            String fullDataTableName = ptable.getParentName().getString();
            List<PColumn> dataColumns = IndexUtil.getDataColumns(fullDataTableName, pkColumns, pConn);
            pkColumns = dataColumns;
        }
        return pkColumns;
    }

    private static List<PColumn> getPkColumns(PTable ptable, Connection conn) throws SQLException {
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        List<PColumn> pkColumns = ptable.getPKColumns();
        int offset = (ptable.getBucketNum() == null ? 0 : 1) + (ptable.isMultiTenant() && pConn.getTenantId() != null ? 1 : 0) + (ptable.getViewIndexId() == null ? 0 : 1);
        pkColumns = pkColumns.subList(offset, pkColumns.size());
        if (ptable.getType() == PTableType.INDEX) {
            String fullDataTableName = ptable.getParentName().getString();
            List<PColumn> dataColumns = IndexUtil.getDataColumns(fullDataTableName, pkColumns, pConn);
            pkColumns = dataColumns;
        }
        return pkColumns;
    }

    @Deprecated
    public static byte[] encodeValues(Connection conn, String fullTableName, Object[] values, List<Pair<String, String>> columns) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        List<PColumn> pColumns = PhoenixRuntime.getPColumns(table, columns);
        ArrayList<LiteralExpression> expressions = new ArrayList<LiteralExpression>(pColumns.size());
        int i = 0;
        for (PColumn col : pColumns) {
            Object value = values[i];
            LiteralExpression expr = LiteralExpression.newConstant(value, col.getDataType(), col.getMaxLength(), col.getScale());
            expressions.add(expr);
            ++i;
        }
        KeyValueSchema kvSchema = PhoenixRuntime.buildKeyValueSchema(pColumns);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ValueBitSet valueSet = ValueBitSet.newInstance(kvSchema);
        return kvSchema.toBytes(expressions.toArray(new Expression[0]), valueSet, ptr);
    }

    @Deprecated
    public static Object[] decodeValues(Connection conn, String fullTableName, byte[] value, List<Pair<String, String>> columns) throws SQLException {
        Boolean hasValue;
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        KeyValueSchema kvSchema = PhoenixRuntime.buildKeyValueSchema(PhoenixRuntime.getPColumns(table, columns));
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(value);
        ValueBitSet valueSet = ValueBitSet.newInstance(kvSchema);
        valueSet.clear();
        valueSet.or(ptr);
        int maxOffset = ptr.getOffset() + ptr.getLength();
        kvSchema.iterator(ptr);
        int i = 0;
        ArrayList<Object> values = new ArrayList<Object>();
        while ((hasValue = Boolean.valueOf(kvSchema.next(ptr, i, maxOffset, valueSet) != null)).booleanValue()) {
            if (hasValue.booleanValue()) {
                values.add(kvSchema.getField(i).getDataType().toObject(ptr));
            }
            ++i;
        }
        return values.toArray();
    }

    public static byte[] encodeColumnValues(Connection conn, String fullTableName, Object[] values, List<Pair<String, String>> columns) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        List<PColumn> pColumns = PhoenixRuntime.getColumns(table, columns);
        ArrayList<LiteralExpression> expressions = new ArrayList<LiteralExpression>(pColumns.size());
        int i = 0;
        for (PColumn col : pColumns) {
            Object value = values[i];
            LiteralExpression expr = LiteralExpression.newConstant(value, col.getDataType(), col.getMaxLength(), col.getScale());
            expressions.add(expr);
            ++i;
        }
        KeyValueSchema kvSchema = PhoenixRuntime.buildKeyValueSchema(pColumns);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ValueBitSet valueSet = ValueBitSet.newInstance(kvSchema);
        return kvSchema.toBytes(expressions.toArray(new Expression[0]), valueSet, ptr);
    }

    public static Object[] decodeColumnValues(Connection conn, String fullTableName, byte[] value, List<Pair<String, String>> columns) throws SQLException {
        Boolean hasValue;
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        KeyValueSchema kvSchema = PhoenixRuntime.buildKeyValueSchema(PhoenixRuntime.getColumns(table, columns));
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(value);
        ValueBitSet valueSet = ValueBitSet.newInstance(kvSchema);
        valueSet.clear();
        valueSet.or(ptr);
        int maxOffset = ptr.getOffset() + ptr.getLength();
        kvSchema.iterator(ptr);
        int i = 0;
        ArrayList<Object> values = new ArrayList<Object>();
        while ((hasValue = Boolean.valueOf(kvSchema.next(ptr, i, maxOffset, valueSet) != null)).booleanValue()) {
            if (hasValue.booleanValue()) {
                values.add(kvSchema.getField(i).getDataType().toObject(ptr));
            }
            ++i;
        }
        return values.toArray();
    }

    public static KeyValueSchema buildKeyValueSchema(List<PColumn> columns) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(PhoenixRuntime.getMinNullableIndex(columns));
        for (PColumn col : columns) {
            builder.addField(col);
        }
        return builder.build();
    }

    private static int getMinNullableIndex(List<PColumn> columns) {
        int minNullableIndex = columns.size();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).isNullable()) continue;
            minNullableIndex = i;
            break;
        }
        return minNullableIndex;
    }

    @Deprecated
    private static List<PColumn> getPColumns(PTable table, List<Pair<String, String>> columns) throws SQLException {
        ArrayList<PColumn> pColumns = new ArrayList<PColumn>(columns.size());
        for (Pair<String, String> column : columns) {
            pColumns.add(PhoenixRuntime.getPColumn(table, (String)column.getFirst(), (String)column.getSecond()));
        }
        return pColumns;
    }

    @Deprecated
    private static PColumn getPColumn(PTable table, @Nullable String familyName, String columnName) throws SQLException {
        if (table == null) {
            throw new SQLException("Table must not be null.");
        }
        if (columnName == null) {
            throw new SQLException("columnName must not be null.");
        }
        familyName = SchemaUtil.normalizeIdentifier(familyName);
        columnName = SchemaUtil.normalizeIdentifier(columnName);
        PColumn pColumn = null;
        if (familyName != null) {
            PColumnFamily family = table.getColumnFamily(familyName);
            pColumn = family.getPColumnForColumnName(columnName);
        } else {
            pColumn = table.getColumnForColumnName(columnName);
        }
        return pColumn;
    }

    private static List<PColumn> getColumns(PTable table, List<Pair<String, String>> columns) throws SQLException {
        ArrayList<PColumn> pColumns = new ArrayList<PColumn>(columns.size());
        for (Pair<String, String> column : columns) {
            pColumns.add(PhoenixRuntime.getColumn(table, (String)column.getFirst(), (String)column.getSecond()));
        }
        return pColumns;
    }

    private static PColumn getColumn(PTable table, @Nullable String familyName, String columnName) throws SQLException {
        if (table == null) {
            throw new SQLException("Table must not be null.");
        }
        if (columnName == null) {
            throw new SQLException("columnName must not be null.");
        }
        familyName = SchemaUtil.normalizeIdentifier(familyName);
        columnName = SchemaUtil.normalizeIdentifier(columnName);
        if (table.getType() == PTableType.INDEX) {
            columnName = IndexUtil.getIndexColumnName(familyName, columnName);
        }
        PColumn pColumn = null;
        if (familyName != null) {
            PColumnFamily family = table.getColumnFamily(familyName);
            pColumn = family.getPColumnForColumnName(columnName);
        } else {
            pColumn = table.getColumnForColumnName(columnName);
        }
        return pColumn;
    }

    public static Expression getTenantIdExpression(Connection conn, String fullTableName) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        if (!(SchemaUtil.isMetaTable(table) || SchemaUtil.isSequenceTable(table) || table.isMultiTenant())) {
            return null;
        }
        return PhoenixRuntime.getFirstPKColumnExpression(table);
    }

    public static Expression getFirstPKColumnExpression(Connection conn, String fullTableName) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        return PhoenixRuntime.getFirstPKColumnExpression(table);
    }

    private static Expression getFirstPKColumnExpression(PTable table) throws SQLException {
        if (table.getIndexType() == PTable.IndexType.LOCAL) {
            throw new SQLFeatureNotSupportedException();
        }
        int pkPosition = (table.getBucketNum() == null ? 0 : 1) + (table.getViewIndexId() == null ? 0 : 1);
        List<PColumn> pkColumns = table.getPKColumns();
        return new RowKeyColumnExpression(pkColumns.get(pkPosition), new RowKeyValueAccessor(pkColumns, pkPosition));
    }

    public static Collection<GlobalMetric> getGlobalPhoenixClientMetrics() {
        return GlobalClientMetrics.getMetrics();
    }

    public static boolean areGlobalClientMetricsBeingCollected() {
        return GlobalClientMetrics.isMetricsEnabled();
    }

    private static Map<String, Long> createMetricMap(Map<MetricType, Long> metricInfoMap) {
        HashMap metricMap = Maps.newHashMapWithExpectedSize((int)metricInfoMap.size());
        for (Map.Entry<MetricType, Long> entry : metricInfoMap.entrySet()) {
            metricMap.put(entry.getKey().shortName(), entry.getValue());
        }
        return metricMap;
    }

    private static Map<String, Map<String, Long>> transformMetrics(Map<String, Map<MetricType, Long>> metricMap) {
        Function<Map<MetricType, Long>, Map<String, Long>> func = new Function<Map<MetricType, Long>, Map<String, Long>>(){

            public Map<String, Long> apply(Map<MetricType, Long> map) {
                return PhoenixRuntime.createMetricMap(map);
            }
        };
        return Maps.transformValues(metricMap, (Function)func);
    }

    public static Map<String, Map<MetricType, Long>> getRequestReadMetricInfo(ResultSet rs) throws SQLException {
        PhoenixResultSet resultSet = rs.unwrap(PhoenixResultSet.class);
        return resultSet.getReadMetrics();
    }

    @Deprecated
    public static Map<String, Map<String, Long>> getRequestReadMetrics(ResultSet rs) throws SQLException {
        return PhoenixRuntime.transformMetrics(PhoenixRuntime.getRequestReadMetricInfo(rs));
    }

    public static Map<MetricType, Long> getOverAllReadRequestMetricInfo(ResultSet rs) throws SQLException {
        PhoenixResultSet resultSet = rs.unwrap(PhoenixResultSet.class);
        return resultSet.getOverAllRequestReadMetrics();
    }

    @Deprecated
    public static Map<String, Long> getOverAllReadRequestMetrics(ResultSet rs) throws SQLException {
        return PhoenixRuntime.createMetricMap(PhoenixRuntime.getOverAllReadRequestMetricInfo(rs));
    }

    public static Map<String, Map<MetricType, Long>> getWriteMetricInfoForMutationsSinceLastReset(Connection conn) throws SQLException {
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        return pConn.getMutationMetrics();
    }

    @Deprecated
    public static Map<String, Map<String, Long>> getWriteMetricsForMutationsSinceLastReset(Connection conn) throws SQLException {
        return PhoenixRuntime.transformMetrics(PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset(conn));
    }

    public static Map<String, Map<MetricType, Long>> getReadMetricInfoForMutationsSinceLastReset(Connection conn) throws SQLException {
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        return pConn.getReadMetrics();
    }

    @Deprecated
    public static Map<String, Map<String, Long>> getReadMetricsForMutationsSinceLastReset(Connection conn) throws SQLException {
        return PhoenixRuntime.transformMetrics(PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset(conn));
    }

    public static void resetMetrics(ResultSet rs) throws SQLException {
        PhoenixResultSet prs = rs.unwrap(PhoenixResultSet.class);
        prs.resetMetrics();
    }

    public static void resetMetrics(Connection conn) throws SQLException {
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        pConn.clearMetrics();
    }

    public static long getWallClockTimeFromCellTimeStamp(long tsOfCell) {
        return TransactionUtil.isTransactionalTimestamp(tsOfCell) ? TransactionUtil.convertToMilliseconds(tsOfCell) : tsOfCell;
    }

    public static long getCurrentScn(ReadOnlyProps props) {
        String scn = props.get(CURRENT_SCN_ATTRIB);
        return scn != null ? Long.parseLong(scn) : Long.MAX_VALUE;
    }

    static class ExecutionCommand {
        private String connectionString;
        private List<String> columns;
        private String tableName;
        private char fieldDelimiter;
        private char quoteCharacter;
        private Character escapeCharacter;
        private String arrayElementSeparator;
        private boolean strict;
        private List<String> inputFiles;
        private boolean isUpgrade;
        private boolean isBypassUpgrade;
        private boolean mapNamespace;
        private String srcTable;
        private boolean localIndexUpgrade;
        private String binaryEncoding;

        ExecutionCommand() {
        }

        public static ExecutionCommand parseArgs(String[] args) {
            ArrayList argList;
            Option tableOption = new Option("t", "table", true, "Overrides the table into which the CSV data is loaded and is case sensitive");
            Option binaryEncodingOption = new Option("b", "binaryEncoding", true, "Specifies binary encoding");
            Option headerOption = new Option("h", "header", true, "Overrides the column names to which the CSV data maps and is case sensitive. A special value of in-line indicating that the first line of the CSV file determines the column to which the data maps");
            Option strictOption = new Option("s", "strict", false, "Use strict mode by throwing an exception if a column name doesn't match during CSV loading");
            Option delimiterOption = new Option("d", "delimiter", true, "Field delimiter for CSV loader. A digit is interpreted as 1 -> ctrl A, 2 -> ctrl B ... 9 -> ctrl I.");
            Option quoteCharacterOption = new Option("q", "quote-character", true, "Quote character for CSV loader. A digit is interpreted as a control character");
            Option escapeCharacterOption = new Option("e", "escape-character", true, "Escape character for CSV loader. A digit is interpreted as a control character");
            Option arrayValueSeparatorOption = new Option("a", "array-separator", true, "Define the array element separator, defaults to ':'");
            Option upgradeOption = new Option("u", "upgrade", false, "Upgrades tables specified as arguments by rewriting them with the correct row key for descending columns. If no arguments are specified, then tables that need to be upgraded will be displayed without being upgraded. Use the -b option to bypass the rewrite if you know that your data does not need to be upgrade. This would only be the case if you have not relied on auto padding for BINARY and CHAR data, but instead have always provided data up to the full max length of the column. See PHOENIX-2067 and PHOENIX-2120 for more information. Note that phoenix.query.timeoutMs and hbase.regionserver.lease.period parameters must be set very high to prevent timeouts when upgrading.");
            Option bypassUpgradeOption = new Option("b", "bypass-upgrade", false, "Used in conjunction with the -u option to bypass the rewrite during upgrade if you know that your data does not need to be upgrade. This would only be the case if you have not relied on auto padding for BINARY and CHAR data, but instead have always provided data up to the full max length of the column. See PHOENIX-2067 and PHOENIX-2120 for more information. ");
            Option mapNamespaceOption = new Option("m", "map-namespace", true, "Used to map table to a namespace matching with schema, require phoenix.schema.isNamespaceMappingEnabled to be enabled");
            Option localIndexUpgradeOption = new Option("l", "local-index-upgrade", false, "Used to upgrade local index data by moving index data from separate table to separate column families in the same table.");
            Options options = new Options();
            options.addOption(tableOption);
            options.addOption(headerOption);
            options.addOption(strictOption);
            options.addOption(delimiterOption);
            options.addOption(quoteCharacterOption);
            options.addOption(escapeCharacterOption);
            options.addOption(arrayValueSeparatorOption);
            options.addOption(upgradeOption);
            options.addOption(bypassUpgradeOption);
            options.addOption(mapNamespaceOption);
            options.addOption(localIndexUpgradeOption);
            options.addOption(binaryEncodingOption);
            DefaultParser parser = new DefaultParser(false, false);
            CommandLine cmdLine = null;
            try {
                cmdLine = parser.parse(options, args);
            }
            catch (ParseException e) {
                ExecutionCommand.usageError(options);
            }
            ExecutionCommand execCmd = new ExecutionCommand();
            execCmd.connectionString = "";
            if (cmdLine.hasOption(mapNamespaceOption.getOpt())) {
                execCmd.mapNamespace = true;
                execCmd.srcTable = ExecutionCommand.validateTableName(cmdLine.getOptionValue(mapNamespaceOption.getOpt()));
            }
            if (cmdLine.hasOption(tableOption.getOpt())) {
                execCmd.tableName = cmdLine.getOptionValue(tableOption.getOpt());
            }
            if (cmdLine.hasOption(binaryEncodingOption.getOpt())) {
                execCmd.binaryEncoding = cmdLine.getOptionValue(binaryEncodingOption.getOpt());
            }
            if (cmdLine.hasOption(headerOption.getOpt())) {
                String columnString = cmdLine.getOptionValue(headerOption.getOpt());
                execCmd.columns = PhoenixRuntime.HEADER_IN_LINE.equals(columnString) ? ImmutableList.of() : ImmutableList.copyOf((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)columnString));
            }
            execCmd.strict = cmdLine.hasOption(strictOption.getOpt());
            execCmd.fieldDelimiter = ExecutionCommand.getCharacter(cmdLine.getOptionValue(delimiterOption.getOpt(), ","));
            execCmd.quoteCharacter = ExecutionCommand.getCharacter(cmdLine.getOptionValue(quoteCharacterOption.getOpt(), "\""));
            if (cmdLine.hasOption(escapeCharacterOption.getOpt())) {
                execCmd.escapeCharacter = Character.valueOf(ExecutionCommand.getCharacter(cmdLine.getOptionValue(escapeCharacterOption.getOpt(), "\\")));
            }
            execCmd.arrayElementSeparator = cmdLine.getOptionValue(arrayValueSeparatorOption.getOpt(), ":");
            if (cmdLine.hasOption(upgradeOption.getOpt())) {
                execCmd.isUpgrade = true;
            }
            if (cmdLine.hasOption(bypassUpgradeOption.getOpt())) {
                if (!execCmd.isUpgrade()) {
                    ExecutionCommand.usageError("The bypass-upgrade option may only be used in conjunction with the -u option", options);
                }
                execCmd.isBypassUpgrade = true;
            }
            if (cmdLine.hasOption(localIndexUpgradeOption.getOpt())) {
                execCmd.localIndexUpgrade = true;
            }
            if ((argList = Lists.newArrayList((Iterable)cmdLine.getArgList())).isEmpty()) {
                ExecutionCommand.usageError("At least one input file must be supplied", options);
            }
            ArrayList inputFiles = Lists.newArrayList();
            int i = 0;
            for (String arg : argList) {
                if (execCmd.isUpgrade || arg.endsWith(PhoenixRuntime.CSV_FILE_EXT) || arg.endsWith(PhoenixRuntime.SQL_FILE_EXT)) {
                    inputFiles.add(arg);
                } else if (i == 0) {
                    execCmd.connectionString = arg;
                } else {
                    ExecutionCommand.usageError("Don't know how to interpret argument '" + arg + "'", options);
                }
                ++i;
            }
            if (inputFiles.isEmpty() && !execCmd.isUpgrade && !execCmd.isMapNamespace() && !execCmd.isLocalIndexUpgrade()) {
                ExecutionCommand.usageError("At least one input file must be supplied", options);
            }
            execCmd.inputFiles = inputFiles;
            return execCmd;
        }

        private static String validateTableName(String tableName) {
            if (tableName.contains(":")) {
                throw new IllegalArgumentException("tablename:" + tableName + " cannot have '" + ":" + "' ");
            }
            return tableName;
        }

        private static char getCharacter(String s) {
            String unescaped = StringEscapeUtils.unescapeJava((String)s);
            if (unescaped.length() > 1) {
                throw new IllegalArgumentException("Invalid single character: '" + unescaped + "'");
            }
            return unescaped.charAt(0);
        }

        private static void usageError(String errorMsg, Options options) {
            System.out.println(errorMsg);
            ExecutionCommand.usageError(options);
        }

        private static void usageError(Options options) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("psql [-t table-name] [-h comma-separated-column-names | in-line] [-d field-delimiter-char quote-char escape-char]<zookeeper>  <path-to-sql-or-csv-file>...", options);
            System.out.println("Examples:\n  psql my_ddl.sql\n  psql localhost my_ddl.sql\n  psql localhost my_ddl.sql my_table.csv\n  psql -t MY_TABLE my_cluster:1825 my_table2012-Q3.csv\n  psql -t MY_TABLE -h COL1,COL2,COL3 my_cluster:1825 my_table2012-Q3.csv\n  psql -t MY_TABLE -h COL1,COL2,COL3 -d : my_cluster:1825 my_table2012-Q3.csv");
            System.exit(-1);
        }

        public String getConnectionString() {
            return this.connectionString;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public String getTableName() {
            return this.tableName;
        }

        public char getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        public char getQuoteCharacter() {
            return this.quoteCharacter;
        }

        public Character getEscapeCharacter() {
            return this.escapeCharacter;
        }

        public String getArrayElementSeparator() {
            return this.arrayElementSeparator;
        }

        public List<String> getInputFiles() {
            return this.inputFiles;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public boolean isUpgrade() {
            return this.isUpgrade;
        }

        public boolean isBypassUpgrade() {
            return this.isBypassUpgrade;
        }

        public boolean isMapNamespace() {
            return this.mapNamespace;
        }

        public String getSrcTable() {
            return this.srcTable;
        }

        public boolean isLocalIndexUpgrade() {
            return this.localIndexUpgrade;
        }
    }
}

