/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.i18n;

import com.ibm.icu.impl.jdkadapter.CollatorICU;
import com.ibm.icu.text.AlphabeticIndex;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.text.CollationKey;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.phoenix.util.DeferredStringBuilder;
import org.apache.phoenix.util.i18n.OracleUpperTable;

public final class LinguisticSort
extends Enum<LinguisticSort> {
    public static final /* enum */ LinguisticSort ENGLISH = new LinguisticSort(Locale.ENGLISH, "[", false, false, "upper({0})");
    public static final /* enum */ LinguisticSort GERMAN = new LinguisticSort(new Locale("de"), Alphabets.GERMAN, "0", true, false, "nlssort({0}, ''nls_sort=xgerman'')");
    public static final /* enum */ LinguisticSort FRENCH = new LinguisticSort(new Locale("fr"), "0", false, false, "nlssort({0}, ''nls_sort=xfrench'')");
    public static final /* enum */ LinguisticSort ITALIAN = new LinguisticSort(new Locale("it"), "0", false, false, "nlssort({0}, ''nls_sort=italian'')");
    public static final /* enum */ LinguisticSort SPANISH = new LinguisticSort(new Locale("es"), "0", false, false, "nlssort({0}, ''nls_sort=spanish'')");
    public static final /* enum */ LinguisticSort CATALAN = new LinguisticSort(new Locale("ca"), Alphabets.CATALAN, "0", true, false, "nlssort({0}, ''nls_sort=catalan'')");
    public static final /* enum */ LinguisticSort DUTCH = new LinguisticSort(new Locale("nl"), "0", false, false, "nlssort({0}, ''nls_sort=dutch'')");
    public static final /* enum */ LinguisticSort PORTUGUESE = new LinguisticSort(new Locale("pt"), "0", false, false, "nlssort({0}, ''nls_sort=west_european'')");
    public static final /* enum */ LinguisticSort DANISH = new LinguisticSort(new Locale("da"), "0", false, false, "nlssort({0}, ''nls_sort=danish'')");
    public static final /* enum */ LinguisticSort NORWEGIAN = new LinguisticSort(new Locale("no"), "0", false, false, "nlssort({0}, ''nls_sort=norwegian'')");
    public static final /* enum */ LinguisticSort SWEDISH = new LinguisticSort(new Locale("sv"), null, false, false, "nlssort({0}, ''nls_sort=swedish'')");
    public static final /* enum */ LinguisticSort FINNISH = new LinguisticSort(new Locale("fi"), new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "Y", "Z", "\u00c5", "\u00c4", "\u00d6"}, "0", false, false, "nlssort({0}, ''nls_sort=finnish'')");
    public static final /* enum */ LinguisticSort CZECH = new LinguisticSort(new Locale("cs"), "0", true, false, "nlssort({0}, ''nls_sort=xczech'')");
    public static final /* enum */ LinguisticSort POLISH = new LinguisticSort(new Locale("pl"), "\u00df", false, false, "nlssort({0}, ''nls_sort=polish'')");
    public static final /* enum */ LinguisticSort TURKISH = new LinguisticSort(new Locale("tr"), Alphabets.TURKISH, null, false, false, "nlssort({0}, ''nls_sort=xturkish'')");
    public static final /* enum */ LinguisticSort CHINESE_HK = new LinguisticSort(new Locale("zh", "HK"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=tchinese_radical_m'')");
    public static final /* enum */ LinguisticSort CHINESE_HK_STROKE = new LinguisticSort(new Locale("zh", "HK", "STROKE"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=tchinese_stroke_m'')");
    public static final /* enum */ LinguisticSort CHINESE_TW = new LinguisticSort(new Locale("zh", "TW"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=tchinese_radical_m'')");
    public static final /* enum */ LinguisticSort CHINESE_TW_STROKE = new LinguisticSort(new Locale("zh", "TW", "STROKE"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=tchinese_stroke_m'')");
    public static final /* enum */ LinguisticSort CHINESE = new LinguisticSort(new Locale("zh"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=schinese_radical_m'')");
    public static final /* enum */ LinguisticSort CHINESE_STROKE = new LinguisticSort(new Locale("zh", "", "STROKE"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=schinese_stroke_m'')");
    public static final /* enum */ LinguisticSort CHINESE_PINYIN = new LinguisticSort(new Locale("zh", "", "PINYIN"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=schinese_pinyin_m'')");
    public static final /* enum */ LinguisticSort JAPANESE = new LinguisticSort(new Locale("ja"), Alphabets.JAPANESE, null, true, true, "nlssort({0}, ''nls_sort=japanese_m'')");
    public static final /* enum */ LinguisticSort KOREAN = new LinguisticSort(new Locale("ko"), Alphabets.ENGLISH, "\u03b1", true, true, "nlssort({0}, ''nls_sort=korean_m'')");
    public static final /* enum */ LinguisticSort RUSSIAN = new LinguisticSort(new Locale("ru"), null, false, false, "nlssort({0}, ''nls_sort=russian'')");
    public static final /* enum */ LinguisticSort BULGARIAN = new LinguisticSort(new Locale("bg"), Alphabets.BULGARIAN, null, true, false, "nlssort({0}, ''nls_sort=bulgarian'')");
    public static final /* enum */ LinguisticSort INDONESIAN = new LinguisticSort(new Locale("in"), null, true, false, "nlssort({0}, ''nls_sort=indonesian'')");
    public static final /* enum */ LinguisticSort ROMANIAN = new LinguisticSort(new Locale("ro"), new String[]{"A", "\u0102", "\u00c2", "B", "C", "D", "E", "F", "G", "H", "I", "\u00ce", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "\u015e", "T", "\u0162", "U", "V", "W", "X", "Y", "Z"}, null, true, false, "nlssort({0}, ''nls_sort=romanian'')");
    public static final /* enum */ LinguisticSort VIETNAMESE = new LinguisticSort(new Locale("vi"), new String[]{"A", "\u0102", "\u00c2", "B", "C", "D", "\u0110", "E", "\u00ca", "G", "H", "I", "K", "L", "M", "N", "O", "\u00d4", "\u01a0", "P", "Q", "R", "S", "T", "U", "\u01af", "V", "X", "Y"}, null, false, false, "nlssort({0}, ''nls_sort=vietnamese'')");
    public static final /* enum */ LinguisticSort UKRAINIAN = new LinguisticSort(new Locale("uk"), null, false, false, "nlssort({0}, ''nls_sort=ukrainian'')");
    public static final /* enum */ LinguisticSort HUNGARIAN = new LinguisticSort(new Locale("hu"), Alphabets.HUNGARIAN, null, false, false, "nlssort({0}, ''nls_sort=xhungarian'')");
    public static final /* enum */ LinguisticSort GREEK = new LinguisticSort(new Locale("el"), null, false, false, "nlssort({0}, ''nls_sort=greek'')");
    public static final /* enum */ LinguisticSort HEBREW = new LinguisticSort(new Locale("iw"), null, true, false, "nlssort({0}, ''nls_sort=hebrew'')");
    public static final /* enum */ LinguisticSort SLOVAK = new LinguisticSort(new Locale("sk"), Alphabets.SLOVAK, null, true, false, "nlssort({0}, ''nls_sort=slovak'')");
    public static final /* enum */ LinguisticSort SERBIAN_CYRILLIC = new LinguisticSort(new Locale("sr"), null, false, false, "nlssort({0}, ''nls_sort=generic_m'')");
    public static final /* enum */ LinguisticSort SERBIAN_LATIN = new LinguisticSort(new Locale("sh"), Alphabets.SERBIAN_LATIN, null, false, false, "nlssort({0}, ''nls_sort=xcroatian'')");
    public static final /* enum */ LinguisticSort BOSNIAN = new LinguisticSort(new Locale("bs"), Alphabets.SERBIAN_LATIN, null, false, false, "nlssort({0}, ''nls_sort=xcroatian'')");
    public static final /* enum */ LinguisticSort GEORGIAN = new LinguisticSort(new Locale("ka"), Alphabets.GEORGIAN, null, false, false, "nlssort({0}, ''nls_sort=binary'')");
    public static final /* enum */ LinguisticSort BASQUE = new LinguisticSort(new Locale("eu"), Alphabets.BASQUE, null, false, false, "nlssort({0}, ''nls_sort=west_european'')");
    public static final /* enum */ LinguisticSort MALTESE = new LinguisticSort(new Locale("mt"), null, false, false, "nlssort({0}, ''nls_sort=west_european'')");
    public static final /* enum */ LinguisticSort ROMANSH = new LinguisticSort(new Locale("rm"), null, false, false, "nlssort({0}, ''nls_sort=west_european'')");
    public static final /* enum */ LinguisticSort LUXEMBOURGISH = new LinguisticSort(new Locale("lb"), Alphabets.LUXEMBOURGISH, null, false, false, "nlssort({0}, ''nls_sort=west_european'')");
    public static final /* enum */ LinguisticSort IRISH = new LinguisticSort(new Locale("ga"), null, false, false, "nlssort({0}, ''nls_sort=west_european'')");
    public static final /* enum */ LinguisticSort SLOVENE = new LinguisticSort(new Locale("sl"), Alphabets.SLOVENE, null, false, false, "nlssort({0}, ''nls_sort=xslovenian'')");
    public static final /* enum */ LinguisticSort CROATIAN = new LinguisticSort(new Locale("hr"), Alphabets.SERBIAN_LATIN, null, false, false, "nlssort({0}, ''nls_sort=xcroatian'')");
    public static final /* enum */ LinguisticSort MALAY = new LinguisticSort(new Locale("ms"), null, true, false, "nlssort({0}, ''nls_sort=malay'')");
    public static final /* enum */ LinguisticSort ARABIC = new LinguisticSort(new Locale("ar"), null, false, false, "nlssort({0}, ''nls_sort=arabic'')");
    public static final /* enum */ LinguisticSort ESTONIAN = new LinguisticSort(new Locale("et"), Alphabets.ESTONIAN, null, true, false, "nlssort({0}, ''nls_sort=estonian'')");
    public static final /* enum */ LinguisticSort ICELANDIC = new LinguisticSort(new Locale("is"), Alphabets.ICELANDIC, null, true, false, "nlssort({0}, ''nls_sort=icelandic'')");
    public static final /* enum */ LinguisticSort LATVIAN = new LinguisticSort(new Locale("lv"), Alphabets.LATVIAN, null, false, false, "nlssort({0}, ''nls_sort=latvian'')");
    public static final /* enum */ LinguisticSort LITHUANIAN = new LinguisticSort(new Locale("lt"), Alphabets.LITHUANIAN, null, false, false, "nlssort({0}, ''nls_sort=lithuanian'')");
    public static final /* enum */ LinguisticSort KYRGYZ = new LinguisticSort(new Locale("ky"), Alphabets.KYRGYZ, null, true, false, "nlssort({0}, ''nls_sort=binary'')");
    public static final /* enum */ LinguisticSort KAZAKH = new LinguisticSort(new Locale("kk"), Alphabets.KAZAKH, null, true, false, "nlssort({0}, ''nls_sort=binary'')");
    public static final /* enum */ LinguisticSort TAJIK = new LinguisticSort(new Locale("tg"), Alphabets.TAJIK, null, true, false, "nlssort({0}, ''nls_sort=russian'')");
    public static final /* enum */ LinguisticSort BELARUSIAN = new LinguisticSort(new Locale("be"), null, true, false, "nlssort({0}, ''nls_sort=russian'')");
    public static final /* enum */ LinguisticSort TURKMEN = new LinguisticSort(new Locale("tk"), Alphabets.TURKISH, null, false, false, "nlssort({0}, ''nls_sort=xturkish'')");
    public static final /* enum */ LinguisticSort AZERBAIJANI = new LinguisticSort(new Locale("az"), Alphabets.AZERBAIJANI, null, false, false, "nlssort({0}, ''nls_sort=xturkish'')");
    public static final /* enum */ LinguisticSort ARMENIAN = new LinguisticSort(new Locale("hy"), null, true, false, "nlssort({0}, ''nls_sort=binary'')");
    public static final /* enum */ LinguisticSort THAI = new LinguisticSort(new Locale("th"), null, true, false, "nlssort({0}, ''nls_sort=thai_dictionary'')");
    public static final /* enum */ LinguisticSort HINDI = new LinguisticSort(new Locale("hi"), null, true, false, "nlssort({0}, ''nls_sort=binary'')");
    public static final /* enum */ LinguisticSort URDU = new LinguisticSort(new Locale("ur"), Alphabets.URDU, null, false, false, "nlssort({0}, ''nls_sort=arabic'')");
    public static final /* enum */ LinguisticSort BENGALI = new LinguisticSort(new Locale("bn"), Alphabets.BENGALI, null, true, false, "nlssort({0}, ''nls_sort=bengali'')");
    public static final /* enum */ LinguisticSort TAMIL = new LinguisticSort(new Locale("ta"), Alphabets.TAMIL, null, true, false, "nlssort({0}, ''nls_sort=binary'')");
    public static final /* enum */ LinguisticSort ESPERANTO = new LinguisticSort(new Locale("eo"), Alphabets.ENGLISH, "[", false, false, "upper({0})");
    private static final Map<Locale, LinguisticSort> BY_LOCALE;
    private final Locale locale;
    private final java.text.Collator collator;
    private final String[] alphabet;
    private final String highValue;
    private final boolean reverseSecondary;
    private final boolean hasDoubleWidth;
    private final String collationKeySql;
    private final OracleUpperTable upper;
    private static final char[][] DOUBLE_TO_SINGLE;
    private static final boolean IS_MULTI_LINGUAL = true;
    private static final /* synthetic */ LinguisticSort[] $VALUES;

    public static LinguisticSort[] values() {
        return (LinguisticSort[])$VALUES.clone();
    }

    public static LinguisticSort valueOf(String name) {
        return Enum.valueOf(LinguisticSort.class, name);
    }

    private static Map<Locale, LinguisticSort> getByLocaleInfo() {
        HashMap<Locale, LinguisticSort> byLocaleInfo = new HashMap<Locale, LinguisticSort>(64);
        for (LinguisticSort sort : LinguisticSort.values()) {
            LinguisticSort duplicated = byLocaleInfo.put(sort.getLocale(), sort);
            assert (duplicated == null) : "Two linguistic sorts with the same locale: " + sort.getLocale();
        }
        return Collections.unmodifiableMap(byLocaleInfo);
    }

    public static LinguisticSort get(Locale locale) {
        LinguisticSort sort = BY_LOCALE.get(locale);
        if (sort != null) {
            return sort;
        }
        if (locale.getVariant().length() > 0) {
            if ("zh".equals(locale.getLanguage()) && !"".equals(locale.getLanguage())) {
                return LinguisticSort.get(new Locale(locale.getLanguage(), "", locale.getVariant()));
            }
            return LinguisticSort.get(new Locale(locale.getLanguage(), locale.getLanguage()));
        }
        if (locale.getCountry().length() > 0 && (sort = BY_LOCALE.get(new Locale(locale.getLanguage()))) != null) {
            return sort;
        }
        return ENGLISH;
    }

    private LinguisticSort(Locale locale, String highValue, boolean reverseSecondary, boolean hasDoubleWidth, String collationKeySql) {
        this(locale, LinguisticSort.getAlphabetFromICU(locale), highValue, reverseSecondary, hasDoubleWidth, collationKeySql);
    }

    private LinguisticSort(Locale locale, String[] alphabet, String highValue, boolean reverseSecondary, boolean hasDoubleWidth, String collationKeySql) {
        this.locale = locale;
        this.alphabet = alphabet;
        this.highValue = highValue;
        assert (this.highValue == null || this.highValue.length() == 1);
        this.reverseSecondary = reverseSecondary;
        this.hasDoubleWidth = hasDoubleWidth;
        this.collationKeySql = collationKeySql;
        this.collator = Icu4jCollatorOverrides.OVERRIDES.containsKey(this.locale) ? CollatorICU.wrap((Collator)Collator.getInstance((ULocale)ULocale.forLanguageTag((String)Icu4jCollatorOverrides.OVERRIDES.get(this.locale)))) : (this.locale.getVariant().length() > 0 ? CollatorICU.wrap((Collator)Collator.getInstance((ULocale)ULocale.forLocale((Locale)this.locale))) : java.text.Collator.getInstance(this.locale));
        this.collator.setStrength(1);
        this.upper = OracleUpperTable.forLinguisticSort(this.name());
    }

    public java.text.Collator getCollator() {
        return (java.text.Collator)this.collator.clone();
    }

    public java.text.Collator getGuaranteedCaseInsensitiveCollator() {
        java.text.Collator collator = this.getCollator();
        if ("da".equals(this.locale.getLanguage())) {
            collator.setStrength(0);
        }
        return collator;
    }

    Locale getLocale() {
        return this.locale;
    }

    @SuppressWarnings(value={"unchecked"})
    public Comparator<String> getNonCachingComparator() {
        return (Comparator)this.collator.clone();
    }

    public Comparator<String> getComparator(int size) {
        return new CollatingComparator(this.getCollator(), size);
    }

    public int getAlphabetLength() {
        return this.alphabet.length;
    }

    public String getAlphabet(int index) {
        return this.alphabet[index];
    }

    String[] getAlphabet() {
        return this.alphabet;
    }

    public int getRolodexIndexForChar(String searchTerm) {
        if (searchTerm == null || searchTerm.length() != 1) {
            throw new IllegalArgumentException("Must be a one-length string");
        }
        if (this.getAlphabetLength() == 0) {
            return -1;
        }
        for (int i = 0; i < this.getAlphabetLength(); ++i) {
            int comparison = this.collator.compare(searchTerm, this.getAlphabet(i));
            if (comparison < 0) {
                return i == 0 ? this.getAlphabetLength() : i - 1;
            }
            if (comparison != 0) continue;
            return i;
        }
        return this.getAlphabetLength();
    }

    public String getUpperCaseSql(String expr, boolean isPostgres) {
        if (isPostgres) {
            return "icu_upper(" + expr + ",'" + this.locale.toString() + "')";
        }
        return this.upper.getSql(expr);
    }

    public boolean usesUpperToGetUpperCase(boolean isPostgres) {
        return !isPostgres && "upper(x)".equals(this.upper.getSql("x"));
    }

    public String getUpperCaseValue(String value, boolean isPostgres) {
        String singleWidth = value;
        if (this.hasDoubleWidth) {
            singleWidth = LinguisticSort.toSingleWidth(value);
        }
        if (isPostgres) {
            return singleWidth.toUpperCase(this.locale);
        }
        return this.upper.toUpperCase(singleWidth);
    }

    public static char toSingleWidth(char c) {
        char[] cBucket = DOUBLE_TO_SINGLE[c >> 8];
        if (cBucket == null) {
            return c;
        }
        char cSingle = cBucket[c & 0xFF];
        if (cSingle == '\u0000') {
            return c;
        }
        return cSingle;
    }

    public static String toSingleWidth(String value) {
        int n = value.length();
        DeferredStringBuilder buf = new DeferredStringBuilder(value);
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            buf.append(LinguisticSort.toSingleWidth(c));
        }
        return buf.toString();
    }

    public String getCollationKeySql(String expr, boolean isPostgres) {
        if (isPostgres) {
            return "icu_sortkey(" + expr + ",'" + this.locale.toString() + "')::text";
        }
        return MessageFormat.format(this.collationKeySql, expr);
    }

    public String getUpperCollationKeySql(String expr, boolean isPostgres) {
        if (!isPostgres && String.format(this.upper.getSqlFormatString(), "{0}").equals(this.collationKeySql)) {
            return this.getCollationKeySql(expr, false);
        }
        return this.getCollationKeySql(this.getUpperCaseSql(expr, isPostgres), isPostgres);
    }

    private String formatLetter(String letter, boolean isPostgres) {
        return this.getCollationKeySql('\'' + letter + '\'', isPostgres);
    }

    static String[] getAlphabetFromICU(Locale locale) {
        AlphabeticIndex index = new AlphabeticIndex(locale);
        List alphabet = index.getBucketLabels();
        if (alphabet.size() > 6) {
            List alphabetWithoutEllipses = alphabet.subList(1, alphabet.size() - 1);
            return alphabetWithoutEllipses.toArray(new String[alphabetWithoutEllipses.size()]);
        }
        return new String[0];
    }

    public java.text.Collator getUpperCaseCollator(final boolean isPostgres) {
        final java.text.Collator innerCollator = this.getCollator();
        if (!isPostgres && this.getLocale() == Locale.ENGLISH) {
            innerCollator.setStrength(1);
            return new java.text.Collator(){

                @Override
                public int compare(String source, String target) {
                    return innerCollator.compare(this.getUpperCaseIfNeeded(source), this.getUpperCaseIfNeeded(target));
                }

                private String getUpperCaseIfNeeded(String string) {
                    for (int i = 0; i < string.length(); ++i) {
                        char ch = string.charAt(i);
                        if (ch <= '\u007f') continue;
                        return LinguisticSort.this.getUpperCaseValue(string, false);
                    }
                    return string;
                }

                @Override
                public CollationKey getCollationKey(String source) {
                    return innerCollator.getCollationKey(this.getUpperCaseIfNeeded(source));
                }

                @Override
                public int hashCode() {
                    return LinguisticSort.this.hashCode();
                }

                @Override
                public boolean equals(Object that) {
                    return super.equals(that);
                }
            };
        }
        return new java.text.Collator(){

            @Override
            public int compare(String source, String target) {
                return innerCollator.compare(LinguisticSort.this.getUpperCaseValue(source, isPostgres), LinguisticSort.this.getUpperCaseValue(target, isPostgres));
            }

            @Override
            public CollationKey getCollationKey(String source) {
                return innerCollator.getCollationKey(LinguisticSort.this.getUpperCaseValue(source, isPostgres));
            }

            @Override
            public int hashCode() {
                return LinguisticSort.this.hashCode();
            }

            @Override
            public boolean equals(Object that) {
                return super.equals(that);
            }
        };
    }

    static {
        $VALUES = new LinguisticSort[]{ENGLISH, GERMAN, FRENCH, ITALIAN, SPANISH, CATALAN, DUTCH, PORTUGUESE, DANISH, NORWEGIAN, SWEDISH, FINNISH, CZECH, POLISH, TURKISH, CHINESE_HK, CHINESE_HK_STROKE, CHINESE_TW, CHINESE_TW_STROKE, CHINESE, CHINESE_STROKE, CHINESE_PINYIN, JAPANESE, KOREAN, RUSSIAN, BULGARIAN, INDONESIAN, ROMANIAN, VIETNAMESE, UKRAINIAN, HUNGARIAN, GREEK, HEBREW, SLOVAK, SERBIAN_CYRILLIC, SERBIAN_LATIN, BOSNIAN, GEORGIAN, BASQUE, MALTESE, ROMANSH, LUXEMBOURGISH, IRISH, SLOVENE, CROATIAN, MALAY, ARABIC, ESTONIAN, ICELANDIC, LATVIAN, LITHUANIAN, KYRGYZ, KAZAKH, TAJIK, BELARUSIAN, TURKMEN, AZERBAIJANI, ARMENIAN, THAI, HINDI, URDU, BENGALI, TAMIL, ESPERANTO};
        BY_LOCALE = LinguisticSort.getByLocaleInfo();
        DOUBLE_TO_SINGLE = new char[256][];
        LinguisticSort.DOUBLE_TO_SINGLE[32] = new char[256];
        LinguisticSort.DOUBLE_TO_SINGLE[32][24] = 96;
        LinguisticSort.DOUBLE_TO_SINGLE[32][25] = 39;
        LinguisticSort.DOUBLE_TO_SINGLE[32][29] = 34;
        LinguisticSort.DOUBLE_TO_SINGLE[34] = new char[256];
        LinguisticSort.DOUBLE_TO_SINGLE[34][60] = 126;
        LinguisticSort.DOUBLE_TO_SINGLE[48] = new char[256];
        LinguisticSort.DOUBLE_TO_SINGLE[48][0] = 32;
        LinguisticSort.DOUBLE_TO_SINGLE[254] = new char[256];
        LinguisticSort.DOUBLE_TO_SINGLE[254][63] = 94;
        LinguisticSort.DOUBLE_TO_SINGLE[255] = new char[256];
        LinguisticSort.DOUBLE_TO_SINGLE[255][1] = 33;
        LinguisticSort.DOUBLE_TO_SINGLE[255][3] = 35;
        LinguisticSort.DOUBLE_TO_SINGLE[255][4] = 36;
        LinguisticSort.DOUBLE_TO_SINGLE[255][5] = 37;
        LinguisticSort.DOUBLE_TO_SINGLE[255][6] = 38;
        LinguisticSort.DOUBLE_TO_SINGLE[255][8] = 40;
        LinguisticSort.DOUBLE_TO_SINGLE[255][9] = 41;
        LinguisticSort.DOUBLE_TO_SINGLE[255][10] = 42;
        LinguisticSort.DOUBLE_TO_SINGLE[255][11] = 43;
        LinguisticSort.DOUBLE_TO_SINGLE[255][12] = 44;
        LinguisticSort.DOUBLE_TO_SINGLE[255][13] = 45;
        LinguisticSort.DOUBLE_TO_SINGLE[255][14] = 46;
        LinguisticSort.DOUBLE_TO_SINGLE[255][15] = 47;
        LinguisticSort.DOUBLE_TO_SINGLE[255][16] = 48;
        LinguisticSort.DOUBLE_TO_SINGLE[255][17] = 49;
        LinguisticSort.DOUBLE_TO_SINGLE[255][18] = 50;
        LinguisticSort.DOUBLE_TO_SINGLE[255][19] = 51;
        LinguisticSort.DOUBLE_TO_SINGLE[255][20] = 52;
        LinguisticSort.DOUBLE_TO_SINGLE[255][21] = 53;
        LinguisticSort.DOUBLE_TO_SINGLE[255][22] = 54;
        LinguisticSort.DOUBLE_TO_SINGLE[255][23] = 55;
        LinguisticSort.DOUBLE_TO_SINGLE[255][24] = 56;
        LinguisticSort.DOUBLE_TO_SINGLE[255][25] = 57;
        LinguisticSort.DOUBLE_TO_SINGLE[255][26] = 58;
        LinguisticSort.DOUBLE_TO_SINGLE[255][27] = 59;
        LinguisticSort.DOUBLE_TO_SINGLE[255][28] = 60;
        LinguisticSort.DOUBLE_TO_SINGLE[255][29] = 61;
        LinguisticSort.DOUBLE_TO_SINGLE[255][30] = 62;
        LinguisticSort.DOUBLE_TO_SINGLE[255][31] = 63;
        LinguisticSort.DOUBLE_TO_SINGLE[255][32] = 64;
        LinguisticSort.DOUBLE_TO_SINGLE[255][33] = 65;
        LinguisticSort.DOUBLE_TO_SINGLE[255][34] = 66;
        LinguisticSort.DOUBLE_TO_SINGLE[255][35] = 67;
        LinguisticSort.DOUBLE_TO_SINGLE[255][36] = 68;
        LinguisticSort.DOUBLE_TO_SINGLE[255][37] = 69;
        LinguisticSort.DOUBLE_TO_SINGLE[255][38] = 70;
        LinguisticSort.DOUBLE_TO_SINGLE[255][39] = 71;
        LinguisticSort.DOUBLE_TO_SINGLE[255][40] = 72;
        LinguisticSort.DOUBLE_TO_SINGLE[255][41] = 73;
        LinguisticSort.DOUBLE_TO_SINGLE[255][42] = 74;
        LinguisticSort.DOUBLE_TO_SINGLE[255][43] = 75;
        LinguisticSort.DOUBLE_TO_SINGLE[255][44] = 76;
        LinguisticSort.DOUBLE_TO_SINGLE[255][45] = 77;
        LinguisticSort.DOUBLE_TO_SINGLE[255][46] = 78;
        LinguisticSort.DOUBLE_TO_SINGLE[255][47] = 79;
        LinguisticSort.DOUBLE_TO_SINGLE[255][48] = 80;
        LinguisticSort.DOUBLE_TO_SINGLE[255][49] = 81;
        LinguisticSort.DOUBLE_TO_SINGLE[255][50] = 82;
        LinguisticSort.DOUBLE_TO_SINGLE[255][51] = 83;
        LinguisticSort.DOUBLE_TO_SINGLE[255][52] = 84;
        LinguisticSort.DOUBLE_TO_SINGLE[255][53] = 85;
        LinguisticSort.DOUBLE_TO_SINGLE[255][54] = 86;
        LinguisticSort.DOUBLE_TO_SINGLE[255][55] = 87;
        LinguisticSort.DOUBLE_TO_SINGLE[255][56] = 88;
        LinguisticSort.DOUBLE_TO_SINGLE[255][57] = 89;
        LinguisticSort.DOUBLE_TO_SINGLE[255][58] = 90;
        LinguisticSort.DOUBLE_TO_SINGLE[255][59] = 91;
        LinguisticSort.DOUBLE_TO_SINGLE[255][60] = 92;
        LinguisticSort.DOUBLE_TO_SINGLE[255][61] = 93;
        LinguisticSort.DOUBLE_TO_SINGLE[255][63] = 95;
        LinguisticSort.DOUBLE_TO_SINGLE[255][65] = 97;
        LinguisticSort.DOUBLE_TO_SINGLE[255][66] = 98;
        LinguisticSort.DOUBLE_TO_SINGLE[255][67] = 99;
        LinguisticSort.DOUBLE_TO_SINGLE[255][68] = 100;
        LinguisticSort.DOUBLE_TO_SINGLE[255][69] = 101;
        LinguisticSort.DOUBLE_TO_SINGLE[255][70] = 102;
        LinguisticSort.DOUBLE_TO_SINGLE[255][71] = 103;
        LinguisticSort.DOUBLE_TO_SINGLE[255][72] = 104;
        LinguisticSort.DOUBLE_TO_SINGLE[255][73] = 105;
        LinguisticSort.DOUBLE_TO_SINGLE[255][74] = 106;
        LinguisticSort.DOUBLE_TO_SINGLE[255][75] = 107;
        LinguisticSort.DOUBLE_TO_SINGLE[255][76] = 108;
        LinguisticSort.DOUBLE_TO_SINGLE[255][77] = 109;
        LinguisticSort.DOUBLE_TO_SINGLE[255][78] = 110;
        LinguisticSort.DOUBLE_TO_SINGLE[255][79] = 111;
        LinguisticSort.DOUBLE_TO_SINGLE[255][80] = 112;
        LinguisticSort.DOUBLE_TO_SINGLE[255][81] = 113;
        LinguisticSort.DOUBLE_TO_SINGLE[255][82] = 114;
        LinguisticSort.DOUBLE_TO_SINGLE[255][83] = 115;
        LinguisticSort.DOUBLE_TO_SINGLE[255][84] = 116;
        LinguisticSort.DOUBLE_TO_SINGLE[255][85] = 117;
        LinguisticSort.DOUBLE_TO_SINGLE[255][86] = 118;
        LinguisticSort.DOUBLE_TO_SINGLE[255][87] = 119;
        LinguisticSort.DOUBLE_TO_SINGLE[255][88] = 120;
        LinguisticSort.DOUBLE_TO_SINGLE[255][89] = 121;
        LinguisticSort.DOUBLE_TO_SINGLE[255][90] = 122;
        LinguisticSort.DOUBLE_TO_SINGLE[255][91] = 123;
        LinguisticSort.DOUBLE_TO_SINGLE[255][92] = 124;
        LinguisticSort.DOUBLE_TO_SINGLE[255][93] = 125;
    }

    static final class Alphabets {
        static final String[] ENGLISH = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        static final String[] CATALAN = new String[]{"A", "B", "C", "\u00c7", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        static final String[] BASQUE = new String[]{"A", "B", "C", "\u00c7", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "\u00d1", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        static final String[] JAPANESE = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "\u30a2", "\u30ab", "\u30b5", "\u30bf", "\u30ca", "\u30cf", "\u30de", "\u30e4", "\u30e9", "\u30ef"};
        static final String[] HUNGARIAN = new String[]{"A", "B", "C", "Cs", "D", "E", "F", "G", "Gy", "H", "I", "J", "K", "L", "Ly", "M", "N", "Ny", "O", "\u00d6", "P", "Q", "R", "S", "Sz", "T", "Ty", "U", "\u00dc", "V", "W", "X", "Y", "Z", "Zs"};
        static final String[] TURKISH = new String[]{"A", "B", "C", "\u00c7", "D", "E", "F", "G", "\u011e", "H", "I", "\u0130", "J", "K", "L", "M", "N", "O", "\u00d6", "P", "R", "S", "\u015e", "T", "U", "\u00dc", "V", "Y", "Z"};
        static final String[] AZERBAIJANI = new String[]{"A", "B", "C", "\u00c7", "D", "E", "\u018f", "F", "G", "\u011e", "H", "X", "I", "\u0130", "J", "K", "Q", "L", "M", "N", "O", "\u00d6", "P", "R", "S", "\u015e", "T", "U", "\u00dc", "V", "Y", "Z"};
        static final String[] BULGARIAN = new String[]{"\u0410", "\u0411", "\u0412", "\u0413", "\u0414", "\u0415", "\u0416", "\u0417", "\u0418", "\u0419", "\u041a", "\u041b", "\u041c", "\u041d", "\u041e", "\u041f", "\u0420", "\u0421", "\u0422", "\u0423", "\u0424", "\u0425", "\u0426", "\u0427", "\u0428", "\u0429", "\u042a", "\u042c", "\u042e", "\u042f"};
        static final String[] SERBIAN_LATIN = new String[]{"A", "B", "C", "\u010c", "\u0106", "D", "\u0110", "D\u017e", "E", "F", "G", "H", "I", "J", "K", "L", "Lj", "M", "N", "Nj", "O", "P", "R", "S", "\u0160", "T", "U", "V", "Z", "\u017d"};
        static final String[] SLOVAK = new String[]{"A", "\u00c1", "\u00c4", "B", "C", "\u010c", "D", "\u010e", "DZ", "D\u017d", "E", "\u00c9", "F", "G", "H", "CH", "I", "\u00cd", "J", "K", "L", "\u0139", "\u013d", "M", "N", "\u0147", "O", "\u00d3", "\u00d4", "P", "Q", "R", "\u0154", "S", "\u0160", "T", "\u0164", "U", "\u00da", "V", "W", "X", "Y", "\u00dd", "Z", "\u017d"};
        static final String[] GEORGIAN = new String[]{"\u10d0", "\u10d1", "\u10d2", "\u10d3", "\u10d4", "\u10d5", "\u10d6", "\u10d7", "\u10d8", "\u10d9", "\u10da", "\u10db", "\u10dc", "\u10dd", "\u10de", "\u10df", "\u10e0", "\u10e1", "\u10e2", "\u10e3", "\u10e4", "\u10e5", "\u10e6", "\u10e7", "\u10e8", "\u10e9", "\u10ea", "\u10eb", "\u10ec", "\u10ed", "\u10ee", "\u10ef", "\u10f0"};
        static final String[] ESTONIAN = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "\u0160", "Z", "\u017d", "T", "U", "V", "W", "\u00d5", "\u00c4", "\u00d6", "\u00dc", "X", "Y"};
        static final String[] ICELANDIC = new String[]{"A", "\u00c1", "B", "D", "\u00d0", "E", "\u00c9", "F", "G", "H", "I", "\u00cd", "J", "K", "L", "M", "N", "O", "\u00d3", "P", "R", "S", "T", "U", "\u00da", "V", "X", "Y", "\u00dd", "\u00de", "\u00c6", "\u00d6"};
        static final String[] LATVIAN = new String[]{"A", "\u0100", "B", "C", "\u010c", "D", "E", "\u0112", "F", "G", "\u0122", "H", "I", "\u012a", "J", "K", "\u0136", "L", "\u013b", "M", "N", "\u0145", "O", "P", "R", "S", "\u0160", "T", "U", "\u016a", "V", "Z", "\u017d"};
        static final String[] LUXEMBOURGISH = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "\u00c4", "\u00cb", "\u00c9"};
        static final String[] KYRGYZ = new String[]{"\u0410", "\u0411", "\u0412", "\u0413", "\u0414", "\u0415", "\u0401", "\u0416", "\u0417", "\u0418", "\u0419", "\u041a", "\u041b", "\u041c", "\u041d", "\u04a2", "\u041e", "\u04e8", "\u041f", "\u0420", "\u0421", "\u0422", "\u0423", "\u04ae", "\u0424", "\u0425", "\u0426", "\u0427", "\u0428", "\u0429", "\u042a", "\u042b", "\u042c", "\u042d", "\u042e", "\u042f"};
        static final String[] KAZAKH = new String[]{"\u0410", "\u04d8", "\u0411", "\u0412", "\u0413", "\u0492", "\u0414", "\u0415", "\u0401", "\u0416", "\u0417", "\u0418", "\u0419", "\u041a", "\u049a", "\u041b", "\u041c", "\u041d", "\u04a2", "\u041e", "\u04e8", "\u041f", "\u0420", "\u0421", "\u0422", "\u0423", "\u04b0", "\u04ae", "\u0424", "\u0425", "\u04ba", "\u0426", "\u0427", "\u0428", "\u0429", "\u042a", "\u042b", "\u0406", "\u042c", "\u042d", "\u042e", "\u042f"};
        static final String[] TAJIK = new String[]{"\u0410", "\u0411", "\u0412", "\u0413", "\u0492", "\u0414", "\u0415", "\u0401", "\u0416", "\u0417", "\u0418", "\u04e2", "\u0419", "\u041a", "\u049a", "\u041b", "\u041c", "\u041d", "\u041e", "\u041f", "\u0420", "\u0421", "\u0422", "\u0423", "\u04ee", "\u0424", "\u0425", "\u04b2", "\u0427", "\u04b6", "\u0428", "\u042a", "\u042d", "\u042e", "\u042f"};
        static final String[] URDU = new String[]{"\u0627", "\u0622", "\u0628", "\u067e", "\u062a", "\u0679", "\u062b", "\u062c", "\u0686", "\u062d", "\u062e", "\u062f", "\u0688", "\u0630", "\u0631", "\u0691", "\u0632", "\u0698", "\u0633", "\u0634", "\u0635", "\u0636", "\u0637", "\u0638", "\u0639", "\u063a", "\u0641", "\u0642", "\u06a9", "\u06af", "\u0644", "\u0645", "\u0646", "\u0648", "\u06d5", "\u06be", "\u06f6", "\u0649", "\u06d2"};
        static final String[] GERMAN = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        static final String[] BENGALI = new String[]{"\u0995", "\u0996", "\u0997", "\u0998", "\u0999", "\u099a", "\u099b", "\u099c", "\u099d", "\u099e", "\u099f", "\u09a0", "\u09a1", "\u09a2", "\u09a3", "\u09a4", "\u09a6", "\u09a7", "\u09a8", "\u09aa", "\u09ab", "\u09ac", "\u09ad", "\u09ae", "\u09af", "\u09b0", "\u09b2", "\u09b6", "\u09b7", "\u09b8", "\u09b9", "\u09af\u09bc", "\u09a1\u09bc", "\u09a2", "\u0985", "\u0986", "\u0987", "\u0988", "\u0989", "\u098a", "\u098b", "\u09e0", "\u098f", "\u0990", "\u0993", "\u0994"};
        static final String[] LITHUANIAN = new String[]{"A", "\u0104", "B", "C", "\u010c", "D", "E", "\u0118", "\u0116", "F", "G", "H", "I", "\u012e", "Y", "J", "K", "L", "M", "N", "O", "P", "R", "S", "\u0160", "T", "U", "\u0172", "\u016a", "V", "Z", "\u017d"};
        static final String[] SLOVENE = new String[]{"A", "B", "C", "\u010c", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "R", "S", "\u0160", "T", "U", "V", "Z", "\u017d"};
        static final String[] TAMIL = new String[]{"\u0b85", "\u0b86", "\u0b87", "\u0b88", "\u0b89", "\u0b8a", "\u0b8e", "\u0b8f", "\u0b90", "\u0b92", "\u0b93", "\u0b94", "\u0b95", "\u0b99", "\u0b9a", "\u0b9c", "\u0b9e", "\u0b9f", "\u0ba3", "\u0ba4", "\u0ba8", "\u0ba9", "\u0baa", "\u0bae", "\u0baf", "\u0bb0", "\u0bb1", "\u0bb2", "\u0bb3", "\u0bb4", "\u0bb5", "\u0bb6", "\u0bb7", "\u0bb8", "\u0bb9"};
        static final String STRING = "upper({0})";
        static final String[] JAPANESE_ROLODEX = new String[]{"unistr('\\3041')", "unistr('\\30F5')", "unistr('\\3055')", "unistr('\\305F')", "unistr('\\306A')", "unistr('\\306F')", "unistr('\\307E')", "unistr('\\3084')", "unistr('\\3089')", "unistr('\\308E')", "unistr('\\309D')"};
        static final String[] JAPANESE_ROLODEX_JAVA = new String[]{"\u3041", "\u30f5", "\u3055", "\u305f", "\u306a", "\u306f", "\u307e", "\u3084", "\u3089", "\u308e", "\u3001"};

        Alphabets() {
        }
    }

    static class CollatingComparator
    implements Comparator<String> {
        private final java.text.Collator collator;
        private final Map<String, CollationKey> cKeyMap;

        CollatingComparator(java.text.Collator collator) {
            this(collator, 16);
        }

        CollatingComparator(java.text.Collator collator, int defaultSize) {
            this.collator = collator;
            this.cKeyMap = new HashMap<String, CollationKey>(defaultSize);
        }

        @Override
        @SuppressWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="Reference comparison used for performance improvement.")
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 == null) {
                return -1;
            }
            return this.getCollationKey(o1).compareTo(this.getCollationKey(o2));
        }

        private CollationKey getCollationKey(String comp) {
            CollationKey key = this.cKeyMap.get(comp);
            if (key == null) {
                key = this.collator.getCollationKey(comp);
                this.cKeyMap.put(comp, key);
            }
            return key;
        }
    }

    private static final class Icu4jCollatorOverrides {
        static final Map<Locale, String> OVERRIDES = Icu4jCollatorOverrides.getIcu4jCollatorOverrides();

        private Icu4jCollatorOverrides() {
        }

        private static Map<Locale, String> getIcu4jCollatorOverrides() {
            HashMap<Locale, String> overrides = new HashMap<Locale, String>(7);
            overrides.put(new Locale("zh", "HK"), "zh-HK-u-co-unihan");
            overrides.put(new Locale("zh", "HK", "STROKE"), "zh-HK-u-co-stroke");
            overrides.put(new Locale("zh", "TW"), "zh-TW-u-co-unihan");
            overrides.put(new Locale("zh", "TW", "STROKE"), "zh-TW-u-co-stroke");
            overrides.put(new Locale("zh"), "zh-CN-u-co-unihan");
            overrides.put(new Locale("zh", "", "STROKE"), "zh-CN-u-co-stroke");
            overrides.put(new Locale("zh", "", "PINYIN"), "zh-CN-u-co-pinyin");
            return Collections.unmodifiableMap(overrides);
        }
    }
}

