/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.i18n;

import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.phoenix.thirdparty.com.google.common.base.Splitter;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

public enum LocaleUtils {
    INSTANCE;

    private static final ConcurrentMap<Locale, Locale> UNIQUE_LOCALE_MAP;

    public static LocaleUtils get() {
        return INSTANCE;
    }

    public Locale getLocaleByIsoCode(String isoCode) {
        if (isoCode == null) {
            return null;
        }
        if (isoCode.length() == 2) {
            return LocaleUtils.uniqueifyLocale(new Locale(isoCode));
        }
        if (isoCode.length() == 5) {
            String countryIsoCode = isoCode.substring(3, 5);
            String langIsoCode = isoCode.substring(0, 2);
            return LocaleUtils.uniqueifyLocale(new Locale(langIsoCode, countryIsoCode));
        }
        ArrayList split = Lists.newArrayList((Iterable)Splitter.on((char)'_').split((CharSequence)isoCode));
        String language = (String)split.get(0);
        String country = split.size() > 1 ? (String)split.get(1) : "";
        String variant = split.size() > 2 ? (String)split.get(2) : "";
        return LocaleUtils.uniqueifyLocale(new Locale(language, country, variant));
    }

    static Locale uniqueifyLocale(Locale value) {
        if (value == null) {
            return null;
        }
        Locale oldValue = (Locale)UNIQUE_LOCALE_MAP.get(value);
        if (oldValue != null) {
            return oldValue;
        }
        UNIQUE_LOCALE_MAP.put(value, value);
        return value;
    }

    static {
        UNIQUE_LOCALE_MAP = new ConcurrentHashMap<Locale, Locale>(64, 0.75f, 2);
    }
}

