/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.metastore.Metastore;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.components.views.Views;
import org.apache.drill.metastore.rdbms.QueryExecutorProvider;
import org.apache.drill.metastore.rdbms.components.tables.RdbmsTables;
import org.apache.drill.metastore.rdbms.exception.RdbmsMetastoreException;
import org.apache.drill.metastore.rdbms.util.DbHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsMetastore
implements Metastore {
    private static final Logger logger = LoggerFactory.getLogger(RdbmsMetastore.class);
    private static final String LIQUIBASE_CHANGELOG_FILE = "db/changelog/changelog.yaml";
    private final QueryExecutorProvider executorProvider;

    public RdbmsMetastore(DrillConfig config) {
        HikariDataSource dataSource = this.dataSource(config);
        this.executorProvider = new QueryExecutorProvider(dataSource);
        this.initTables((DataSource)dataSource);
    }

    public Tables tables() {
        return new RdbmsTables(this.executorProvider);
    }

    public Views views() {
        throw new UnsupportedOperationException("Views metadata support is not implemented");
    }

    public void close() {
        this.executorProvider.close();
    }

    private HikariDataSource dataSource(DrillConfig config) {
        DbHelper.init(config).prepareDatabase();
        try {
            Properties properties = new Properties();
            if (config.hasPath("drill.metastore.rdbms.data_source.properties")) {
                Config propertiesConfig = config.getConfig("drill.metastore.rdbms.data_source.properties");
                propertiesConfig.entrySet().forEach(e -> properties.put(e.getKey(), ((ConfigValue)e.getValue()).unwrapped()));
            }
            HikariConfig hikariConfig = new HikariConfig(properties);
            hikariConfig.setDriverClassName(config.getString("drill.metastore.rdbms.data_source.driver"));
            hikariConfig.setJdbcUrl(config.getString("drill.metastore.rdbms.data_source.url"));
            if (config.hasPath("drill.metastore.rdbms.data_source.username")) {
                hikariConfig.setUsername(config.getString("drill.metastore.rdbms.data_source.username"));
            }
            if (config.hasPath("drill.metastore.rdbms.data_source.password")) {
                hikariConfig.setPassword(config.getString("drill.metastore.rdbms.data_source.password"));
            }
            return new HikariDataSource(hikariConfig);
        }
        catch (RuntimeException e2) {
            throw new RdbmsMetastoreException("Unable to init RDBMS Metastore data source: " + e2.getMessage(), e2);
        }
    }

    private void initTables(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            JdbcConnection jdbcConnection = new JdbcConnection(connection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor();
            try (Liquibase liquibase = new Liquibase(LIQUIBASE_CHANGELOG_FILE, (ResourceAccessor)resourceAccessor, database);){
                liquibase.update("");
            }
        }
        catch (Exception e) {
            throw new RdbmsMetastoreException("Unable to init Metastore tables using Liquibase: " + e.getMessage(), e);
        }
    }
}

