/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.metastore.rdbms.exception.RdbmsMetastoreException;
import org.jooq.SQLDialect;
import org.jooq.tools.jdbc.JDBCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DbHelper {
    public static DbHelper init(DrillConfig config) {
        SQLDialect dialect = JDBCUtils.dialect((String)config.getString("drill.metastore.rdbms.data_source.url"));
        switch (dialect) {
            case SQLITE: {
                return new SQLiteHelper(config);
            }
        }
        return NoOpHelper.get();
    }

    public void prepareDatabase();

    public static class SQLiteHelper
    implements DbHelper {
        private static final Logger logger = LoggerFactory.getLogger(SQLiteHelper.class);
        private final DrillConfig config;

        public SQLiteHelper(DrillConfig config) {
            this.config = config;
        }

        @Override
        public void prepareDatabase() {
            if (this.config.hasPath("drill.metastore.rdbms.database.sqlite.path.create") && this.config.hasPath("drill.metastore.rdbms.database.sqlite.path.value") && this.config.getBoolean("drill.metastore.rdbms.database.sqlite.path.create")) {
                String path = this.config.getString("drill.metastore.rdbms.database.sqlite.path.value");
                try {
                    Path dbPath = Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
                    logger.info("Configured SQLite database path: {}", (Object)dbPath);
                }
                catch (IOException e) {
                    throw new RdbmsMetastoreException(String.format("Unable to create SQLite database path [%s]: %s. Optionally, path can be created manually and [%s] set to false in %s.", path, e.getMessage(), "drill.metastore.rdbms.database.sqlite.path.create", "drill-metastore-override.conf"), e);
                }
            }
        }
    }

    public static class NoOpHelper
    implements DbHelper {
        private static final NoOpHelper INSTANCE = new NoOpHelper();

        public static NoOpHelper get() {
            return INSTANCE;
        }

        @Override
        public void prepareDatabase() {
        }
    }
}

