/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillException;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.ClientConnection;
import org.apache.drill.exec.rpc.NonTransientRpcException;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionMultiListener<T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite, BC extends BasicClient<T, CC, HS, HR>> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionMultiListener.class);
    private final RpcConnectionHandler<CC> connectionListener;
    private final HS handshakeValue;
    private final BC parent;
    ConnectionHandler connectionHandler = null;
    private HandshakeSendHandler handshakeSendHandler = null;
    private SSLConnectionHandler sslConnectionHandler = null;

    private ConnectionMultiListener(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, BC basicClient) {
        assert (connectionListener != null);
        assert (handshakeValue != null);
        this.connectionListener = connectionListener;
        this.handshakeValue = handshakeValue;
        this.parent = basicClient;
    }

    public static <T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite, BC extends BasicClient<T, CC, HS, HR>> Builder<T, CC, HS, HR, BC> newBuilder(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, BC basicClient) {
        return new Builder(connectionListener, handshakeValue, basicClient);
    }

    private class ConnectionHandler
    implements GenericFutureListener<ChannelFuture> {
        private ConnectionHandler() {
        }

        public void operationComplete(ChannelFuture future) {
            boolean isInterrupted = false;
            long remainingWaitTimeMills = 120000L;
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    future.get(remainingWaitTimeMills, TimeUnit.MILLISECONDS);
                    if (future.isSuccess()) {
                        SocketAddress remote = future.channel().remoteAddress();
                        SocketAddress local = future.channel().localAddress();
                        ((RpcBus)ConnectionMultiListener.this.parent).setAddresses(remote, local);
                        if (((BasicClient)ConnectionMultiListener.this.parent).isSslEnabled()) break;
                        ((BasicClient)ConnectionMultiListener.this.parent).send(ConnectionMultiListener.this.handshakeSendHandler, ConnectionMultiListener.this.handshakeValue, true, new ByteBuf[0]);
                        break;
                    }
                    ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, (Throwable)((Object)new RpcException("General connection failure.")));
                }
                catch (InterruptedException interruptEx) {
                    startTime = System.currentTimeMillis();
                    isInterrupted = true;
                    if ((remainingWaitTimeMills -= System.currentTimeMillis() - startTime) >= 1L) continue;
                    ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, interruptEx);
                }
                catch (Exception ex) {
                    logger.error("Failed to establish connection", (Throwable)ex);
                    ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                }
                break;
            }
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class HandshakeSendHandler
    implements RpcOutcomeListener<HR> {
        private HandshakeSendHandler() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.debug("Failure while initiating handshake", (Throwable)((Object)ex));
            ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, (Throwable)((Object)ex));
        }

        @Override
        public void success(HR value, ByteBuf buffer) {
            try {
                List<String> serverAuthMechanisms = ((BasicClient)ConnectionMultiListener.this.parent).validateHandshake(value);
                ((BasicClient)ConnectionMultiListener.this.parent).finalizeConnection(value, ((BasicClient)ConnectionMultiListener.this.parent).connection);
                if (serverAuthMechanisms != null) {
                    ((BasicClient)ConnectionMultiListener.this.parent).prepareSaslHandshake(ConnectionMultiListener.this.connectionListener, serverAuthMechanisms);
                } else {
                    ConnectionMultiListener.this.connectionListener.connectionSucceeded(((BasicClient)ConnectionMultiListener.this.parent).connection);
                    logger.debug("Handshake completed successfully.");
                }
            }
            catch (NonTransientRpcException ex) {
                logger.error("Failure while validating client and server sasl compatibility", (Throwable)((Object)ex));
                ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.AUTHENTICATION, (Throwable)((Object)ex));
            }
            catch (Throwable t) {
                logger.error("Failure while validating handshake", t);
                ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_VALIDATION, t);
            }
        }

        @Override
        public void interrupted(InterruptedException ex) {
            logger.warn("Interrupted while waiting for handshake response", (Throwable)ex);
            ConnectionMultiListener.this.connectionListener.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
        }
    }

    private class SSLConnectionHandler
    implements GenericFutureListener<Future<Channel>> {
        private SSLConnectionHandler() {
        }

        public void operationComplete(Future<Channel> future) {
            ((BasicClient)ConnectionMultiListener.this.parent).send(ConnectionMultiListener.this.handshakeSendHandler, ConnectionMultiListener.this.handshakeValue, true, new ByteBuf[0]);
        }
    }

    public static class Builder<T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite, BC extends BasicClient<T, CC, HS, HR>> {
        private final RpcConnectionHandler<CC> connectionListener;
        private final HS handshakeValue;
        private final BC basicClient;
        boolean enableSSL = false;
        private ConnectionMultiListener<T, CC, HS, HR, BC> cml;

        private Builder(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, BC basicClient) {
            this.connectionListener = connectionListener;
            this.handshakeValue = handshakeValue;
            this.basicClient = basicClient;
        }

        Builder<T, CC, HS, HR, BC> enableSSL() {
            this.enableSSL = true;
            return this;
        }

        public ConnectionMultiListener<T, CC, HS, HR, BC> build() {
            this.cml = new ConnectionMultiListener(this.connectionListener, this.handshakeValue, this.basicClient);
            this.cml.connectionHandler = this.cml.new ConnectionHandler();
            this.cml.handshakeSendHandler = this.cml.new HandshakeSendHandler();
            if (this.enableSSL) {
                this.cml.sslConnectionHandler = this.cml.new SSLConnectionHandler();
            }
            return this.cml;
        }
    }

    public static class SSLHandshakeListener
    implements GenericFutureListener<Future<Channel>> {
        ConnectionMultiListener parent;

        SSLHandshakeListener() {
        }

        public void setParent(ConnectionMultiListener cml) {
            this.parent = cml;
        }

        public void operationComplete(Future<Channel> future) throws Exception {
            if (this.parent != null) {
                if (!future.isSuccess()) {
                    throw new DrillException("SSL handshake failed.", future.cause());
                }
            } else {
                throw new RpcException("RPC Setup error. SSL handshake complete handler is not set up.");
            }
            Channel c = (Channel)future.get();
            this.parent.sslConnectionHandler.operationComplete(future);
            ((BasicClient)this.parent.parent).setSslChannel(c);
        }
    }
}

