/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.security;

import java.util.HashMap;
import java.util.Map;

public final class SaslProperties {
    public static Map<String, String> getSaslProperties(boolean encryptionEnabled, int wrappedChunkSize) {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        if (encryptionEnabled) {
            saslProps.put("javax.security.sasl.strength", "high");
            saslProps.put("javax.security.sasl.qop", QualityOfProtection.PRIVACY.getSaslQop());
            saslProps.put("javax.security.sasl.maxbuffer", Integer.toString(wrappedChunkSize));
            saslProps.put("javax.security.sasl.policy.noplaintext", "true");
        } else {
            saslProps.put("javax.security.sasl.qop", QualityOfProtection.AUTHENTICATION.getSaslQop());
        }
        return saslProps;
    }

    private SaslProperties() {
    }

    static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        public final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }
    }
}

