/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import org.apache.ws.commons.schema.docpath.XmlSchemaDocumentNode;
import org.apache.ws.commons.schema.docpath.XmlSchemaStateMachineNode;

public final class XmlSchemaPathNode<U, V> {
    private Direction direction;
    private XmlSchemaDocumentNode<U> documentNode;
    private XmlSchemaStateMachineNode stateMachineNode;
    private int nextNodeStateIndex;
    private int iterationNum;
    private V userDefinedContent;
    private XmlSchemaPathNode<U, V> prevNode;
    private XmlSchemaPathNode<U, V> nextNode;

    XmlSchemaPathNode(Direction dir, XmlSchemaPathNode<U, V> previous, XmlSchemaDocumentNode<U> node) {
        this.update(dir, previous, node);
    }

    XmlSchemaPathNode(Direction dir, XmlSchemaPathNode<U, V> previous, XmlSchemaStateMachineNode stateMachine) {
        this.update(dir, previous, stateMachine);
    }

    public XmlSchemaDocumentNode<U> getDocumentNode() {
        return this.documentNode;
    }

    public XmlSchemaStateMachineNode getStateMachineNode() {
        return this.stateMachineNode;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getIteration() {
        return this.iterationNum;
    }

    public long getMinOccurs() {
        return this.stateMachineNode.getMinOccurs();
    }

    public long getMaxOccurs() {
        return this.stateMachineNode.getMaxOccurs();
    }

    public int getDocIteration() {
        if (this.documentNode == null) {
            return 0;
        }
        return this.documentNode.getIteration();
    }

    public XmlSchemaPathNode<U, V> getPrevious() {
        return this.prevNode;
    }

    public XmlSchemaPathNode<U, V> getNext() {
        return this.nextNode;
    }

    int getIndexOfNextNodeState() {
        return this.nextNodeStateIndex;
    }

    int getDocSequencePosition() {
        if (this.documentNode == null) {
            return 0;
        }
        return this.documentNode.getSequencePosition();
    }

    void setIteration(int newIteration) {
        if (newIteration < 1) {
            throw new IllegalArgumentException("The new iteration must be at least one, not " + newIteration + '.');
        }
        if (this.stateMachineNode.getMaxOccurs() < (long)newIteration) {
            throw new IllegalStateException("The new iteration for " + this.stateMachineNode + " of " + newIteration + " is greater than the maximum of " + this.stateMachineNode.getMaxOccurs() + '.');
        }
        this.iterationNum = newIteration;
    }

    void setDocumentNode(XmlSchemaDocumentNode<U> docNode) {
        if (docNode.getStateMachineNode() != this.stateMachineNode) {
            throw new IllegalArgumentException("The document node's state machine (" + docNode.getStateMachineNode() + ") must use the same state machine node as this path node (" + this.stateMachineNode + ").");
        }
        this.documentNode = docNode;
    }

    void setNextNode(int nextNodeIndex, XmlSchemaPathNode<U, V> newNext) {
        if (nextNodeIndex != -1 || newNext != null && !newNext.getDirection().equals((Object)Direction.CONTENT) && !newNext.getDirection().equals((Object)Direction.PARENT) && !newNext.getDirection().equals((Object)Direction.SIBLING)) {
            if (nextNodeIndex < 0 || nextNodeIndex >= this.stateMachineNode.getPossibleNextStates().size()) {
                throw new IllegalArgumentException("The node index (" + nextNodeIndex + ") is not within the range of " + this.documentNode.getStateMachineNode().getPossibleNextStates().size() + " possible next states.");
            }
            if (newNext == null) {
                throw new IllegalArgumentException("The next node must be defined.");
            }
            if (!this.stateMachineNode.getPossibleNextStates().get(nextNodeIndex).equals(newNext.getStateMachineNode())) {
                throw new IllegalArgumentException("The next possible state at index " + nextNodeIndex + " does not match the state defined in the newNext.");
            }
        }
        this.nextNodeStateIndex = nextNodeIndex;
        this.nextNode = newNext;
    }

    XmlSchemaPathNode<U, V> setPreviousNode(XmlSchemaPathNode<U, V> newPrevious) {
        XmlSchemaPathNode<U, V> oldPrevious = this.prevNode;
        this.prevNode = newPrevious;
        return oldPrevious;
    }

    void update(Direction newDirection, XmlSchemaPathNode<U, V> newPrevious, XmlSchemaDocumentNode<U> newNode) {
        this.update(newDirection, newPrevious, newNode.getStateMachineNode());
        this.documentNode = newNode;
    }

    void update(Direction newDirection, XmlSchemaPathNode<U, V> newPrevious, XmlSchemaStateMachineNode newStateMachineNode) {
        this.direction = newDirection;
        this.documentNode = null;
        this.stateMachineNode = newStateMachineNode;
        this.nextNodeStateIndex = -1;
        this.iterationNum = 0;
        this.prevNode = newPrevious;
        this.nextNode = null;
        this.userDefinedContent = null;
    }

    public V getUserDefinedContent() {
        return this.userDefinedContent;
    }

    public void setUserDefinedContent(V content) {
        this.userDefinedContent = content;
    }

    public static enum Direction {
        PARENT(2),
        CHILD(0),
        CONTENT(3),
        SIBLING(1);

        final int rank;

        private Direction(int rank) {
            this.rank = rank;
        }

        int getRank() {
            return this.rank;
        }
    }
}

