/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.checksum;

import io.jhdf.checksum.JenkinsLookup3HashLittle;
import io.jhdf.exceptions.HdfChecksumMismatchException;
import java.nio.ByteBuffer;

public final class ChecksumUtils {
    private ChecksumUtils() {
        throw new AssertionError((Object)"No instances of ChecksumUtils");
    }

    public static void validateChecksum(ByteBuffer buffer) {
        int bytesToRead = buffer.limit() - 4 - buffer.position();
        byte[] bytes = new byte[bytesToRead];
        buffer.get(bytes);
        int calculatedChecksum = ChecksumUtils.checksum(bytes);
        int storedChecksum = buffer.getInt();
        if (calculatedChecksum != storedChecksum) {
            throw new HdfChecksumMismatchException(storedChecksum, calculatedChecksum);
        }
    }

    public static int checksum(ByteBuffer buffer) {
        return JenkinsLookup3HashLittle.hash(buffer);
    }

    public static int checksum(byte[] bytes) {
        return JenkinsLookup3HashLittle.hash(bytes);
    }
}

