/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.ObjectHeader;
import io.jhdf.api.Group;
import io.jhdf.dataset.DatasetBase;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.filter.PipelineFilterWithData;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class CompactDataset
extends DatasetBase {
    public CompactDataset(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfBackingStorage, address, name, parent, oh);
    }

    @Override
    public ByteBuffer getDataBuffer() {
        ByteBuffer data = this.getHeaderMessage(DataLayoutMessage.CompactDataLayoutMessage.class).getDataBuffer();
        this.convertToCorrectEndiness(data);
        return data;
    }

    @Override
    public ByteBuffer getSliceDataBuffer(long[] offset, int[] shape) {
        throw new UnsupportedHdfException("Compact datasets don't support slice reading");
    }

    @Override
    public List<PipelineFilterWithData> getFilters() {
        return Collections.emptyList();
    }
}

